/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.util.NiagaraDriverUtil;
import com.tridium.nd.virtual.BNiagaraVirtualChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BManualTriggerMode.make())", flags=4, override=true)
@NiagaraActions(value={@NiagaraAction(name="execute", flags=20, override=true), @NiagaraAction(name="updateReachableStations", parameterType="BBoolean", defaultValue="BBoolean.TRUE", flags=144, facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"%lexicon(niagaraDriver:reachableStations.appendNewStations)%\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"%lexicon(niagaraDriver:reachableStations.clearAndRebuild)%\")")})})
public final class BReachableStations
extends BAbstractDescriptor
implements BIRestrictedComponent,
BFoxClientConnection.Interest {
    @Generated
    public static final Property executionTime = BReachableStations.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()), null);
    @Generated
    public static final Action execute = BReachableStations.newAction((int)20, null);
    @Generated
    public static final Action updateReachableStations = BReachableStations.newAction((int)144, (BValue)BBoolean.TRUE, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(niagaraDriver:reachableStations.appendNewStations)%")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"%lexicon(niagaraDriver:reachableStations.clearAndRebuild)%"))));
    @Generated
    public static final Type TYPE = Sys.loadType(BReachableStations.class);
    private static final BIcon ICON = BIcon.std((String)"deviceData.png");
    private static final Logger FIND_LOG = Logger.getLogger("reachableStations.find");
    private static final Logger UPDATE_LOG = Logger.getLogger("reachableStations.update");

    @Generated
    public void updateReachableStations(BBoolean parameter) {
        this.invoke(updateReachableStations, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static Map<String, List<BReachableStationInfo>> findAllReachableStations(BObject base, boolean forceUpdate, boolean includeUnoperational, boolean includeVirtualDisabled, Context cx, String ... stationNamesToInclude) {
        return BReachableStations.findAllReachableStations(base, forceUpdate, includeUnoperational, includeVirtualDisabled, null, null, cx, stationNamesToInclude);
    }

    public static Map<String, List<BReachableStationInfo>> findAllReachableStations(BObject base, boolean forceUpdate, boolean includeUnoperational, boolean includeVirtualDisabled, Version reachableStationVersion, Version minVersionAlongRoute, Context cx, String ... stationNamesToInclude) {
        boolean proxySide;
        BNiagaraNetwork network = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(base, cx);
        boolean bl = proxySide = !network.isRunning();
        if (proxySide) {
            network.lease();
        }
        if (stationNamesToInclude != null && stationNamesToInclude.length > 1) {
            Arrays.sort(stationNamesToInclude);
        }
        HashMap<String, List<BReachableStationInfo>> allReachableStations = new HashMap<String, List<BReachableStationInfo>>();
        List devices = network.getBDeviceList();
        ArrayList<BReachableStations> updatingContainers = null;
        for (BDevice device : devices) {
            if (!(device instanceof BNiagaraStation)) continue;
            BNiagaraStation nStation = (BNiagaraStation)device;
            if (proxySide) {
                nStation.lease();
                nStation.getSysDef().lease();
                nStation.getSysDef().getReachableStations().lease(2);
            }
            BReachableStations reachableStationsContainer = nStation.getSysDef().getReachableStations();
            if (nStation.isDisabled() || !includeUnoperational && reachableStationsContainer.isUnoperational() || !includeVirtualDisabled && !nStation.getVirtualsEnabled() || !reachableStationsContainer.getPermissions(cx).hasOperatorRead()) continue;
            if (forceUpdate && !reachableStationsContainer.isUnoperational()) {
                reachableStationsContainer.updateReachableStations(BBoolean.TRUE);
                if (updatingContainers == null) {
                    updatingContainers = new ArrayList<BReachableStations>();
                }
                updatingContainers.add(reachableStationsContainer);
                continue;
            }
            BReachableStations.mergeReachableStations(allReachableStations, reachableStationsContainer, includeUnoperational, includeVirtualDisabled, reachableStationVersion, minVersionAlongRoute, cx, stationNamesToInclude);
        }
        if (updatingContainers != null) {
            long timeout = BNiagaraVirtualChannel.FIND_REACHABLE_STATIONS_TIMEOUT;
            if (timeout < 1L) {
                timeout = 120000L;
            }
            long startUpdateTicks = Clock.ticks();
            while (!updatingContainers.isEmpty() && Clock.ticks() - startUpdateTicks < timeout) {
                updatingContainers.removeIf(container -> {
                    boolean result;
                    boolean bl = result = container.getState() == BDescriptorState.idle;
                    if (result) {
                        if (proxySide) {
                            container.lease(2);
                        }
                        if (includeUnoperational || !container.isUnoperational()) {
                            BReachableStations.mergeReachableStations(allReachableStations, container, includeUnoperational, includeVirtualDisabled, reachableStationVersion, minVersionAlongRoute, cx, stationNamesToInclude);
                        }
                    }
                    return result;
                });
                if (updatingContainers.isEmpty()) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            updatingContainers.forEach(container -> {
                if (proxySide) {
                    container.lease(2);
                }
                if (includeUnoperational || !container.isUnoperational()) {
                    BReachableStations.mergeReachableStations(allReachableStations, container, includeUnoperational, includeVirtualDisabled, reachableStationVersion, minVersionAlongRoute, cx, stationNamesToInclude);
                }
            });
        }
        return allReachableStations;
    }

    public static void removeAllPersistedReachableStations(BObject base, Context cx) {
        boolean proxySide;
        BNiagaraNetwork network = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(base, cx);
        boolean bl = proxySide = !network.isRunning();
        if (proxySide) {
            network.lease();
        }
        List devices = network.getBDeviceList();
        for (BDevice device : devices) {
            BReachableStationInfo[] infos;
            BReachableStations reachableStationsContainer;
            if (!(device instanceof BNiagaraStation)) continue;
            BNiagaraStation nStation = (BNiagaraStation)device;
            if (proxySide) {
                nStation.lease();
                nStation.getSysDef().lease();
                nStation.getSysDef().getReachableStations().lease(2);
            }
            if (!(reachableStationsContainer = nStation.getSysDef().getReachableStations()).getPermissions(cx).hasAdminWrite()) continue;
            for (BReachableStationInfo info : infos = (BReachableStationInfo[])reachableStationsContainer.getChildren(BReachableStationInfo.class)) {
                try {
                    reachableStationsContainer.remove(info.getPropertyInParent(), cx);
                }
                catch (Exception e) {
                    if (!UPDATE_LOG.isLoggable(Level.FINE)) continue;
                    UPDATE_LOG.log(Level.FINE, "Unexpected exception trying to clear " + info.toPathString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateReachableStations(BBoolean appendOrReplace) {
        if (!this.isRunning()) {
            return;
        }
        if (this.isUnoperational()) {
            if (this.getState() == BDescriptorState.pending) {
                this.setState(BDescriptorState.idle);
                this.updateStatus();
            }
            return;
        }
        BFoxClientConnection connection = null;
        try {
            this.executeInProgress();
            BNiagaraStation station = this.getNiagaraStation();
            connection = station.getClientConnection();
            connection.engageNoRetry((BFoxClientConnection.Interest)this);
            BNiagaraVirtualChannel channel = (BNiagaraVirtualChannel)connection.getChannels().get("niagaraVirtual", BNiagaraVirtualChannel.TYPE);
            HashSet<String> stationsToExclude = new HashSet<String>();
            Collections.addAll(stationsToExclude, Sys.getStation().getStationName(), station.getStationName());
            List devices = station.getNiagaraNetwork().getBDeviceList();
            for (BDevice device : devices) {
                BNiagaraStation nStation;
                if (!(device instanceof BNiagaraStation) || !(nStation = (BNiagaraStation)device).getEnabled()) continue;
                stationsToExclude.add(nStation.getStationName());
            }
            List<BReachableStationInfo> reachableStationInfos = channel.findReachableStations(station, stationsToExclude);
            connection.disengage((BFoxClientConnection.Interest)this);
            HashMap<String, BReachableStationInfo> existingInfos = new HashMap<String, BReachableStationInfo>();
            SlotCursor c = this.getProperties();
            Object object = null;
            try {
                while (c.next(BReachableStationInfo.class)) {
                    BReachableStationInfo info = (BReachableStationInfo)c.get();
                    existingInfos.put(info.getName(), info);
                }
            }
            catch (Throwable info) {
                object = info;
                throw info;
            }
            finally {
                if (c != null) {
                    if (object != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable info) {
                            ((Throwable)object).addSuppressed(info);
                        }
                    } else {
                        c.close();
                    }
                }
            }
            if (UPDATE_LOG.isLoggable(Level.FINE)) {
                UPDATE_LOG.fine("Updating " + reachableStationInfos.size() + " reachable stations through station '" + station.getStationName() + '\'');
            }
            for (BReachableStationInfo info : reachableStationInfos) {
                String slotName = SlotPath.escape((String)info.getStationName());
                BReachableStationInfo existingInfo = (BReachableStationInfo)((Object)existingInfos.remove(slotName));
                if (existingInfo == null) {
                    this.add(slotName, (BValue)info);
                } else if (!appendOrReplace.getBoolean()) {
                    existingInfo.setStationName(info.getStationName());
                    existingInfo.setStationVersion(info.getStationVersion());
                    existingInfo.setRouteToStation(info.getRouteToStation());
                    existingInfo.setMinVersionAlongRoute(info.getMinVersionAlongRoute());
                    existingInfo.setVirtualSpaceOrd(info.getVirtualSpaceOrd());
                    existingInfo.setTimeToReach(info.getTimeToReach());
                } else if (existingInfo.getRouteToStation().equals(info.getRouteToStation())) {
                    existingInfo.setStationVersion(info.getStationVersion());
                    existingInfo.setMinVersionAlongRoute(info.getMinVersionAlongRoute());
                    existingInfo.setVirtualSpaceOrd(info.getVirtualSpaceOrd());
                    existingInfo.setTimeToReach(info.getTimeToReach());
                }
                if (!UPDATE_LOG.isLoggable(Level.FINE)) continue;
                String additionalMsg = existingInfo == null ? "\nThis is a new Reachable Station through station '" + station.getStationName() + '\'' : "\nThis Reachable Station was already known through station '" + station.getStationName() + '\'';
                UPDATE_LOG.fine(info.toDebugString() + additionalMsg);
            }
            if (!appendOrReplace.getBoolean()) {
                Set oldInfoNames = existingInfos.keySet();
                if (UPDATE_LOG.isLoggable(Level.FINE) && !oldInfoNames.isEmpty()) {
                    UPDATE_LOG.fine("The following Reachable Stations will be removed from station '" + station.getStationName() + "' because they are no longer reachable:\n" + String.join((CharSequence)"\n", oldInfoNames));
                }
                for (String oldInfoName : oldInfoNames) {
                    this.remove(oldInfoName);
                }
            }
            this.executeOk();
        }
        catch (Exception e) {
            this.executeFail(e);
        }
        finally {
            if (connection != null && connection.isEngaged((BFoxClientConnection.Interest)this)) {
                connection.disengage((BFoxClientConnection.Interest)this);
            }
        }
    }

    private static void mergeReachableStations(Map<String, List<BReachableStationInfo>> mergedReachableInfos, BReachableStations containerToMerge, boolean includeUnoperational, boolean includeVirtualDisabled, Version reachableStationVersion, Version minVersionAlongRoute, Context cx, String ... sortedStationNamesToInclude) {
        try (SlotCursor c = containerToMerge.getProperties();){
            while (c.next(BReachableStationInfo.class)) {
                BReachableStationInfo info = (BReachableStationInfo)c.get();
                if (!includeUnoperational && !info.getRouteEnabled() || !includeVirtualDisabled && info.getVirtualSpaceOrd().isNull() || !info.getPermissions(cx).hasOperatorRead() || sortedStationNamesToInclude != null && sortedStationNamesToInclude.length != 0 && Arrays.binarySearch(sortedStationNamesToInclude, info.getStationName()) < 0 || !BReachableStations.checkVersion(info, BReachableStationInfo.stationVersion, reachableStationVersion) || !BReachableStations.checkVersion(info, BReachableStationInfo.minVersionAlongRoute, minVersionAlongRoute)) continue;
                mergedReachableInfos.compute(info.getStationName(), (k, existingInfos) -> {
                    if (existingInfos == null || existingInfos.isEmpty()) {
                        if (FIND_LOG.isLoggable(Level.FINE)) {
                            FIND_LOG.fine("Found a possible route to a Reachable Station through '" + containerToMerge.getNiagaraStation().getStationName() + "':\n" + info.toDebugString());
                        }
                        ArrayList<BReachableStationInfo> newList = new ArrayList<BReachableStationInfo>();
                        newList.add(info);
                        return newList;
                    }
                    int insertionIdx = existingInfos.size();
                    if (info.getRouteEnabled() && !containerToMerge.isUnoperational()) {
                        String[] newStationRoute = NiagaraDriverUtil.parseRouteToStation(info.getRouteToStation(), false);
                        int newInfoHops = newStationRoute != null ? newStationRoute.length : 0;
                        for (int i = 0; i < existingInfos.size(); ++i) {
                            int existingInfoHops;
                            BReachableStationInfo existingInfo = (BReachableStationInfo)((Object)((Object)existingInfos.get(i)));
                            if (!existingInfo.getRouteEnabled() || ((BAbstractDescriptor)existingInfo.getParent()).isUnoperational()) {
                                insertionIdx = i;
                                break;
                            }
                            String[] existingStationRoute = NiagaraDriverUtil.parseRouteToStation(existingInfo.getRouteToStation(), false);
                            int n = existingInfoHops = existingStationRoute != null ? existingStationRoute.length : 0;
                            if (existingInfoHops <= newInfoHops && (existingInfoHops != newInfoHops || existingInfo.getTimeToReach().compareTo((Object)info.getTimeToReach()) <= 0)) continue;
                            insertionIdx = i;
                            break;
                        }
                    }
                    existingInfos.add(insertionIdx, info);
                    if (FIND_LOG.isLoggable(Level.FINE)) {
                        if (insertionIdx == 0) {
                            FIND_LOG.fine("Found a better route to a known Reachable Station through '" + containerToMerge.getNiagaraStation().getStationName() + "':\n" + info.toDebugString());
                        } else {
                            FIND_LOG.fine("Found another possible route to a Reachable Station through '" + containerToMerge.getNiagaraStation().getStationName() + "', but its route is not better than a previously found one:\n" + info.toDebugString());
                        }
                    }
                    return existingInfos;
                });
            }
        }
    }

    private static boolean checkVersion(BComponent comp, Property versionPropertyToCheck, Version minVersionRequired) {
        if (minVersionRequired != null && !minVersionRequired.isNull()) {
            try {
                Version version;
                String versionStr = comp.get(versionPropertyToCheck).toString();
                if (!versionStr.isEmpty() && (version = new Version(versionStr)).compareTo(minVersionRequired) < 0) {
                    return false;
                }
            }
            catch (Exception e) {
                if (FIND_LOG.isLoggable(Level.FINE)) {
                    String compId = comp.getSlotPath() != null ? comp.toPathString() : comp.toDebugString();
                    FIND_LOG.log(Level.FINE, "Could not parse version of " + versionPropertyToCheck + " property on: " + compId, e);
                }
                return true;
            }
        }
        return true;
    }

    public BNiagaraStation getNiagaraStation() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !parent.getType().is(BNiagaraStation.TYPE); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (BNiagaraStation)parent;
        }
        return null;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BReachableStationInfo || child instanceof BIMixIn;
    }

    public void updateStatus() {
        BDeviceExt[] exts;
        BStatus devStatus;
        int oldStatus;
        BNiagaraStation station = this.getNiagaraStation();
        int newStatus = oldStatus = this.getStatus().getBits();
        BStatus bStatus = devStatus = station == null ? BStatus.down : station.getStatus();
        newStatus = !this.getEnabled() || devStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = devStatus.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = devStatus.isFault() || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == oldStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        for (BDeviceExt ext : exts = (BDeviceExt[])DrUtil.getDecendantsByClass((BComponent)this, BDeviceExt.class)) {
            ext.updateStatus();
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        BNiagaraStation station = this.getNiagaraStation();
        if (station != null && (action.equals(execute) || action.equals(updateReachableStations))) {
            return super.post(execute, arg, cx);
        }
        return null;
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BNiagaraStation station = this.getNiagaraStation();
        if (station != null) {
            if (arg instanceof BBoolean) {
                station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, updateReachableStations, arg, cx));
            } else {
                station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
            }
        }
        return null;
    }

    public void doExecute() {
        this.doUpdateReachableStations(BBoolean.TRUE);
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BNiagaraSysDefDeviceExt.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        if (((BNiagaraSysDefDeviceExt)parent).getReachableStations() == this) {
            return;
        }
        try (SlotCursor slots = parent.getProperties();){
            while (slots.next(BReachableStations.class)) {
                if (slots.get() == this) continue;
                throw new IllegalChildException("baja", "IllegalExtraRestrictedComponent", new Object[]{this.getType(), parent.getType()});
            }
        }
    }

    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return ICON;
    }
}

