/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefVersion;
import com.tridium.nd.sysdef.ProviderSession;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="stationName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="alias", type="String", defaultValue="", flags=1), @NiagaraProperty(name="address", type="String", defaultValue="127.0.0.1", flags=1), @NiagaraProperty(name="foxPort", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="foxsPort", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="httpPort", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="httpsPort", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="niagaraDaemonPort", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="niagaraDaemonSslPort", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="services", type="BNameList", defaultValue="BNameList.DEFAULT", flags=5), @NiagaraProperty(name="subordinates", type="BNameList", defaultValue="BNameList.DEFAULT", flags=5), @NiagaraProperty(name="supervisors", type="BNameList", defaultValue="BNameList.DEFAULT", flags=5), @NiagaraProperty(name="stationVersion", type="BSysDefVersion", defaultValue="BSysDefVersion.DEFAULT", flags=5), @NiagaraProperty(name="networkVersion", type="BSysDefVersion", defaultValue="BSysDefVersion.DEFAULT", flags=5)})
public class BProviderStation
extends BComponent
implements BINiagaraStation {
    @Generated
    public static final Property stationName = BProviderStation.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property alias = BProviderStation.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property address = BProviderStation.newProperty((int)1, (String)"127.0.0.1", null);
    @Generated
    public static final Property foxPort = BProviderStation.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property foxsPort = BProviderStation.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property httpPort = BProviderStation.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property httpsPort = BProviderStation.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property niagaraDaemonPort = BProviderStation.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property niagaraDaemonSslPort = BProviderStation.newProperty((int)1, (int)-1, null);
    @Generated
    public static final Property services = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    @Generated
    public static final Property subordinates = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    @Generated
    public static final Property supervisors = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    @Generated
    public static final Property stationVersion = BProviderStation.newProperty((int)5, (BValue)BSysDefVersion.DEFAULT, null);
    @Generated
    public static final Property networkVersion = BProviderStation.newProperty((int)5, (BValue)BSysDefVersion.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BProviderStation.class);
    protected static final String BITS = "bits";
    private static final BIcon icon = BIcon.make((String)"module://niagaraDriver/rc/sysDefStation.png");
    private Object refLock = new Object();
    BNiagaraNetwork network = null;

    @Override
    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Generated
    public String getAlias() {
        return this.getString(alias);
    }

    @Generated
    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    @Generated
    public String getAddress() {
        return this.getString(address);
    }

    @Generated
    public void setAddress(String v) {
        this.setString(address, v, null);
    }

    @Generated
    public int getFoxPort() {
        return this.getInt(foxPort);
    }

    @Generated
    public void setFoxPort(int v) {
        this.setInt(foxPort, v, null);
    }

    @Generated
    public int getFoxsPort() {
        return this.getInt(foxsPort);
    }

    @Generated
    public void setFoxsPort(int v) {
        this.setInt(foxsPort, v, null);
    }

    @Generated
    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    @Generated
    public void setHttpPort(int v) {
        this.setInt(httpPort, v, null);
    }

    @Generated
    public int getHttpsPort() {
        return this.getInt(httpsPort);
    }

    @Generated
    public void setHttpsPort(int v) {
        this.setInt(httpsPort, v, null);
    }

    @Generated
    public int getNiagaraDaemonPort() {
        return this.getInt(niagaraDaemonPort);
    }

    @Generated
    public void setNiagaraDaemonPort(int v) {
        this.setInt(niagaraDaemonPort, v, null);
    }

    @Generated
    public int getNiagaraDaemonSslPort() {
        return this.getInt(niagaraDaemonSslPort);
    }

    @Generated
    public void setNiagaraDaemonSslPort(int v) {
        this.setInt(niagaraDaemonSslPort, v, null);
    }

    @Generated
    public BNameList getServices() {
        return (BNameList)this.get(services);
    }

    @Generated
    public void setServices(BNameList v) {
        this.set(services, (BValue)v, null);
    }

    @Generated
    public BNameList getSubordinates() {
        return (BNameList)this.get(subordinates);
    }

    @Generated
    public void setSubordinates(BNameList v) {
        this.set(subordinates, (BValue)v, null);
    }

    @Generated
    public BNameList getSupervisors() {
        return (BNameList)this.get(supervisors);
    }

    @Generated
    public void setSupervisors(BNameList v) {
        this.set(supervisors, (BValue)v, null);
    }

    @Generated
    public BSysDefVersion getStationVersion() {
        return (BSysDefVersion)this.get(stationVersion);
    }

    @Generated
    public void setStationVersion(BSysDefVersion v) {
        this.set(stationVersion, (BValue)v, null);
    }

    @Generated
    public BSysDefVersion getNetworkVersion() {
        return (BSysDefVersion)this.get(networkVersion);
    }

    @Generated
    public void setNetworkVersion(BSysDefVersion v) {
        this.set(networkVersion, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BProviderStation() {
    }

    public BProviderStation(String name) {
        this.setStationName(name);
    }

    public BIpHost getIpHost() {
        return new BIpHost(this.getAddress());
    }

    public final synchronized void updateStationVersion() {
        this.setStationVersion(this.getStationVersion().increment());
    }

    public final synchronized void updateNetworkVersion() {
        this.setNetworkVersion(this.getNetworkVersion().increment());
    }

    public final synchronized void resetVersions() {
        this.setStationVersion(BSysDefVersion.make());
        this.setNetworkVersion(BSysDefVersion.make());
    }

    public final void setResolved(BResolveBits resolved) {
        if (this.get(BITS) == null) {
            this.add(BITS, (BValue)resolved, 1);
        } else {
            this.set(BITS, (BValue)resolved);
        }
    }

    public final void removeResolved() {
        if (this.get(BITS) != null) {
            this.remove(BITS);
        }
    }

    public final BResolveBits getResolved() {
        BResolveBits bits = null;
        bits = (BResolveBits)this.get(BITS);
        return bits == null ? BResolveBits.NONE : bits;
    }

    public final boolean hasService(BTypeSpec service) {
        try {
            return this.getServices().contains(SlotPath.escape((String)service.encodeToString()));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final Array<BTypeSpec> getServiceTypes() {
        Array result = new Array(BTypeSpec.class);
        String[] escapedTypes = this.getServices().getNames();
        if (escapedTypes != null) {
            for (int i = 0; i < escapedTypes.length; ++i) {
                try {
                    result.add((Object)((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(SlotPath.unescape((String)escapedTypes[i]))));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public final void setServiceTypes(Array<BTypeSpec> types) {
        Object[] typeSpecs = types.trim();
        int len = typeSpecs != null ? typeSpecs.length : 0;
        String[] escaped = new String[len];
        for (int i = 0; i < len; ++i) {
            try {
                escaped[i] = SlotPath.escape((String)((BTypeSpec)typeSpecs[i]).encodeToString());
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        BNameList list = BNameList.make((String[])escaped);
        if (!this.getServices().equals((Object)list)) {
            this.setServices(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRef(String stationName, BStationRole role) {
        if (role.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            BNameList refs = this.getList(role);
            if (!refs.contains(stationName)) {
                this.setList(BNameList.union((BNameList)refs, (BNameList)BNameList.make((String)stationName)), role);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRef(String stationName, BStationRole role) {
        if (role.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            BNameList refs = this.getList(role);
            if (refs.contains(stationName)) {
                this.setList(BNameList.difference((BNameList)refs, (BNameList)BNameList.make((String)stationName)), role);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getStationRefs(BStationRole role) {
        if (role.equals((Object)BStationRole.peer)) {
            return new String[0];
        }
        Object object = this.refLock;
        synchronized (object) {
            return this.getList(role).getNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReferenced(String stationName, BStationRole role) {
        if (role.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            return this.getList(role).contains(stationName);
        }
    }

    protected final void setList(BNameList toSet, BStationRole role) {
        switch (role.getOrdinal()) {
            case 1: {
                this.setSubordinates(toSet);
                break;
            }
            case 2: {
                this.setSupervisors(toSet);
                break;
            }
            default: {
                throw new IllegalStateException("Role: " + role.toString() + " not supported.");
            }
        }
    }

    protected final BNameList getList(BStationRole role) {
        switch (role.getOrdinal()) {
            case 1: {
                return this.getSubordinates();
            }
            case 2: {
                return this.getSupervisors();
            }
        }
        throw new IllegalStateException("Role: " + role.toString() + " not supported.");
    }

    ProviderSession getProviderSession() {
        if (this.network != null) {
            return (ProviderSession)this.network.createSysDefSession(null);
        }
        BNiagaraNetwork net = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        return (ProviderSession)net.createSysDefSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFoxSession getFoxSession() {
        try (ProviderSession ps = null;){
            BFoxSession session;
            ps = this.getProviderSession();
            BFoxSession bFoxSession = session = ps.getFoxSession(this);
            return bFoxSession;
        }
    }

    @Override
    public boolean isEngaged(String interest) {
        return this.getFoxSession().isEngaged(interest);
    }

    @Override
    public void engageNoRetry(String interest) throws Exception {
        this.getFoxSession().engageNoRetry(interest);
    }

    @Override
    public void engageNoRetry(String interest, long failFastPeriod) throws Exception {
        BFoxSession.engageNoRetry((BFoxSession)this.getFoxSession(), (String)interest, (long)failFastPeriod);
    }

    @Override
    public void engageRetry(String interest) throws Exception {
        BFoxSession.engageRetry((BFoxSession)this.getFoxSession(), (String)interest);
    }

    @Override
    public void disengage(String interest) {
        this.getFoxSession().disengage(interest);
    }

    @Override
    public BValue invokeAction(BOrd componentOrd, String actionName, BValue arg) throws Exception {
        return ((BPointChannel)this.getFoxSession().getConnection().getChannels().get("point", BPointChannel.TYPE)).invoke(componentOrd.encodeToString(), actionName, arg);
    }

    public void spy(SpyWriter out) throws Exception {
        Array services = this.getServiceTypes().sort();
        out.startTable(true);
        out.w((Object)"<tr>");
        out.thTitle((Object)(services.size() + " Services"));
        out.w((Object)"</tr>");
        for (BTypeSpec service : services) {
            out.w((Object)"<tr>").td((Object)service).w((Object)"</tr>");
        }
        out.endTable();
        super.spy(out);
    }

    public String toString(Context cx) {
        StringBuilder buf = new StringBuilder().append(this.getStationName()).append(" [ ").append(BOrd.make((BOrd)this.getIpHost().getAbsoluteOrd(), (String)("fox:" + this.getFoxPort())).toString(cx));
        if (this.getFoxsPort() != -1) {
            buf.append(", ").append(BOrd.make((BOrd)this.getIpHost().getAbsoluteOrd(), (String)("foxs:" + this.getFoxsPort())).toString(cx));
        }
        buf.append(" ]");
        return buf.toString();
    }

    public BIcon getIcon() {
        return icon;
    }
}

