/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxServerConnection;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.SlotCursor;

public class SpyConnection
extends Spy {
    static DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    public final String title;
    public final BFoxConnection conn;

    public SpyConnection(String title, BFoxConnection conn) {
        this.title = title;
        this.conn = conn;
    }

    public void write(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)this.title, 2);
        out.prop((Object)"currentTime", (Object)Clock.time());
        if (this.conn == null) {
            out.trTitle((Object)"Properties", 2);
            out.prop((Object)BFoxServerConnection.state.getName(), (Object)BFoxServerConnection.state.getDefaultValue());
            out.endProps();
        } else {
            this.writeInterests(out);
            out.trTitle((Object)"Properties", 2);
            SlotCursor c = this.conn.loadSlots().getProperties();
            while (c.next()) {
                out.prop((Object)c.property().getName(), (Object)c.get());
            }
            out.trTitle((Object)"Session", 2);
            FoxSession session = this.conn.session();
            if (session == null) {
                out.prop((Object)"null", (Object)"");
            } else {
                session.dumpProps((PrintWriter)out);
            }
            out.endProps();
            this.writeInterestLog(out);
        }
    }

    private void writeInterests(SpyWriter out) throws Exception {
        if (!(this.conn instanceof BFoxClientConnection)) {
            return;
        }
        BFoxClientConnection conn = (BFoxClientConnection)this.conn;
        BFoxClientConnection.Interest[] interests = conn.getInterests();
        out.trTitle((Object)("Interests [" + interests.length + "] (see log below)"), 2);
        for (int i = 0; i < interests.length; ++i) {
            out.prop((Object)("interest[" + i + "]"), (Object)interests[i]);
        }
    }

    private void writeInterestLog(SpyWriter out) {
        if (!(this.conn instanceof BFoxClientConnection)) {
            return;
        }
        BFoxClientConnection conn = (BFoxClientConnection)this.conn;
        BFoxClientConnection.InterestLogItem[] log = conn.getInterestLog();
        out.startTable(true);
        out.trTitle((Object)("Interest Log [" + log.length + "]"), 4);
        out.w((Object)"<tr>").th((Object)"Interest").th((Object)"Engage").th((Object)"Disengage").th((Object)"Duration").w((Object)"</tr>\n");
        for (int i = 0; i < log.length; ++i) {
            String duration;
            String disengage;
            long ticks = Clock.ticks();
            long start = log[i].startTicks;
            long end = log[i].endTicks;
            String engage = SpyConnection.toTime(start);
            if (end == 0L) {
                disengage = "Active";
                duration = BRelTime.toString((long)(ticks - start));
            } else {
                disengage = SpyConnection.toTime(end);
                duration = BRelTime.toString((long)(end - start));
            }
            out.tr((Object)log[i].interest, (Object)engage, (Object)disengage, (Object)duration);
        }
        out.endTable();
    }

    static String toTime(long ticks) {
        return format.format(new Date(Clock.millis() - Clock.ticks() + ticks));
    }
}

