/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.history;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.history.BHistory;
import com.tridium.history.RecordInputCursor;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridium.nd.history.BNiagaraHistoryImport;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistoryQuery;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="historyId", type="BHistoryId", defaultValue="BHistoryId.NULL", flags=7, override=true), @NiagaraProperty(name="systemTagPatterns", type="String", defaultValue="")})
@NiagaraAction(name="pollSubscribedHistories", flags=20)
public class BNiagaraSystemHistoryImport
extends BNiagaraHistoryImport {
    @Generated
    public static final Property historyId = BNiagaraSystemHistoryImport.newProperty((int)7, (BValue)BHistoryId.NULL, null);
    @Generated
    public static final Property systemTagPatterns = BNiagaraSystemHistoryImport.newProperty((int)0, (String)"", null);
    @Generated
    public static final Action pollSubscribedHistories = BNiagaraSystemHistoryImport.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraSystemHistoryImport.class);

    @Generated
    public String getSystemTagPatterns() {
        return this.getString(systemTagPatterns);
    }

    @Generated
    public void setSystemTagPatterns(String v) {
        this.setString(systemTagPatterns, v, null);
    }

    @Generated
    public void pollSubscribedHistories() {
        this.invoke(pollSubscribedHistories, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        if (execute == action) {
            if (asyncHistoryPoll == cx) {
                BNiagaraStation station = (BNiagaraStation)this.getDevice();
                if (station != null) {
                    station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, pollSubscribedHistories, null, cx));
                }
                return null;
            }
            if (syncHistoryPoll == cx) {
                this.doPollSubscribedHistories();
                return null;
            }
        }
        return super.postExecute(action, arg, cx);
    }

    public void doPollSubscribedHistories() {
        this.importHistories(true);
    }

    @Override
    public void doExecute() {
        this.importHistories(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importHistories(boolean onlySubscribedHistories) {
        if (this.executeInProgress.getAndSet(true)) {
            if (this.getState() == BDescriptorState.pending) {
                this.setState(BDescriptorState.idle);
            }
            return;
        }
        try {
            BHistoryConfig[] matchingConfigs;
            BHistoryChannel channel;
            BHistoryDatabase db;
            BNiagaraHistoryDeviceExt devicelet;
            block38: {
                String list;
                block37: {
                    block36: {
                        this.executeInProgress();
                        devicelet = (BNiagaraHistoryDeviceExt)this.getDeviceExt();
                        try {
                            devicelet.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                        }
                        catch (Exception e) {
                            this.executeFail(e);
                            if (devicelet.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                            }
                            this.executeInProgress.set(false);
                            return;
                        }
                        list = this.getSystemTagPatterns();
                        if (list != null && list.length() >= 1) break block36;
                        this.executeFail("System Tag Patterns is null.");
                        devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                        return;
                    }
                    BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                    db = service.getDatabase();
                    if (db != null) break block37;
                    this.executeFail("Local history database not available.");
                    devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                    return;
                }
                channel = devicelet.getClientHistoryChannel();
                matchingConfigs = channel.getConfigs(list);
                if (matchingConfigs != null && matchingConfigs.length >= 1) break block38;
                this.executeFail("No matching histories found for System Tag Patterns provided.");
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                return;
            }
            try {
                int len = matchingConfigs.length;
                try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                    for (int i = 0; i < len; ++i) {
                        BIHistory history;
                        BHistoryConfig config = this.makeLocalConfig(matchingConfigs[i]);
                        BHistoryId matchingId = matchingConfigs[i].getId();
                        if (onlySubscribedHistories && (!conn.exists(matchingId) || !((history = conn.getHistory(matchingId)) instanceof BHistory) || !((BHistory)history).isSubscribed())) continue;
                        if (!conn.exists(matchingId)) {
                            conn.createHistory(config);
                        } else {
                            conn.reconfigureHistory(config);
                        }
                        history = conn.getHistory(matchingId);
                        BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                        BAbsTime startTime = lastTimestamp.add(BRelTime.make((long)1L));
                        Cursor cursor = channel.timeQuery(matchingId, startTime, null, this.getOnDemandPollEnabled() && this.updateHistorySubscriptionCount(0) > 0, HistoryQuery.makeExcludeArchiveDataContext(null));
                        ((RecordInputCursor)cursor).setHistoryVersion(this.getHistoryVersion());
                        while (cursor.next()) {
                            BHistoryRecord rec = (BHistoryRecord)cursor.get();
                            rec.setHistoryVersion(2);
                            conn.append(history, (BIHistoryRecordSet)rec);
                        }
                    }
                }
                this.executeOk();
            }
            catch (Exception e) {
                try {
                    this.executeFail(e);
                }
                catch (Throwable throwable) {
                    devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                    throw throwable;
                }
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                this.executeInProgress.set(false);
                return;
            }
            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
        }
        finally {
            this.executeInProgress.set(false);
        }
    }
}

