/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.discover;

import com.tridium.driver.util.DriverUtil;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.nd.discover.NiagaraLearnUtil;
import java.io.IOException;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNiagaraHistoryExportRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraHistoryExportRpc.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static JSONObject getExportHistoryDiscoveryRpc(String ord, Context context) throws Exception {
        OrdTarget ordTarget = BOrd.make((String)ord).resolve(null, context);
        if (!ordTarget.canRead()) {
            throw new PermissionException();
        }
        BComponent target = (BComponent)ordTarget.get();
        Object[] exportHistories = NiagaraLearnUtil.getExportHistoryDiscovery(target);
        JSONObject exportHistoryJson = new JSONObject();
        JSONArray devicesJson = new JSONArray();
        for (Object exportHistory : exportHistories) {
            BHistoryDevice device = (BHistoryDevice)exportHistory;
            if (!device.getPermissions(context).hasOperatorRead()) continue;
            JSONObject deviceJson = new JSONObject();
            deviceJson.put("deviceName", (Object)device.getDeviceName());
            deviceJson.put("icon", (Object)device.getIcon().encodeToString());
            JSONArray childrenJson = BNiagaraHistoryExportRpc.getChildren(device, context);
            deviceJson.put("navChildren", (Object)childrenJson);
            devicesJson.put((Object)deviceJson);
        }
        exportHistoryJson.put("devices", (Object)devicesJson);
        return exportHistoryJson;
    }

    private static JSONArray getChildren(Object target, Context context) throws IOException {
        Object[] children;
        JSONArray childrenJson = new JSONArray();
        for (Object child : children = DriverUtil.getHistoryChildren((Object)target)) {
            BIHistory childHistory = (BIHistory)child;
            if (!childHistory.getPermissions(context).hasOperatorRead()) continue;
            JSONObject childJson = new JSONObject();
            childJson.put("displayName", (Object)childHistory.getDisplayName(context));
            childJson.put("id", (Object)childHistory.getId().encodeToString());
            childJson.put("systemTags", (Object)childHistory.getConfig().getSystemTags().encodeToString());
            childJson.put("icon", (Object)childHistory.getNavIcon().encodeToString());
            childrenJson.put((Object)childJson);
        }
        return childrenJson;
    }
}

