/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.sys.station.BStationScheme;
import com.tridium.util.IFoxSession;
import com.tridium.virtual.BUnresolvedVirtualHandler;
import java.util.List;
import javax.baja.driver.BDevice;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

@NiagaraType(ordScheme="nspace")
@NiagaraSingleton
public class BNSpaceScheme
extends BSpaceScheme {
    @Generated
    public static final BNSpaceScheme INSTANCE = new BNSpaceScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BNSpaceScheme.class);
    private static final NSpaceQuery QUERY = new NSpaceQuery("");

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BNSpaceScheme() {
        super("nspace");
    }

    private BNSpaceScheme(String schemeId) {
        super(schemeId);
    }

    public OrdQuery parse(String queryBody) {
        if (queryBody.isEmpty()) {
            return QUERY;
        }
        return new NSpaceQuery(queryBody);
    }

    public Type getSpaceType() {
        return BComponentSpace.TYPE;
    }

    protected String getNavChildSpaceId() {
        return BStationScheme.INSTANCE.getId();
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query, BSpace space) {
        Exception ex;
        String body;
        block13: {
            body = query.getBody();
            if (body.isEmpty()) {
                return new OrdTarget(base, (BObject)space);
            }
            BObject baseObj = base.get();
            BISession session = this.toSession(baseObj);
            boolean clientSide = session instanceof IFoxSession;
            String defaultStationName = clientSide ? ((IFoxSession)session).getStationName() : Sys.getStation().getStationName();
            if (body.equals(defaultStationName)) {
                return new OrdTarget(base, (BObject)space);
            }
            ex = null;
            try {
                BDevice station;
                BNiagaraNetwork network = (BNiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(baseObj);
                BDevice bDevice = clientSide ? BNSpaceScheme.findStation((BComponent)network, body, !network.isRunning(), false, true) : (station = (BDevice)network.getStation(body));
                if (station != null && station.getEnabled()) {
                    return new OrdTarget(base, BOrd.make((BOrd)station.getAbsoluteOrd(), (String)"slot:virtual|virtual:").get(baseObj));
                }
            }
            catch (Exception e) {
                ex = e;
            }
            try {
                List<BReachableStationInfo> reachableStationInfos = BReachableStations.findAllReachableStations(baseObj, false, true, false, (Context)base, body).get(body);
                if (reachableStationInfos != null && !reachableStationInfos.isEmpty()) {
                    for (BReachableStationInfo info : reachableStationInfos) {
                        if (!info.getRouteEnabled() || info.getReachableStationsContainer().isDisabled()) continue;
                        try {
                            return new OrdTarget(base, info.getVirtualSpaceOrd().get(baseObj, (Context)base));
                        }
                        catch (Exception e) {
                            OrdTarget target = BUnresolvedVirtualHandler.getFailedVirtualQuery((OrdTarget)base, (OrdQuery)query, (BVirtualGateway)info.getReachableStationsContainer().getNiagaraStation().getVirtual());
                            if (target != null) {
                                return target;
                            }
                            if (ex != null) continue;
                            ex = e;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (ex != null) break block13;
                ex = e;
            }
        }
        if (ex == null || ex instanceof NullPointerException) {
            throw new UnresolvedException("Could not find active space for station " + body);
        }
        throw new UnresolvedException("Could not find active space for station " + body, (Throwable)ex);
    }

    static BNiagaraStation findStation(BComponent comp, String stationName, boolean lease, boolean excludeConfigFault, boolean excludeDisabled) {
        if (lease) {
            comp.lease();
        }
        SlotCursor cursor = comp.getProperties();
        while (cursor.nextComponent()) {
            BNiagaraStation station;
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(BNiagaraStation.TYPE)) {
                station = (BNiagaraStation)kid;
                if (excludeDisabled && !station.getEnabled() || excludeConfigFault && station.isFault() && !station.isFatalFault() || !stationName.equals(kid.getName())) continue;
                return station;
            }
            station = BNSpaceScheme.findStation(kid, stationName, lease, excludeConfigFault, excludeDisabled);
            if (station == null) continue;
            return station;
        }
        return null;
    }

    private static class NSpaceQuery
    implements OrdQuery {
        private final String body;

        public NSpaceQuery(String body) {
            this.body = body;
        }

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return false;
        }

        public void normalize(OrdQueryList list, int index) {
            list.shiftToSession(index);
        }

        public void normalize(OrdQueryList list, int index, Context cx) {
            OrdQuery nextQuery;
            int nextIdx;
            if (cx == OrdQuery.RESOLVING_ORD_CX && (nextIdx = index + 1) < list.size() && (nextQuery = list.get(nextIdx)) instanceof SlotPath) {
                SlotPath path = (SlotPath)nextQuery;
                if (path.isAbsolute()) {
                    String body = path.getBody();
                    if (body.startsWith("/")) {
                        if (body.length() == 1) {
                            list.replace(nextIdx, (OrdQuery)SlotPath.EMPTY_SLOT_PATH);
                        } else {
                            list.replace(nextIdx, path.makePath(body.substring(1)));
                        }
                    }
                } else if (path instanceof VirtualPath && path.getBody().isEmpty()) {
                    list.remove(nextIdx);
                }
            }
            this.normalize(list, index);
        }

        public String getScheme() {
            return "nspace";
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return "nspace:" + this.body;
        }
    }
}

