/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.spy.SpyCyclicThreadPoolWorker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
public class BCyclicThreadPoolWorker
extends BThreadPoolWorker
implements Runnable {
    @Generated
    public static final Type TYPE = Sys.loadType(BCyclicThreadPoolWorker.class);
    Hashtable<Object, RegisteredObjectInfo> registeredObjects = new Hashtable();
    String threadNamePrefix;
    ThreadGroup threadGroup;
    int queueSize = AccessController.doPrivileged(() -> (int)Integer.getInteger("niagara.network.workerPool.queueSize", 150000));
    ThreadPoolWorker worker;
    Queue queue;
    boolean isAlive;
    Thread cycleMonitor;
    long lastScanTicks = 0L;
    long minScanTicks = Long.MAX_VALUE;
    long maxScanTicks = Long.MIN_VALUE;
    long sumScanTicks = 0L;
    long numScans = 0L;
    long lastSleepTicks = 0L;
    long sumSleepTicks = 0L;
    int maxWorkInQueue = 0;
    private static boolean spyWorkEnabled = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.network.spywork"));
    private static long spyWorkLimit = AccessController.doPrivileged(() -> (long)Long.getLong("niagara.network.spywork.limit", 1000L));
    private static boolean spyWorkStackTracesEnabled = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.network.spywork.stacktrace"));
    private Map<String, SpyWorkInfo> spyWorkMap = spyWorkEnabled ? new SpyWorkMap() : null;
    private volatile long maxWorkTime = 0L;
    private volatile long minWorkTime = Long.MAX_VALUE;
    private volatile String maxWorkName = " - ";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCyclicThreadPoolWorker() {
    }

    public BCyclicThreadPoolWorker(String threadNamePrefix, int maxThreads) {
        this(null, threadNamePrefix, maxThreads);
    }

    public BCyclicThreadPoolWorker(ThreadGroup threadGroup, String threadNamePrefix, int maxThreads) {
        super(maxThreads);
        this.threadGroup = threadGroup;
        this.threadNamePrefix = threadNamePrefix;
    }

    public BCyclicThreadPoolWorker(ThreadGroup threadGroup, String threadNamePrefix, int maxThreads, int queueSize) {
        this(threadGroup, threadNamePrefix, maxThreads);
        this.queueSize = queueSize;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(Object work, long cycleTime) {
        Hashtable<Object, RegisteredObjectInfo> hashtable = this.registeredObjects;
        synchronized (hashtable) {
            RegisteredObjectInfo info;
            if (this.worker == null) {
                this.queue = this.queueSize > 0 ? new CoalesceQueue(this.queueSize) : new CoalesceQueue();
                this.worker = new ThreadPoolWorker((Worker.ITodo)this.queue);
                this.worker.setMaxThreads(this.getMaxThreads());
                ThreadGroup tGroup = this.threadGroup != null ? this.threadGroup : Thread.currentThread().getThreadGroup();
                this.worker.start(tGroup, this.getWorkerThreadName());
                this.isAlive = true;
                this.cycleMonitor = new Thread(tGroup, this, this.getWorkerThreadName() + "_CycleMonitor");
                this.cycleMonitor.setDaemon(true);
                this.cycleMonitor.start();
            }
            if (work instanceof Runnable) {
                work = this.findWork((Runnable)work);
            }
            info = (info = this.registeredObjects.remove(work)) == null ? new RegisteredObjectInfo(cycleTime) : new RegisteredObjectInfo(cycleTime, info.lastExecuteTicks);
            this.registeredObjects.put(work, info);
            this.registeredObjects.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregister(Object work) {
        Hashtable<Object, RegisteredObjectInfo> hashtable = this.registeredObjects;
        synchronized (hashtable) {
            if (work instanceof Runnable) {
                work = this.findWork((Runnable)work);
            }
            this.registeredObjects.remove(work);
            if (this.registeredObjects.isEmpty()) {
                this.isAlive = false;
                if (this.cycleMonitor != null) {
                    this.cycleMonitor.interrupt();
                }
                this.cycleMonitor = null;
                if (this.worker != null) {
                    try {
                        this.worker.stop();
                    }
                    finally {
                        this.worker = null;
                    }
                }
                if (this.queue != null) {
                    this.queue.clear();
                }
                this.queue = null;
            }
            this.registeredObjects.notifyAll();
        }
    }

    private Work findWork(Runnable runnable) {
        Enumeration<Object> keys = this.registeredObjects.keys();
        while (keys.hasMoreElements()) {
            Object obj = keys.nextElement();
            if (!(obj instanceof Work) || ((Work)obj).runnable != runnable) continue;
            return (Work)obj;
        }
        return new Work(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(Object work) {
        if (this.queue != null) {
            if (spyWorkEnabled && work != null) {
                SpyWorkInfo info;
                Map<String, SpyWorkInfo> map = this.spyWorkMap;
                synchronized (map) {
                    String key = work.toString();
                    info = this.spyWorkMap.get(key);
                    if (info == null) {
                        info = new SpyWorkInfo();
                        info.name = key;
                        if (spyWorkStackTracesEnabled) {
                            StringWriter out = new StringWriter();
                            new Exception().printStackTrace(new PrintWriter(out));
                            info.stackTrace = out.toString();
                        }
                        this.spyWorkMap.put(key, info);
                    } else {
                        info.count++;
                        BAbsTime now = BAbsTime.now();
                        if (info.count > 1L) {
                            SpyWorkInfo spyWorkInfo = info;
                            spyWorkInfo.totalMillisBtwnSubmits = spyWorkInfo.totalMillisBtwnSubmits + (now.getMillis() - info.last.getMillis());
                        }
                        info.last = now;
                    }
                }
                if (work instanceof Runnable) {
                    work = work instanceof ICoalesceable ? new SpyWorkWrapperCoaleasable((Runnable)work, info) : new SpyWorkWrapper((Runnable)work, info);
                }
            }
        } else {
            throw new NotRunningException();
        }
        this.queue.enqueue(work);
        this.maxWorkInQueue = Math.max(this.maxWorkInQueue, this.queue.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Hashtable<Object, RegisteredObjectInfo> hashtable = this.registeredObjects;
        synchronized (hashtable) {
            while (this.isAlive) {
                try {
                    long scanStartTicks = Clock.ticks();
                    long sleepTime = -1L;
                    Enumeration<Object> keys = this.registeredObjects.keys();
                    long minCycleTicks = 100L;
                    while (keys.hasMoreElements()) {
                        Object obj = keys.nextElement();
                        RegisteredObjectInfo info = this.registeredObjects.get(obj);
                        if (info.cycleTime <= 0L) continue;
                        minCycleTicks = Math.min(info.cycleTime, minCycleTicks);
                        long lastExecute = info.lastExecuteTicks;
                        boolean isWork = obj instanceof Work;
                        if (isWork) {
                            Work work = (Work)obj;
                            if (work.alive) continue;
                            lastExecute = work.lastExecuteTicks;
                        }
                        long currentTicks = Clock.ticks();
                        if (lastExecute < 0L || currentTicks - lastExecute >= info.cycleTime) {
                            this.process(obj);
                            info.lastExecuteTicks = currentTicks;
                        }
                        long ticksTillNextExecute = info.lastExecuteTicks + info.cycleTime - currentTicks;
                        if (sleepTime < 0L) {
                            sleepTime = ticksTillNextExecute;
                            continue;
                        }
                        sleepTime = Math.min(sleepTime, ticksTillNextExecute);
                    }
                    if (sleepTime < 0L) {
                        sleepTime = minCycleTicks;
                    } else if (sleepTime < 100L) {
                        sleepTime = 100L;
                    }
                    this.lastScanTicks = Clock.ticks() - scanStartTicks;
                    this.minScanTicks = Math.min(this.lastScanTicks, this.minScanTicks);
                    this.maxScanTicks = Math.max(this.lastScanTicks, this.maxScanTicks);
                    this.sumScanTicks += this.lastScanTicks;
                    this.lastSleepTicks = sleepTime;
                    this.sumSleepTicks += this.lastSleepTicks;
                    ++this.numScans;
                    this.registeredObjects.wait(sleepTime);
                }
                catch (InterruptedException scanStartTicks) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Worker getWorker() {
        return this.worker;
    }

    protected void startWorker() {
    }

    protected void stopWorker() {
    }

    protected String getWorkerThreadName() {
        if (this.threadNamePrefix != null) {
            return this.threadNamePrefix;
        }
        return super.getWorkerThreadName();
    }

    public void spy(SpyWriter out) throws Exception {
        new SpyCyclicThreadPoolWorker((BNiagaraNetwork)this.getParent()).write(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spyRegisteredOverview(SpyWriter out) throws Exception {
        Hashtable<Object, RegisteredObjectInfo> hashtable = this.registeredObjects;
        synchronized (hashtable) {
            double avgScan;
            out.startProps();
            out.trTitle((Object)"CyclicThreadPoolWorker", 2);
            int size = this.registeredObjects.size();
            out.prop((Object)"WorkWaitingInQueue", (Object)("" + (this.queue != null ? this.queue.size() : 0)));
            out.prop((Object)"MaxWorkWaitingInQueue", (Object)("" + this.maxWorkInQueue));
            out.prop((Object)"RegisteredObjects", (Object)("" + size + " (see table below for complete listing)"));
            out.prop((Object)"ScansCompleted", (Object)("" + this.numScans));
            out.prop((Object)"LastScanTicks", (Object)(this.lastScanTicks + " ms"));
            out.prop((Object)"MinScanTicks", (Object)(this.minScanTicks + " ms"));
            out.prop((Object)"MaxScanTicks", (Object)(this.maxScanTicks + " ms"));
            if (this.numScans > 0L) {
                avgScan = (double)this.sumScanTicks / (double)this.numScans;
                out.prop((Object)"AvgScanTicks", (Object)(avgScan + " ms"));
            }
            out.prop((Object)"LastSleepTicks", (Object)(this.lastSleepTicks + " ms"));
            if (this.numScans > 0L) {
                avgScan = (double)this.sumSleepTicks / (double)this.numScans;
                out.prop((Object)"AvgSleepTicks", (Object)(avgScan + " ms"));
            }
            out.endProps();
        }
    }

    public void spyRegisteredObjects(SpyWriter out) throws Exception {
        int size = this.registeredObjects.size();
        if (size > 0) {
            out.startTable(true);
            out.trTitle((Object)("Registered Objects: " + BAbsTime.make()), 6);
            out.w((Object)"<tr>").th((Object)"Object").th((Object)"CycleTime").th((Object)"LastCycleExecute").th((Object)"alive").th((Object)"lastWorkExecute").th((Object)"ticksBtwnExecutes").w((Object)"</tr>\n");
            Enumeration<Object> keys = this.registeredObjects.keys();
            BAbsTime now = BAbsTime.now();
            long nowTicks = Clock.ticks();
            BFacets showMillis = BFacets.make((String)"showMilliseconds", (boolean)true);
            while (keys.hasMoreElements()) {
                Object obj = keys.nextElement();
                boolean isWork = obj instanceof Work;
                Work w = isWork ? (Work)obj : null;
                RegisteredObjectInfo info = this.registeredObjects.get(obj);
                out.tr((Object)obj.toString(), (Object)(info.cycleTime > 0L ? "" + info.cycleTime + " ms" : "n/a"), (Object)(info.cycleTime > 0L && info.lastExecuteTicks >= 0L ? BAbsTime.now().subtract(BRelTime.make((long)(Clock.ticks() - info.lastExecuteTicks))).toString((Context)showMillis) : "n/a"), (Object)(isWork ? "" + w.alive : "n/a"), (Object)(isWork && w.lastExecuteTicks >= 0L ? BAbsTime.now().subtract(BRelTime.make((long)(Clock.ticks() - w.lastExecuteTicks))).toString((Context)showMillis) : "n/a"), (Object)(isWork && w.ticksBetweenExecutes >= 0L ? "" + w.ticksBetweenExecutes : "n/a"));
            }
            out.endTable();
        }
    }

    public void spyWorker(SpyWriter out) throws Exception {
        super.spy(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spyWorkInfo(SpyWriter out) {
        out.startProps().prop((Object)"Spy Work: ", (Object)(spyWorkEnabled ? "Enabled" : "Disabled"));
        if (!spyWorkEnabled) {
            out.endProps();
            return;
        }
        out.prop((Object)"Spy Work Limit: ", (Object)String.valueOf(spyWorkLimit)).prop((Object)"Max Work Time: ", (Object)BRelTime.make((long)this.maxWorkTime)).prop((Object)"Min Work Time: ", (Object)BRelTime.make((long)this.minWorkTime)).prop((Object)"Max Work: ", (Object)this.maxWorkName).endProps();
        out.startTable(true);
        out.trTitle((Object)"Processed Work", 7);
        out.w((Object)"<tr>").thTitle((Object)"Index").thTitle((Object)"Name").thTitle((Object)"Count").thTitle((Object)"Last Submit").thTitle((Object)"Max").thTitle((Object)"Min").thTitle((Object)"Avg Millis Btwn Submits").w((Object)"</tr>");
        Map<String, SpyWorkInfo> map = this.spyWorkMap;
        synchronized (map) {
            int index = 0;
            for (String name : this.spyWorkMap.keySet()) {
                SpyWorkInfo info = this.spyWorkMap.get(name);
                out.tr().td((Object)String.valueOf(++index));
                out.td();
                if (spyWorkStackTracesEnabled) {
                    out.a("spy:/niagaraNetwork/threadPoolWorker/work/stack" + index, (Object)name);
                } else {
                    out.safe((Object)name);
                }
                out.endTd();
                out.td((Object)String.valueOf(info.count)).td((Object)info.last.toTimeString((Context)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE))).td((Object)BRelTime.make((long)info.max)).td((Object)BRelTime.make((long)info.min)).td((Object)(info.count > 0L ? String.valueOf(info.totalMillisBtwnSubmits / info.count) : "-")).endTr();
            }
        }
        out.endTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spyWorkStackTrace(int index, SpyWriter out) {
        SpyWorkInfo info = null;
        Map<String, SpyWorkInfo> map = this.spyWorkMap;
        synchronized (map) {
            if (spyWorkStackTracesEnabled && index <= this.spyWorkMap.size()) {
                info = (SpyWorkInfo)this.spyWorkMap.values().toArray()[index - 1];
            }
        }
        if (info != null) {
            out.startProps().prop((Object)"Spy Work Name: ", (Object)info.name).endProps().w((Object)"<p>This is the stack trace when the Work was submitted. It's not an error...").w((Object)"<hr><pre>").safe((Object)info.stackTrace).w((Object)"</pre>");
        }
    }

    static class Work
    implements Runnable,
    ICoalesceable {
        Runnable runnable;
        volatile boolean alive = false;
        volatile long lastExecuteTicks = -1L;
        long ticksBetweenExecutes = -1L;

        Work(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.alive = true;
                this.runnable.run();
            }
            finally {
                this.alive = false;
                long now = Clock.ticks();
                this.ticksBetweenExecutes = now - this.lastExecuteTicks;
                this.lastExecuteTicks = now;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Work) {
                return this.runnable == ((Work)obj).runnable;
            }
            return false;
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public String toString() {
            return this.runnable.toString();
        }

        public Object getCoalesceKey() {
            return this.runnable;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }
    }

    class RegisteredObjectInfo {
        long cycleTime;
        long lastExecuteTicks = -1L;

        RegisteredObjectInfo(long cycleTime) {
            this.cycleTime = cycleTime;
        }

        RegisteredObjectInfo(long cycleTime, long lastExecuteTicks) {
            this.cycleTime = cycleTime;
            this.lastExecuteTicks = lastExecuteTicks;
        }
    }

    private class SpyWorkWrapperCoaleasable
    extends SpyWorkWrapper
    implements ICoalesceable {
        private SpyWorkWrapperCoaleasable(Runnable r, SpyWorkInfo info) {
            super(r, info);
        }

        public Object getCoalesceKey() {
            return this.asCoalesceable().getCoalesceKey();
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return this.asCoalesceable().coalesce(c);
        }

        private ICoalesceable asCoalesceable() {
            return (ICoalesceable)this.r;
        }
    }

    private class SpyWorkWrapper
    implements Runnable {
        protected Runnable r;
        private SpyWorkInfo info;

        private SpyWorkWrapper(Runnable r, SpyWorkInfo info) {
            this.r = r;
            this.info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long t0 = Clock.ticks();
            try {
                this.r.run();
            }
            finally {
                long t = Clock.ticks() - t0;
                if (t > this.info.max) {
                    this.info.max = t;
                }
                if (t < this.info.min) {
                    this.info.min = t;
                }
                if (t > BCyclicThreadPoolWorker.this.maxWorkTime) {
                    BCyclicThreadPoolWorker.this.maxWorkTime = t;
                    BCyclicThreadPoolWorker.this.maxWorkName = this.r.toString();
                }
                if (t < BCyclicThreadPoolWorker.this.minWorkTime) {
                    BCyclicThreadPoolWorker.this.minWorkTime = t;
                }
            }
        }

        public String toString() {
            return this.r.toString();
        }

        public int hashCode() {
            return this.r.hashCode();
        }

        public boolean equals(Object arg) {
            if (arg == null) {
                return false;
            }
            if (this.r == null) {
                return false;
            }
            return this.r.equals(arg);
        }
    }

    private static class SpyWorkInfo {
        private String name;
        private long count = 0L;
        private BAbsTime last = BAbsTime.now();
        private long totalMillisBtwnSubmits = 0L;
        private volatile long max = 0L;
        private volatile long min = Long.MAX_VALUE;
        private String stackTrace = "";

        private SpyWorkInfo() {
        }
    }

    private static class SpyWorkMap
    extends LinkedHashMap<String, SpyWorkInfo> {
        private SpyWorkMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SpyWorkInfo> eldest) {
            return (long)this.size() > spyWorkLimit;
        }
    }
}

