/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoChannel;
import com.tridium.videoDriver.videoStream.fox.ClientVideoInputStream;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.sys.BajaRuntimeException;

public class RemoteFoxVideoStream
extends FoxVideoStream {
    protected MaintainRemoteConnection connectionMaintainer;
    protected Thread connectionMaintainerThread;
    protected boolean closed;
    protected BNiagaraStation niagaraStation;
    protected BFoxClientConnection connectionBetweenStations;
    public static long ENGAGE_RETRY_INTERVAL = 5000L;
    public static final RemoteVideoInterest REMOTE_VIDEO_INTEREST = new RemoteVideoInterest();
    public static final Log log = Log.getLog((String)"fox.remote.videoStream");

    protected RemoteFoxVideoStream(BNiagaraStation niagaraStation, BPlaybackParams playbackParams, int videoStreamId, IVideoDestination videoDestination) throws Exception {
        this.foxVideoSource = null;
        this.niagaraStation = niagaraStation;
        this.closed = false;
        BFoxVideoChannel channelBetweenStations = this.getChannelBetweenStations();
        this.videoInputStream = channelBetweenStations.openVideoStream(null, niagaraStation.getName(), playbackParams, videoStreamId, videoDestination, (FoxVideoStream)this);
        this.videoPlaybackParams = playbackParams;
        this.startConnectionMaintainerThread();
    }

    protected void startConnectionMaintainerThread() {
        String maintainerThreadName = "remoteVideoStream.keepOpen";
        if (this.videoInputStream instanceof ClientVideoInputStream) {
            ClientVideoInputStream cvIn = (ClientVideoInputStream)this.videoInputStream;
            maintainerThreadName = maintainerThreadName + "." + cvIn.getVideoStreamId();
        }
        this.connectionMaintainer = new MaintainRemoteConnection();
        this.connectionMaintainerThread = new Thread((Runnable)this.connectionMaintainer, maintainerThreadName);
        this.connectionMaintainerThread.start();
    }

    protected BFoxVideoChannel getChannelBetweenStations() {
        this.connectionBetweenStations = this.niagaraStation.getClientConnection();
        try {
            this.connectionBetweenStations.engageNoRetry((BFoxClientConnection.Interest)REMOTE_VIDEO_INTEREST);
            if (this.connectionBetweenStations.isConnected()) {
                this.connectionBetweenStations.getFoxSession();
                BFoxVideoChannel bFoxVideoChannel = (BFoxVideoChannel)this.connectionBetweenStations.getChannels().get("FoxVideoChannel", BFoxVideoChannel.TYPE);
                return bFoxVideoChannel;
            }
            try {
                throw new BajaRuntimeException("Unable to connect Fox channel between the Web Supervisor and the Niagara Station.");
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        finally {
            this.connectionBetweenStations.disengage((BFoxClientConnection.Interest)REMOTE_VIDEO_INTEREST);
        }
    }

    public void closeVideoStream() throws IOException {
        this.closed = true;
        super.closeVideoStream();
    }

    static class RemoteVideoInterest
    implements BFoxClientConnection.Interest {
        RemoteVideoInterest() {
        }

        public String toString() {
            return "WsVideoInterest";
        }
    }

    public class MaintainRemoteConnection
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                while (true) {
                    if (!RemoteFoxVideoStream.this.closed) {
                        try {
                            if (log.isTraceOn()) {
                                log.trace("Engaging: " + Thread.currentThread().getName());
                            }
                            RemoteFoxVideoStream.this.connectionBetweenStations.engageNoRetry((BFoxClientConnection.Interest)REMOTE_VIDEO_INTEREST);
                            continue;
                        }
                        catch (Exception e) {
                            log.error("Exception while maintaining fox connection to remote station (" + Thread.currentThread().getName() + ".", (Throwable)e);
                            continue;
                        }
                        finally {
                            try {
                                Thread.sleep(ENGAGE_RETRY_INTERVAL);
                            }
                            catch (InterruptedException e) {
                                log.error("Interrupted while maintaining fox connection to remote station (" + Thread.currentThread().getName() + ".", (Throwable)e);
                            }
                            continue;
                        }
                    }
                    break block18;
                    break;
                }
                finally {
                    if (log.isTraceOn()) {
                        log.trace("Disengaging: " + Thread.currentThread().getName());
                    }
                    RemoteFoxVideoStream.this.connectionBetweenStations.disengage((BFoxClientConnection.Interest)REMOTE_VIDEO_INTEREST);
                }
            }
        }
    }
}

