/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.remoteVideo.BRemoteFoxVideoSource;
import com.tridium.remoteVideo.BRemoteVideoChannel;
import com.tridium.remoteVideo.BRemoteVideoEventRecall;
import com.tridium.remoteVideo.BRemoteVideoService;
import com.tridium.remoteVideo.BRemoteVideoSourceToken;
import com.tridium.remoteVideo.RemoteFoxVideoStream;
import com.tridium.util.PxUtil;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.camera.BIRemoteVideoSource;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.camera.control.BIVideoZoomControl;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import java.lang.reflect.Method;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="cameraHandleOrd", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="cameraOrd", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="niagaraStation", type="String", defaultValue=""), @NiagaraProperty(name="eventRecaller", type="BVideoEventRecall", defaultValue="new BRemoteVideoEventRecall()"), @NiagaraProperty(name="foxVideoSourceMasterStation", type="BRemoteFoxVideoSource", defaultValue="new BRemoteFoxVideoSource()")})
@NiagaraActions(value={@NiagaraAction(name="move", parameterType="BVideoPanTiltEnum", defaultValue="BVideoPanTiltEnum.none"), @NiagaraAction(name="zoom", parameterType="BVideoZoomEnum", defaultValue="BVideoZoomEnum.none"), @NiagaraAction(name="focusControl", parameterType="BVideoFocusEnum", defaultValue="BVideoFocusEnum.none"), @NiagaraAction(name="irisControl", parameterType="BVideoIrisEnum", defaultValue="BVideoIrisEnum.none"), @NiagaraAction(name="moveToPreset", parameterType="BValue", defaultValue="BString.DEFAULT"), @NiagaraAction(name="storePreset", parameterType="BValue", defaultValue="BString.DEFAULT"), @NiagaraAction(name="startRecordingAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()")})
public final class BRemoteVideoSource
extends BComponent
implements BIVideoSource,
BIVideoPanTiltControl,
BIVideoZoomControl,
BIVideoFocusControl,
BIVideoIrisControl,
BIVideoMoveToPresetControl,
BIVideoStorePresetControl,
BIVideoCamera,
BIVideoEventProvider,
BIVideoAlarmRecorder,
BIRemoteVideoSource {
    @Generated
    public static final Property cameraHandleOrd = BRemoteVideoSource.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property cameraOrd = BRemoteVideoSource.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property niagaraStation = BRemoteVideoSource.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property eventRecaller = BRemoteVideoSource.newProperty((int)0, (BValue)new BRemoteVideoEventRecall(), null);
    @Generated
    public static final Property foxVideoSourceMasterStation = BRemoteVideoSource.newProperty((int)0, (BValue)new BRemoteFoxVideoSource(), null);
    @Generated
    public static final Action move = BRemoteVideoSource.newAction((int)0, (BValue)BVideoPanTiltEnum.none, null);
    @Generated
    public static final Action zoom = BRemoteVideoSource.newAction((int)0, (BValue)BVideoZoomEnum.none, null);
    @Generated
    public static final Action focusControl = BRemoteVideoSource.newAction((int)0, (BValue)BVideoFocusEnum.none, null);
    @Generated
    public static final Action irisControl = BRemoteVideoSource.newAction((int)0, (BValue)BVideoIrisEnum.none, null);
    @Generated
    public static final Action moveToPreset = BRemoteVideoSource.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action storePreset = BRemoteVideoSource.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action startRecordingAlarm = BRemoteVideoSource.newAction((int)0, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRemoteVideoSource.class);
    public static final boolean ASYNC = true;
    public static final boolean SYNC = false;

    @Generated
    public BOrd getCameraHandleOrd() {
        return (BOrd)this.get(cameraHandleOrd);
    }

    @Generated
    public void setCameraHandleOrd(BOrd v) {
        this.set(cameraHandleOrd, (BValue)v, null);
    }

    @Generated
    public BOrd getCameraOrd() {
        return (BOrd)this.get(cameraOrd);
    }

    @Generated
    public void setCameraOrd(BOrd v) {
        this.set(cameraOrd, (BValue)v, null);
    }

    @Generated
    public String getNiagaraStation() {
        return this.getString(niagaraStation);
    }

    @Generated
    public void setNiagaraStation(String v) {
        this.setString(niagaraStation, v, null);
    }

    @Generated
    public BVideoEventRecall getEventRecaller() {
        return (BVideoEventRecall)this.get(eventRecaller);
    }

    @Generated
    public void setEventRecaller(BVideoEventRecall v) {
        this.set(eventRecaller, (BValue)v, null);
    }

    @Generated
    public BRemoteFoxVideoSource getFoxVideoSourceMasterStation() {
        return (BRemoteFoxVideoSource)this.get(foxVideoSourceMasterStation);
    }

    @Generated
    public void setFoxVideoSourceMasterStation(BRemoteFoxVideoSource v) {
        this.set(foxVideoSourceMasterStation, (BValue)v, null);
    }

    @Generated
    public void move(BVideoPanTiltEnum parameter) {
        this.invoke(move, (BValue)parameter, null);
    }

    @Generated
    public void zoom(BVideoZoomEnum parameter) {
        this.invoke(zoom, (BValue)parameter, null);
    }

    @Generated
    public void focusControl(BVideoFocusEnum parameter) {
        this.invoke(focusControl, (BValue)parameter, null);
    }

    @Generated
    public void irisControl(BVideoIrisEnum parameter) {
        this.invoke(irisControl, (BValue)parameter, null);
    }

    @Generated
    public void moveToPreset(BValue parameter) {
        this.invoke(moveToPreset, parameter, null);
    }

    @Generated
    public void storePreset(BValue parameter) {
        this.invoke(storePreset, parameter, null);
    }

    @Generated
    public void startRecordingAlarm(BAlarmRecord parameter) {
        this.invoke(startRecordingAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final boolean isLicensed() {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "remoteVideo");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isCameraFault() {
        BIVideoSource videoSource = this.getVideoSource();
        try {
            Class<?> videoSourceClass = videoSource.getClass();
            Method isFaultMethod = videoSourceClass.getMethod("isFault", new Class[0]);
            Object isFault = isFaultMethod.invoke((Object)videoSource, new Object[0]);
            if (isFault instanceof Boolean) {
                return (Boolean)isFault;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getCameraFaultCause() {
        boolean cameraFault = this.isCameraFault();
        return this.getCameraFaultCause((BObject)this.getVideoSource(), cameraFault);
    }

    protected String getCameraFaultCause(BObject object, boolean cameraFault) {
        if (object == null) {
            return "";
        }
        try {
            Class<?> videoSourceClass = object.getClass();
            Method getFaultCauseMethod = videoSourceClass.getMethod("getFaultCause", new Class[0]);
            Object faultCause = getFaultCauseMethod.invoke((Object)object, new Object[0]);
            if (faultCause instanceof String) {
                String faultCauseString = (String)faultCause;
                if (cameraFault && faultCauseString.length() == 0 && object instanceof BComplex) {
                    return this.getCameraFaultCause((BObject)((BComplex)object).getParent(), cameraFault);
                }
                return faultCauseString;
            }
            if (cameraFault && object instanceof BComplex) {
                return this.getCameraFaultCause((BObject)((BComplex)object).getParent(), cameraFault);
            }
            return "";
        }
        catch (Exception e) {
            if (cameraFault && object instanceof BComplex) {
                return this.getCameraFaultCause((BObject)((BComplex)object).getParent(), cameraFault);
            }
            return "";
        }
    }

    public BIVideoSource getVideoSource() {
        BIVideoSource videoSource = this.findVideoSource(this);
        if (videoSource instanceof BDevice) {
            ((BDevice)videoSource).fw(11);
        }
        return videoSource;
    }

    protected BIVideoSource findVideoSource(BComponent root) {
        root.lease();
        SlotCursor sc1 = root.getSlots();
        while (sc1.nextObject()) {
            if (!(sc1.get() instanceof BRemoteVideoSourceToken)) continue;
            return (BIVideoSource)root;
        }
        SlotCursor sc2 = root.getSlots();
        while (sc2.nextComponent()) {
            BIVideoSource videoSource;
            if (!(sc2.get() instanceof BComponent) || (videoSource = this.findVideoSource((BComponent)sc2.get())) == null) continue;
            return videoSource;
        }
        return null;
    }

    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getVideoSource().getFoxVideoStreamSetting();
    }

    public BRelTime getInterframeTimeout() {
        return this.getVideoSource().getInterframeTimeout();
    }

    public BColor getPreferredBackgroundColor() {
        return (BColor)this.getVideoSource().getPreferredBackgroundColor();
    }

    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getVideoSource().getPreferredAspectRatio();
    }

    public BVideoCompressionEnum getPreferredCompression() {
        return this.getVideoSource().getPreferredCompression();
    }

    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getVideoSource().getPreferredFrameRate();
    }

    public BVideoResolutionEnum getPreferredResolution() {
        return this.getVideoSource().getPreferredResolution();
    }

    public void initPlaybackParams(BPlaybackParams playbackParams, IVideoSession videoSession) {
        this.getVideoSource().initPlaybackParams(playbackParams, videoSession);
    }

    public boolean isFoxVideoStreamPreferred() {
        return this.getVideoSource().isFoxVideoStreamPreferred();
    }

    public boolean isTimestampPreferred() {
        return this.getVideoSource().isTimestampPreferred();
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams playbackParams) {
        return this.getVideoSource().makeVideoDecoder(playbackParams);
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        this.getVideoSource().streamToDestination(playbackParams, videoDestination);
    }

    public boolean supportsPlaybackControl() {
        return this.getVideoSource().supportsPlaybackControl();
    }

    public BOrd getSlotPathOrd() {
        return super.getSlotPathOrd();
    }

    public BValue invokeRemoteMethod(String methodName, BValue arg, boolean async) throws Exception {
        BNiagaraNetwork niagaraNet = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation niagaraStation = (BNiagaraStation)niagaraNet.getStation(this.getNiagaraStation());
        BFoxClientConnection foxConnectionToNiagaraStation = niagaraStation.getClientConnection();
        foxConnectionToNiagaraStation.engageNoRetry((BFoxClientConnection.Interest)RemoteFoxVideoStream.REMOTE_VIDEO_INTEREST);
        if (foxConnectionToNiagaraStation.isConnected()) {
            BRemoteVideoChannel channel = (BRemoteVideoChannel)foxConnectionToNiagaraStation.getChannels().get("remoteVideo");
            return channel.remoteMethod(this.getCameraOrd().toString(), methodName, arg, async);
        }
        return null;
    }

    public boolean isStorePresetEnabled() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        return videoSourceLocalCopy instanceof BIVideoStorePresetControl && ((BIVideoStorePresetControl)videoSourceLocalCopy).isStorePresetEnabled();
    }

    public Action getStorePresetAction() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        if (videoSourceLocalCopy instanceof BIVideoMoveToPresetControl) {
            return ((BIVideoStorePresetControl)videoSourceLocalCopy).getStorePresetAction();
        }
        return null;
    }

    public void doStorePreset(BValue value) throws Exception {
        this.invokeRemoteMethod("storePreset", value, true);
    }

    public boolean isMoveToPresetEnabled() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        return videoSourceLocalCopy instanceof BIVideoMoveToPresetControl && ((BIVideoMoveToPresetControl)videoSourceLocalCopy).isMoveToPresetEnabled();
    }

    public Action getMoveToPresetAction() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        if (videoSourceLocalCopy instanceof BIVideoMoveToPresetControl) {
            return ((BIVideoMoveToPresetControl)videoSourceLocalCopy).getMoveToPresetAction();
        }
        return null;
    }

    public void doMoveToPreset(BValue value) throws Exception {
        this.invokeRemoteMethod("moveToPreset", value, true);
    }

    public boolean isIrisEnabled() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        return videoSourceLocalCopy instanceof BIVideoIrisControl && ((BIVideoIrisControl)videoSourceLocalCopy).isIrisEnabled();
    }

    public void doIrisControl(BVideoIrisEnum irisEnum) throws Exception {
        this.invokeRemoteMethod("irisControl", (BValue)irisEnum, true);
    }

    public boolean isFocusEnabled() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        return videoSourceLocalCopy instanceof BIVideoFocusControl && ((BIVideoFocusControl)videoSourceLocalCopy).isFocusEnabled();
    }

    public void doFocusControl(BVideoFocusEnum focusEnum) throws Exception {
        this.invokeRemoteMethod("focusControl", (BValue)focusEnum, true);
    }

    public boolean isZoomEnabled() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        return videoSourceLocalCopy instanceof BIVideoZoomControl && ((BIVideoZoomControl)videoSourceLocalCopy).isZoomEnabled();
    }

    public void doZoom(BVideoZoomEnum zoomEnum) throws Exception {
        this.invokeRemoteMethod("zoom", (BValue)zoomEnum, true);
    }

    public boolean isPanTiltEnabled() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        return videoSourceLocalCopy instanceof BIVideoPanTiltControl && ((BIVideoPanTiltControl)videoSourceLocalCopy).isPanTiltEnabled();
    }

    public void doMove(BVideoPanTiltEnum panTiltEnum) throws Exception {
        this.invokeRemoteMethod("move", (BValue)panTiltEnum, true);
    }

    public String getCameraDescription() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        if (videoSourceLocalCopy instanceof BIVideoCamera) {
            return ((BIVideoCamera)videoSourceLocalCopy).getCameraDescription();
        }
        return "RemoteVideoSource";
    }

    public BIVideoDvr getDvr() {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        if (videoSourceLocalCopy instanceof BIVideoCamera) {
            return ((BIVideoCamera)videoSourceLocalCopy).getDvr();
        }
        return null;
    }

    public BAbsTime getCameraTime() {
        try {
            BValue cameraTimeRemoteValue = this.invokeRemoteMethod("getCameraTime", null, false);
            if (cameraTimeRemoteValue == null) {
                return null;
            }
            if (cameraTimeRemoteValue instanceof BAbsTime) {
                return (BAbsTime)cameraTimeRemoteValue;
            }
            throw new BajaRuntimeException("Expected 'getCameraTime()' to return BAbsTime not " + cameraTimeRemoteValue.getType().getTypeSpec() + ". Remote camera: " + this.getCameraOrd() + " at remote station " + this.getNiagaraStation());
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Error invoking 'getCameraTime()' on remote camera: " + this.getCameraOrd() + " at remote station " + this.getNiagaraStation(), (Throwable)e);
        }
    }

    public BPointDeviceExt getEvents() {
        return null;
    }

    public void doStartRecordingAlarm(BAlarmRecord alarmRecord) throws Exception {
        BIVideoSource videoSourceLocalCopy = this.getVideoSource();
        if (videoSourceLocalCopy instanceof BIVideoAlarmRecorder) {
            this.invokeRemoteMethod("startRecordingAlarm", (BValue)alarmRecord, true);
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        if (this.addLiveVideoView()) {
            String cameraViewTypeSpec = this.getCameraViewTypeSpec();
            AgentInfo cameraView = Sys.getRegistry().getType(cameraViewTypeSpec).getAgentInfo();
            agents.add(cameraView);
            if (this.areCameraViewsTopMost()) {
                agents.toTop(cameraView);
            }
        }
        if (this.addPlaybackView()) {
            String playbackViewTypeSpec = this.getPlaybackViewTypeSpec();
            AgentInfo playbackView = Sys.getRegistry().getType(playbackViewTypeSpec).getAgentInfo();
            agents.add(playbackView);
            if (this.areCameraViewsTopMost()) {
                agents.toTop(playbackView);
            }
        }
        try {
            AgentInfo accessControlView = Sys.getRegistry().getType("accessControl:HxWbAccessView").getAgentInfo();
            agents.add(accessControlView);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PxUtil.movePxViewsToTop((AgentList)agents);
    }

    protected boolean addLiveVideoView() {
        return true;
    }

    protected boolean addPlaybackView() {
        return true;
    }

    protected String getCameraViewTypeSpec() {
        return "videoDriver:LiveVideo";
    }

    protected String getPlaybackViewTypeSpec() {
        return "videoDriver:VideoPlayback";
    }

    protected boolean areCameraViewsTopMost() {
        return true;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BRemoteVideoService;
    }
}

