/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.security;

import com.tridium.authn.BCallbackHandler;
import com.tridium.nc.cmds.ICloudCommand;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.security.CloudCallback;
import java.io.IOException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

@NiagaraType(agent={@AgentOn(types={"nCloudDriver:CloudAuthenticationScheme"})})
public class BCloudCallbackHandler
extends BCallbackHandler {
    public static final Type TYPE = Sys.loadType(BCloudCallbackHandler.class);
    private CloudDecodeMsg message;
    private String deviceId;
    private String messageId;

    public Type getType() {
        return TYPE;
    }

    public void init(CloudDecodeMsg message, String deviceId, String messageId) {
        this.message = message;
        this.deviceId = deviceId;
        this.messageId = messageId;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof CloudCallback) {
                if (this.message != null) {
                    String appId = ((ICloudCommand)((Object)this.message)).getCaller();
                    Object auth = ((ICloudCommand)((Object)this.message)).getAuth();
                    if (auth != null && !(auth instanceof String)) {
                        throw new IOException("Wrong type for auth. Expected String but found " + auth.getClass());
                    }
                    ((CloudCallback)callback).setAppId(appId);
                    ((CloudCallback)callback).setJwt((String)auth);
                }
            } else {
                throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
            }
            ((CloudCallback)callback).setDeviceId(this.deviceId);
            ((CloudCallback)callback).setMessageId(this.messageId);
        }
    }
}

