/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.point;

import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudWriteInfo;
import com.tridium.nc.point.BCloudProxyExt;
import com.tridium.nc.point.BCloudWriteController;
import com.tridium.nc.point.ICloudWriter;
import com.tridium.util.CompUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public class LinkingCloudWriter
implements ICloudWriter {
    @Override
    public boolean write(BCloudWriteInfo writeInfo, BControlPoint cloudProxyPoint, String writeInfoName, String targetSlotName, BRelTime duration) {
        BCloudWriteInfo info;
        BValue v = cloudProxyPoint.get(writeInfoName);
        BControlPoint stationPoint = CloudUtilities.cloudProxy(cloudProxyPoint).getPoint();
        int ptPri = this.getPointActivePriority(stationPoint);
        if (v instanceof BCloudWriteInfo) {
            int pri = BCloudWriteController.getPriority(writeInfoName);
            if (((BCloudWriteInfo)v).getValue().getValueValue().equals((Object)writeInfo.getValue().getValueValue()) && ptPri == pri) {
                log.fine(() -> String.format("Attempting forceWrite for pointId %s for %s", stationPoint.getSlotPath(), v));
                LinkingCloudWriter.forceWrite(stationPoint);
            } else {
                ((BCloudWriteInfo)v).copyFrom((BComplex)writeInfo);
                stationPoint.doExecute();
            }
            info = (BCloudWriteInfo)v;
        } else {
            BStatusValue sv;
            info = writeInfo;
            Property targetProp = stationPoint.getProperty(targetSlotName);
            if (targetProp == null) {
                log.fine(() -> String.format("Cannot add write link to station point %s, failing write to pointId %s", stationPoint.getSlotPath(), BCloudProxyExt.pointId));
                return false;
            }
            CompUtil.setOrAdd((BComponent)cloudProxyPoint, (String)writeInfoName, (BValue)writeInfo, (int)3, null, null);
            Type writeType = writeInfo.getValue().getType();
            Type targetType = stationPoint.getProperty(targetSlotName).getType();
            Registry registry = Sys.getRegistry();
            TypeInfo[] adapters = registry.getAdapters(writeType.getTypeInfo(), targetType.getTypeInfo());
            BConverter converter = null;
            for (int i = adapters.length - 1; i >= 0; --i) {
                if (!registry.isAgent(adapters[i], BConversionLink.TYPE.getTypeInfo())) continue;
                converter = (BConverter)adapters[i].getInstance();
                break;
            }
            Object link = converter != null ? new BConversionLink(writeInfo.getHandleOrd(), "value", targetSlotName, true, converter) : new BLink(writeInfo.getHandleOrd(), "value", targetSlotName, true);
            try {
                stationPoint.add(BCloudWriteController.getWriteLinkName(targetSlotName), (BValue)link, 2);
                log.finer(() -> String.format("Write link creation succeeded for cloud proxy point %s to station point %s", new Object[]{CloudUtilities.cloudProxy(cloudProxyPoint), stationPoint.getSlotPath()}));
            }
            catch (Exception e) {
                log.fine(() -> String.format("Exception [%s] adding link to station point %s, failing write to pointId %s", e, stationPoint.getSlotPath(), BCloudProxyExt.pointId));
                cloudProxyPoint.remove(writeInfoName);
                return false;
            }
            int pri = BCloudWriteController.getPriority(writeInfoName);
            if (stationPoint.get("in" + pri) != null && (sv = (BStatusValue)stationPoint.get("in" + pri)).getValueValue().equals((Object)writeInfo.getValue().getValueValue())) {
                log.fine(() -> String.format("Attempting forceWrite for pointId %s for %s", stationPoint.getSlotPath(), v));
                LinkingCloudWriter.forceWrite(stationPoint);
            }
        }
        if (duration.getMillis() > 0L) {
            info.setExpiration(BAbsTime.now().add(duration));
            info.makeTicket();
        } else {
            info.clearTicket();
        }
        return true;
    }

    private static void forceWrite(BControlPoint stationPoint) {
        BAbstractProxyExt proxyExt = stationPoint.getProxyExt();
        Action action = proxyExt.getAction("forceWrite");
        if (action != null) {
            proxyExt.invoke(action, null);
        } else {
            log.warning(() -> String.format("Write for point: %s failed as Force Write action not supported for the underlying driver.", stationPoint.getSlotPath()));
        }
    }

    @Override
    public boolean clear(BControlPoint cloudProxyPoint, int priority, BCloudWriteInfo writeInfo) {
        if (writeInfo != null) {
            log.finer(() -> String.format("Clearing cloud write info at level %s, from %s", priority, cloudProxyPoint));
            writeInfo.getValue().setStatusNull(true);
            cloudProxyPoint.remove(writeInfo.getName());
            return true;
        }
        log.warning(() -> String.format("No cloud write info at level %s, from %s to relinquish the value", priority, cloudProxyPoint));
        return false;
    }
}

