/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.point;

import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudWriteInfo;
import com.tridium.nc.point.BCloudProxyExt;
import com.tridium.nc.point.BCloudTuningPolicy;
import com.tridium.nc.point.ClearPointException;
import com.tridium.nc.point.ICloudWriter;
import com.tridium.nc.point.LinkingCloudWriter;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="enabled", type="boolean", defaultValue="true")
@NiagaraAction(name="clearCloudWrite", parameterType="BCloudWriteInfo", defaultValue="new BCloudWriteInfo()", flags=4)
public class BCloudWriteController
extends BComponent {
    public static final Property enabled = BCloudWriteController.newProperty((int)0, (boolean)true, null);
    public static final Action clearCloudWrite = BCloudWriteController.newAction((int)4, (BValue)new BCloudWriteInfo(), null);
    public static final Type TYPE = Sys.loadType(BCloudWriteController.class);
    public static final String WRITE_CONTROLLER_NAME = "cloudWriteController";
    public static final String WRITE_INFO_NAME_IN_X = "In";
    public static final int WRITE_INFO_NAME_IN_X_LEN = "In".length();
    public static final String WRITE_INFO_NAME_FALLBACK = "Fallback";
    public static final String TARGET_SLOT_NAME_IN_X = "in";
    public static final String TARGET_SLOT_NAME_FALLBACK = "fallback";
    public static final int NEW_CLOUD_WRITE_VALUE_STATUS_MASK = 66;
    public static final int EXISTING_CLOUD_WRITE_VALUE_STATUS_MASK = 64;
    private ICloudWriter writer;
    private static final Logger log = Logger.getLogger("ncloud.point");
    protected Lexicon lex = Lexicon.make((String)"nCloudDriver");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public void clearCloudWrite(BCloudWriteInfo parameter) {
        this.invoke(clearCloudWrite, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.writer = this.makeCloudWriter();
        this.writer.configureTargetPoint(CloudUtilities.cloudProxy(this.getParentPoint()).getPoint());
    }

    public void changed(Property p, Context c) {
        super.changed(p, c);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled)) {
            for (BCloudWriteInfo writeInfo : (BCloudWriteInfo[])this.getParentPoint().getChildren(BCloudWriteInfo.class)) {
                this.mergeStatusToWriteInfo(CloudUtilities.cloudProxy(this.getParentPoint()), writeInfo);
                this.writer.controllerEnabled(this.getParentPoint(), writeInfo, this.getEnabled());
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BControlPoint;
    }

    public void doClearCloudWrite(BCloudWriteInfo info) {
        int ptPri;
        BControlPoint parentPoint = this.getParentPoint();
        if (parentPoint == null || !parentPoint.equals((Object)info.getParentPoint())) {
            log.fine("Cannot clear cloud write: cloudWriteInfo is not a sibling of the write controller");
            return;
        }
        BControlPoint targetPoint = CloudUtilities.cloudProxy(parentPoint).getPoint();
        int pri = BCloudWriteController.getPriority(info.getName());
        if (pri < (ptPri = this.writer.getPointActivePriority(targetPoint))) {
            log.finer(() -> String.format("CloudWriteController: Clearing cloud write [%s] on %s: write has already been relinquished (ok)", new Object[]{info, targetPoint.getSlotPath()}));
        } else if (pri > ptPri) {
            log.finer(() -> String.format("CloudWriteController: Clearing cloud write [%s] on %s: write is already not in control", new Object[]{info, targetPoint.getSlotPath()}));
        } else {
            if (!info.getValue().getValueValue().equals((Object)targetPoint.getOutStatusValue().getValueValue())) {
                log.finest(() -> String.format("info.v.t:%s, info.v.v:%s, info.v.v.t:%s;  tgtPt.out.t:%s, tgtPt.out.v:%s, tgtPt.out.v.t:%s", info.getValue().getType(), info.getValue().getValueValue(), info.getValue().getValueValue().getType(), targetPoint.getOutStatusValue().getType(), targetPoint.getOutStatusValue().getValueValue(), targetPoint.getOutStatusValue().getValueValue().getType()));
                log.finer(() -> String.format("CloudWriteController: Clear cloud write[%s] on %s: value has been overwritten(%s), leave local write in place", new Object[]{info, targetPoint.getSlotPath(), targetPoint.getOutStatusValue().getValueValue()}));
                info.setValue((BStatusValue)targetPoint.getOutStatusValue().newCopy().as(BStatusValue.class));
                info.clearTicket();
                info.setExpiration(BAbsTime.NULL);
                info.setSource(this.lex.getText("point.remoteOverwrite"));
                return;
            }
            log.finer(() -> String.format("CloudWriteController: Clearing cloud write [%s] on %s", new Object[]{info, targetPoint.getSlotPath()}));
        }
        this.writer.clear(parentPoint, pri, info);
    }

    public boolean writePoint(Object objValue, int priority, BRelTime duration, String source, String messageId, Context cx) {
        boolean result = true;
        BControlPoint pxPoint = this.getParentPoint();
        BCloudProxyExt cloudProxyExt = CloudUtilities.cloudProxy(pxPoint);
        if (source == null) {
            log.info(() -> String.format("Write for point %s received without source information, rejecting write", cloudProxyExt.getPointId()));
            return false;
        }
        BCloudTuningPolicy policy = cloudProxyExt.getCloudTuningPolicy();
        String targetSlotName = BCloudWriteController.getTargetSlotName(priority, policy.getDefaultPriority().getOrdinal());
        String writeInfoName = BCloudWriteController.getCloudWriteInfoName(priority, policy.getDefaultPriority().getOrdinal());
        if (duration == null || duration.getMillis() < 0L) {
            duration = policy.getDefaultDuration();
        }
        this.validateWrites(this.getParentPoint(), cloudProxyExt.getPoint());
        BCloudWriteInfo writeInfo = BCloudWriteController.makeCloudWriteInfo(pxPoint, objValue, source, messageId);
        if (writeInfo.getValue().getStatus().isFault()) {
            result = false;
        }
        this.mergeStatusToWriteInfo(cloudProxyExt, writeInfo);
        log.finest(() -> String.format("point:%s, write: %s", new Object[]{cloudProxyExt.getPointId(), writeInfo}));
        return result &= this.writer.write(writeInfo, pxPoint, writeInfoName, targetSlotName, duration);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearPoint(int priority) {
        void var6_8;
        BCloudProxyExt pxProxyExt;
        BCloudTuningPolicy policy;
        String writeInfoName;
        BControlPoint pxPoint = this.getParentPoint();
        BValue bValue = pxPoint.get(writeInfoName = BCloudWriteController.getCloudWriteInfoName(priority, (policy = (pxProxyExt = CloudUtilities.cloudProxy(pxPoint)).getCloudTuningPolicy()).getDefaultPriority().getOrdinal()));
        if (bValue == null) {
            if (!pxProxyExt.getCloudPointDeviceExt().getForceRelinquishEnabled()) {
                log.warning(() -> String.format("No cloudWriteIn at priority %s for %s and force relinquish is disabled", new Object[]{priority, pxProxyExt}));
                throw new ClearPointException("Force relinquish is disabled");
            }
            int ptPri = this.writer.getPointActivePriority(pxProxyExt.getPoint());
            if (ptPri != priority) {
                log.warning(() -> String.format("Force relinquish at priority %s for point %s is failed as the point priority is %s and it is not the same", new Object[]{priority, pxProxyExt, ptPri}));
                throw new ClearPointException("Force relinquish failed as the driver point out priority is not the same");
            }
            this.validateWrites(pxPoint, pxProxyExt.getPoint());
            BStatusValue ptOutSV = (BStatusValue)pxProxyExt.getPoint().getOutStatusValue().newCopy();
            BCloudWriteInfo info = new BCloudWriteInfo();
            info.setValue((BStatusValue)ptOutSV.newCopy().as(BStatusValue.class));
            info.clearTicket();
            info.setExpiration(BAbsTime.NULL);
            info.setSource(this.lex.getText("point.remoteOverwrite"));
            String targetSlotName = BCloudWriteController.getTargetSlotName(priority, policy.getDefaultPriority().getOrdinal());
            log.finer(() -> String.format("Adding cloud write info at level %s, from %s to force the relinquish", priority, pxPoint));
            if (!this.writer.write(info, pxPoint, writeInfoName, targetSlotName, BRelTime.make((long)0L))) {
                log.warning(() -> String.format("Adding missing cloud write info at level %s, from %s failed force relinquish", priority, pxPoint));
                throw new ClearPointException("Adding missing cloud write info failed");
            }
            long writeCompletionDelay = pxProxyExt.getCloudPointDeviceExt().getForceWriteDelay().getMillis();
            try {
                log.finer(() -> String.format("Waiting for %s ms to complete the write with value %s at %s, for point %s to force the relinquish", new Object[]{writeCompletionDelay, ptOutSV, priority, pxProxyExt}));
                Thread.sleep(writeCompletionDelay);
            }
            catch (InterruptedException e) {
                log.warning(() -> String.format("Waiting for writing value %s at %s, for point %s is interrupted before the force relinquish completed", new Object[]{ptOutSV, priority, pxProxyExt}));
            }
            BCloudWriteInfo bCloudWriteInfo = info;
        }
        if (var6_8 instanceof BCloudWriteInfo) {
            this.writer.clear(pxPoint, priority, (BCloudWriteInfo)var6_8);
        }
    }

    public void validateWrites(BControlPoint cloudProxyPoint, BControlPoint targetPoint) {
        BCloudWriteInfo[] writeInfos;
        BStatusValue ptOutSV = targetPoint.getOutStatusValue();
        int ptPri = this.writer.getPointActivePriority(targetPoint);
        for (BCloudWriteInfo info : writeInfos = (BCloudWriteInfo[])cloudProxyPoint.getChildren(BCloudWriteInfo.class)) {
            int pri = BCloudWriteController.getPriority(info.getName());
            if (pri < ptPri) {
                log.finer(() -> String.format("Proxy Point value at lower priority (%s) than cloud write priority (%s)! Need to clear cloud write", ptPri, pri));
                ICloudWriter.forceClear(cloudProxyPoint, info);
                targetPoint.doExecute();
                continue;
            }
            if (pri > ptPri) {
                log.finer(() -> String.format("Proxy Point value at higher priority (%s) than cloud write priority (%s) - leave cloud write in place", ptPri, pri));
                continue;
            }
            if (!info.getValue().getValueValue().equals((Object)ptOutSV.getValueValue())) {
                log.finer(() -> String.format("Proxy Point value at cloud write priority (%s) overwritten by local device", pri));
                continue;
            }
            log.finer(() -> String.format("Proxy Point value at cloud write priority (%s) equals cloud write - leave cloud write in place", pri));
        }
    }

    public void updatePointRemoteActivePriority(BStatusValue targetPointStatus) {
        this.writer.updatePointRemoteActivePriority(targetPointStatus);
    }

    public static BCloudWriteInfo makeCloudWriteInfo(BControlPoint pxPoint, Object objValue, String source, String messageId) {
        BCloudWriteInfo writeInfo;
        block17: {
            writeInfo = new BCloudWriteInfo();
            writeInfo.setSource(source);
            if (objValue instanceof Number) {
                writeInfo.setValue((BStatusValue)new BStatusNumeric(((Number)objValue).doubleValue()));
            } else if (objValue instanceof Boolean) {
                writeInfo.setValue((BStatusValue)new BStatusBoolean(((Boolean)objValue).booleanValue()));
            } else if (objValue instanceof String) {
                if (pxPoint instanceof BEnumPoint) {
                    Double numval = null;
                    try {
                        numval = Double.parseDouble((String)objValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (numval != null) {
                        writeInfo.setValue((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)numval.intValue())));
                    } else {
                        BEnumRange range = null;
                        try {
                            range = (BEnumRange)pxPoint.getFacets().get("range");
                            if (range != null) {
                                BEnumRange finalRange = range;
                                log.finest(() -> String.format("Setting enum point from point facets range:%s", finalRange));
                                writeInfo.setValue((BStatusValue)new BStatusEnum(range.get((String)objValue)));
                                break block17;
                            }
                            BEnumRange finalRange = range = ((BEnumPoint)pxPoint).getEnum().getRange();
                            log.finest(() -> String.format("Setting enum point from out slot range:%s", finalRange));
                            writeInfo.setValue((BStatusValue)new BStatusEnum(range.get((String)objValue)));
                        }
                        catch (InvalidEnumException iee) {
                            writeInfo.setValue((BStatusValue)new BStatusEnum((BEnum)(range != null ? range.get(range.getOrdinals()[0]) : BDynamicEnum.make((int)0)), BStatus.fault));
                            log.log(Level.CONFIG, String.format("Unable to convert string '%s' to enum (messageId %s)", objValue, messageId), log.isLoggable(Level.FINE) ? iee : null);
                        }
                    }
                } else {
                    writeInfo.setValue((BStatusValue)new BStatusString((String)objValue));
                }
            } else if (objValue instanceof BStatusValue) {
                writeInfo.setValue((BStatusValue)objValue);
            } else {
                writeInfo.setValue((BStatusValue)new BStatusString(objValue.toString()));
            }
        }
        log.fine(() -> String.format("makeCloudWriteInfo for write from %s [msgId %s] to pointId %s: %s", new Object[]{source, messageId, CloudUtilities.cloudProxy(pxPoint).getPointId(), writeInfo}));
        return writeInfo;
    }

    public static String getTargetSlotName(int priority, int defaultPriority) {
        if (priority < 1 || priority > 17) {
            priority = defaultPriority;
        }
        return priority == 17 ? TARGET_SLOT_NAME_FALLBACK : TARGET_SLOT_NAME_IN_X + priority;
    }

    public static String getCloudWriteInfoName(int priority) {
        return BCloudWriteController.getCloudWriteInfoName(priority, priority);
    }

    public static String getCloudWriteInfoName(int priority, int defaultPriority) {
        if (priority < 1 || priority > 17) {
            priority = defaultPriority;
        }
        return "cloudWrite" + (priority == 17 ? WRITE_INFO_NAME_FALLBACK : WRITE_INFO_NAME_IN_X + priority);
    }

    public static int getPriority(String cloudWriteInfoName) {
        if (cloudWriteInfoName == null) {
            return 17;
        }
        if (cloudWriteInfoName.startsWith("cloudWriteIn")) {
            try {
                int pri = Integer.parseInt(cloudWriteInfoName.substring(CloudUtilities.WRITE_INFO_PREFIX_LEN + WRITE_INFO_NAME_IN_X_LEN));
                if (pri < 1 || pri > 17) {
                    pri = 17;
                }
                return pri;
            }
            catch (Exception e) {
                log.fine(() -> String.format("Could not determine priority for cloudWriteInfoName %s; returning fallback priority", cloudWriteInfoName));
                return 17;
            }
        }
        return 17;
    }

    public static String getWriteLinkName(String slotName) {
        return "writeLink_" + slotName;
    }

    void propagateStatusToWriteInfos(BCloudProxyExt ext) {
        BCloudWriteInfo[] writeInfos = (BCloudWriteInfo[])this.getParentPoint().getChildren(BCloudWriteInfo.class);
        Arrays.stream(writeInfos).forEach(writeInfo -> this.mergeStatusToWriteInfo(ext, (BCloudWriteInfo)((Object)writeInfo)));
    }

    public void mergeStatusToWriteInfo(BCloudProxyExt proxyExt, BCloudWriteInfo writeInfo) {
        int sbits = proxyExt.getStatus().getBits() & 6 | (this.getEnabled() ? 0 : 1) | writeInfo.getValue().getStatus().getBits() & (writeInfo.isMounted() ? 64 : 66);
        writeInfo.getValue().setStatus(sbits);
    }

    void removeCloudWrites() {
        Arrays.stream(this.getParentPoint().getChildren(BCloudWriteInfo.class)).forEach(arg_0 -> ((BControlPoint)this.getParentPoint()).remove(arg_0));
    }

    public final BControlPoint getParentPoint() {
        return (BControlPoint)this.getParent();
    }

    private ICloudWriter makeCloudWriter() {
        ICloudWriter w;
        String className = "none";
        BControlPoint targetPoint = null;
        try {
            String moduleName;
            targetPoint = (BControlPoint)CloudUtilities.cloudProxy(this.getParentPoint()).getOrdPath().get((BObject)this);
            if ("niagaraDriver:NiagaraProxyExt".equals(targetPoint.getProxyExt().getType().getTypeSpec().toString())) {
                moduleName = "fcModelSyncNiagara";
                className = "com.tridium.fcModelSyncNiagara.FoxCloudWriter";
            } else if (Pattern.matches("bacnet:Bacnet.*ProxyExt", targetPoint.getProxyExt().getType().getTypeSpec().toString())) {
                moduleName = "fcModelSyncBacnet";
                className = "com.tridium.fcModelSyncBacnet.BacnetCloudWriter";
            } else if (targetPoint.isWritablePoint()) {
                moduleName = "nCloudDriver";
                className = "com.tridium.nc.point.LinkingCloudWriter";
            } else {
                moduleName = "nCloudDriver";
                className = "com.tridium.nc.point.NullCloudWriter";
            }
            w = (ICloudWriter)Sys.loadModule((String)moduleName).loadClass(className).newInstance();
        }
        catch (Exception e) {
            String finalClassName = className;
            log.config(() -> String.format("Could not create cloud writer type %s for point %s: %s; using default writer", finalClassName, CloudUtilities.cloudProxy(this.getParentPoint()).getPointId(), e));
            w = new LinkingCloudWriter();
        }
        LinkingCloudWriter finalW = w;
        BControlPoint finalTargetPoint = targetPoint;
        log.fine(() -> String.format("Created cloud writer type %s for point %s", finalW.getClass(), finalTargetPoint != null ? finalTargetPoint.getSlotPath() : "null"));
        return w;
    }

    static boolean isProxyPoint(BControlPoint point) {
        return point.getProxyExt() instanceof BProxyExt;
    }

    public void spy(SpyWriter out) throws Exception {
        this.spy(out, true);
    }

    public void spy(SpyWriter out, boolean includeSuper) throws Exception {
        out.startProps("Cloud Write Controller");
        out.prop((Object)"writer", (Object)this.writer);
        out.endProps();
        if (includeSuper) {
            super.spy(out);
        }
    }
}

