/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.history;

import com.tridium.driver.util.DrUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.history.BCloudHistoryDeviceExt;
import com.tridium.ndriver.BNNetwork;
import java.util.logging.Logger;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.history.BHistoryId;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="historyId", type="BHistoryId", defaultValue="BHistoryId.NULL", flags=1, override=true), @NiagaraProperty(name="pointId", type="String", defaultValue="", flags=1), @NiagaraProperty(name="sourceOrd", type="BOrd", defaultValue="BOrd.DEFAULT", flags=1), @NiagaraProperty(name="lastSentToCloud", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BManualTriggerMode.make())", flags=7, override=true)})
public class BCloudHistoryExport
extends BHistoryExport {
    public static final Property historyId = BCloudHistoryExport.newProperty((int)1, (BValue)BHistoryId.NULL, null);
    public static final Property pointId = BCloudHistoryExport.newProperty((int)1, (String)"", null);
    public static final Property sourceOrd = BCloudHistoryExport.newProperty((int)1, (BValue)BOrd.DEFAULT, null);
    public static final Property lastSentToCloud = BCloudHistoryExport.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property executionTime = BCloudHistoryExport.newProperty((int)7, (BValue)new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()), null);
    public static final Type TYPE = Sys.loadType(BCloudHistoryExport.class);
    private static final Logger log = Logger.getLogger("ncloud.history");
    private static final Logger logDbg = Logger.getLogger("ncloud.history.dbg");
    private BComponent source;

    public String getPointId() {
        return this.getString(pointId);
    }

    public void setPointId(String v) {
        this.setString(pointId, v, null);
    }

    public BOrd getSourceOrd() {
        return (BOrd)this.get(sourceOrd);
    }

    public void setSourceOrd(BOrd v) {
        this.set(sourceOrd, (BValue)v, null);
    }

    public BAbsTime getLastSentToCloud() {
        return (BAbsTime)this.get(lastSentToCloud);
    }

    public void setLastSentToCloud(BAbsTime v) {
        this.set(lastSentToCloud, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        Slot executeSlot = this.getSlot("execute");
        this.setFlags(executeSlot, executeSlot.getDefaultFlags() | 4);
        this.registerWithDeviceExt();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.historyDeviceExt().unregisterHistoryExport(this.source, this);
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(historyId)) {
            this.historyDeviceExt().unregisterHistoryExport(this.source, this);
            this.registerWithDeviceExt();
        }
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        return ((BNNetwork)this.getDevice().getNetwork()).postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
    }

    public void doExecute() {
        log.fine("BCloudHistoryExport execute invoked. This action has been disabled; please use the BCloudHistoryDeviceExt to export histories.");
    }

    public final BCloudDevice getCloudConnectorDevice() {
        return (BCloudDevice)DrUtil.getParent((BComplex)this, (Type)BCloudDevice.TYPE);
    }

    private BCloudHistoryDeviceExt historyDeviceExt() {
        return (BCloudHistoryDeviceExt)CloudUtilities.getParent((BComponent)this, BCloudHistoryDeviceExt.TYPE);
    }

    void registerWithDeviceExt() {
        logDbg.fine("CHE.registerWithDeviceExt(): sourceOrd=" + this.getSourceOrd());
        BObject srcObj = null;
        try {
            if (this.getSourceOrd().isNull()) {
                logDbg.finest("sourceOrd.isNull! attempt to get ord from historyId [" + this.getHistoryId() + "] by calling CHDE.getSourceOrdForHistoryId()");
                this.setSourceOrd(this.historyDeviceExt().getSourceOrdForHistoryId(this.getHistoryId()));
            }
            logDbg.finest("After trying to set ord; sourcOrd=" + this.getSourceOrd());
            if (!this.getSourceOrd().isNull() && (srcObj = this.getSourceOrd().get((BObject)this)) != null) {
                this.source = srcObj.asComponent();
                this.historyDeviceExt().registerHistoryExport(this.source, this);
            }
        }
        catch (Exception e) {
            log.warning(String.format("Could not register cloud history export %s (historyId %s) with device ext: source is %s", this.getName(), this.getHistoryId(), srcObj));
        }
    }
}

