/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.points;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudWriteHandler;
import com.tridium.nc.devices.sentience.points.CloudMultiPointData;
import com.tridium.nc.point.BCloudPointDeviceExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.naming.SlotPath;
import javax.baja.security.PermissionException;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public class SentienceWriteHandler
implements CloudWriteHandler {
    private static final Logger log = Logger.getLogger("ncloud.point");
    private static final Lexicon LEX = Lexicon.make((String)"nCloudDriver");
    private final BCloudDevice cloudConnectorDevice;

    public SentienceWriteHandler(BCloudDevice cloudConnectorDevice) {
        this.cloudConnectorDevice = cloudConnectorDevice;
    }

    @Override
    public void handleWriteAndReponse(CloudDecodeMsg request, String messageId, Context cx) {
        block5: {
            String sentiencePointId = (String)request.getData("PointId");
            BControlPoint pxPoint = CloudUtilities.getPoint(SlotPath.unescape((String)sentiencePointId));
            if (pxPoint != null && CloudUtilities.isPointWriteAllowed(this.cloudConnectorDevice.getNiagaraCloudNetwork(), pxPoint, cx)) {
                String callingIdentity = (String)request.getData("CallingIdentity");
                try {
                    Object writeValue = request.getData("Value");
                    log.fine(() -> String.format("SentienceWriteHandler write: value:%s", writeValue));
                    if (SentienceWriteHandler.writePoint(pxPoint, writeValue, 0, null, callingIdentity, messageId, cx)) {
                        this.handleResponse(request, messageId, "Success");
                        break block5;
                    }
                    this.handleResponse(request, messageId, "Error: Invalid point value");
                }
                catch (PermissionException e) {
                    this.handleResponse(request, messageId, "Error: Access Not Allowed");
                    log.warning(() -> String.format(LEX.getText("accessNotAllowed"), request.getData("PointId")) + ' ' + messageId);
                }
            } else {
                this.handleResponse(request, messageId, "Error: Access Not Allowed");
                log.warning(() -> String.format(LEX.getText("accessNotAllowed"), request.getData("PointId")) + ' ' + messageId);
            }
        }
    }

    private static boolean writePoint(BControlPoint pxPoint, Object objValue, int priority, BRelTime duration, String callingIdentity, String messageId, Context cx) {
        return BCloudPointDeviceExt.writePoint(pxPoint, objValue, priority, duration, callingIdentity, messageId, cx);
    }

    private void handleResponse(CloudDecodeMsg request, String messageId, String result) {
        BICloudConnector connector = this.cloudConnectorDevice.resolveConnector();
        if (CloudUtilities.canSendMessage(this.cloudConnectorDevice)) {
            CloudEncodeMsg ackResponse = this.cloudConnectorDevice.getFactory().createPointWriteResponseMsg();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("Result", result);
            HashMap<String, Object> ackProperties = new HashMap<String, Object>();
            ackProperties.put("CorrelationId", messageId);
            connector.sendMessage(ackResponse.encode(properties), ackResponse.getProperties(ackProperties)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning(String.format("failed to write point values %s %s", err.getMessage(), messageId));
                } else {
                    log.fine("Point values set successfully " + messageId);
                }
            });
            log.info(String.format("Sentience point write completed with %s %s", result, messageId));
        }
    }

    @Override
    public void handleMultiWriteAndReponse(CloudDecodeMsg request, String messageId, Context cx) {
        BICloudConnector connector = this.cloudConnectorDevice.resolveConnector();
        if (CloudUtilities.canSendMessage(this.cloudConnectorDevice)) {
            ArrayList<CloudMultiPointData> list = new ArrayList<CloudMultiPointData>();
            JSONArray points = (JSONArray)request.getData("PointWrites");
            boolean networkPointWriteAllowed = true;
            if (!this.cloudConnectorDevice.getNiagaraCloudNetwork().getPointWriteAllowed()) {
                log.warning(() -> String.format(LEX.getText("accessNotAllowed"), "network point read") + ' ' + messageId);
                networkPointWriteAllowed = false;
            }
            String callingIdentity = (String)request.getData("CallingIdentity");
            for (int i = 0; i < points.length(); ++i) {
                JSONObject pointObj = (JSONObject)points.get(i);
                log.fine(() -> String.format("SentienceWriteHandler multiwrite: point object:%s", pointObj));
                String sentiencePointId = (String)pointObj.get("PointId");
                BControlPoint pxPoint = CloudUtilities.getPoint(SlotPath.unescape((String)sentiencePointId));
                if (pxPoint != null && CloudUtilities.isPointWriteAllowed(this.cloudConnectorDevice.getNiagaraCloudNetwork(), pxPoint, cx)) {
                    try {
                        if (SentienceWriteHandler.writePoint(pxPoint, pointObj.get("Value"), 0, null, callingIdentity, messageId, cx)) {
                            list.add(new CloudMultiPointData(sentiencePointId, "Success", null));
                            continue;
                        }
                        list.add(new CloudMultiPointData(sentiencePointId, "Error: Invalid point value", null));
                    }
                    catch (PermissionException ignored) {
                        list.add(new CloudMultiPointData(sentiencePointId, "Error: Access Not Allowed", null));
                        log.warning(() -> String.format(LEX.getText("accessNotAllowed"), sentiencePointId) + ' ' + messageId);
                    }
                    continue;
                }
                list.add(new CloudMultiPointData(sentiencePointId, "Error: Access Not Allowed", null));
                if (!networkPointWriteAllowed) continue;
                log.warning(() -> String.format(LEX.getText("accessNotAllowed"), sentiencePointId) + ' ' + messageId);
            }
            this.handleMultiResponse(connector, messageId, list);
        }
    }

    public void handleMultiResponse(BICloudConnector connector, String messageId, List<CloudMultiPointData> list) {
        CloudEncodeMsg ackResponse = this.cloudConnectorDevice.getFactory().createMultiPointWriteResponseMsg();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("PointValues", list);
        HashMap<String, Object> ackProperties = new HashMap<String, Object>();
        ackProperties.put("CorrelationId", messageId);
        connector.sendMessage(ackResponse.encode(properties), ackResponse.getProperties(ackProperties)).whenComplete((resp, err) -> {
            if (err != null) {
                log.warning(String.format("failed to write point values %s %s", err.getMessage(), messageId));
            } else {
                log.fine("Point values set successfully " + messageId);
            }
        });
        log.info(String.format("Sentience multi point write completed for %d points %s", list.size(), messageId));
    }
}

