/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.alarms;

import com.tridium.cloud.client.BConnectorImpl;
import com.tridium.cloud.client.BICloudConnector;
import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.cloud.client.sentience.BSentienceConnectorImpl;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONStringer;
import com.tridium.json.JSONWriter;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.sentience.SentienceCloudUtilities;
import com.tridium.nc.devices.sentience.events.AnnotationBody;
import com.tridium.nc.history.BCloudHistoryExport;
import com.tridium.nc.point.BCloudProxyExt;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.util.BFormat;

public abstract class SentienceAlarmMessage
implements CloudEncodeMsg {
    protected final BCloudDevice cloudConnectorDevice;
    public static final String MSG_TEXT = "msgText";
    protected static final Logger log = Logger.getLogger("ncloud.alarm");

    SentienceAlarmMessage(BCloudDevice cloudConnectorDevice) {
        this.cloudConnectorDevice = cloudConnectorDevice;
    }

    public abstract String getVersion();

    @Override
    public String encode(Map<String, Object> props) {
        JSONStringer writer = new JSONStringer();
        writer.object();
        writer.key("Alarm");
        this.encodeAlarm((JSONWriter)writer, (BAlarmRecord)props.get("Alarm"), (String)props.get("SystemGuid"));
        writer.key("SystemGuid").value(props.get("SystemGuid"));
        writer.endObject();
        return writer.toString();
    }

    void encodeAlarm(JSONWriter writer, BAlarmRecord alarm, String systemGuid) {
        writer.object();
        writer.key("Id").value((Object)alarm.getUuid());
        writer.key("CreatedTime").value((Object)alarm.getTimestamp().encodeToString());
        writer.key("CreatorId").value((Object)"NiagaraFramework");
        writer.key("CreatorType").value((Object)"Niagara4");
        writer.key("GeneratorId").value((Object)systemGuid);
        writer.key("GeneratorType").value((Object)"NiagaraCloudConnector");
        this.addTargetProperties(writer, alarm);
        writer.key("Body");
        writer.object();
        writer.key("Type").value((Object)AnnotationBody.bodyType.TEXT.getType());
        JSONObject bodyValue = new JSONObject();
        SentienceAlarmMessage.buildBody(bodyValue, alarm);
        writer.key("Value").value((Object)bodyValue.toString());
        writer.key("Format").value((Object)AnnotationBody.bodyFormat.JSON.getFormat());
        writer.endObject();
        writer.key("TriggeringEvents");
        SentienceAlarmMessage.buildTriggeringEvents(writer, alarm);
        writer.key("BodyProperties");
        this.buildBodyProperties(writer, alarm);
        writer.key("AlarmState").value((Object)SentienceAlarmMessage.getAlarmState(alarm).toString());
        writer.key("Priority").value((Object)SentienceAlarmMessage.getAlarmPriority(alarm).toString());
        writer.key("AckState").value((Object)SentienceAlarmMessage.getAlarmAckState(alarm).toString());
        writer.key("AckTime").value((Object)alarm.getAckTime().encodeToString());
        writer.key("AckUser").value((Object)alarm.getUser());
        writer.endObject();
    }

    private void addTargetProperties(JSONWriter writer, BAlarmRecord alarm) {
        StringBuilder targetIdList = new StringBuilder();
        StringBuilder targetTypeList = new StringBuilder();
        try {
            BOrdList ordList = alarm.getSource();
            log.fine(() -> String.format("SentienceAlarmMessage: getSource() alarm:%s; alarm source ordlist=%s", alarm, ordList));
            BOrd ord = BOrd.DEFAULT;
            if (ordList.size() > 0) {
                ord = ordList.get(ordList.size() - 1);
            }
            BObject sourceObj = ord.resolve((BObject)this.cloudConnectorDevice).get();
            BControlPoint sourcePoint = null;
            if (sourceObj instanceof BAlarmSourceExt) {
                log.finest(() -> String.format("Alarm source is BAlarmSourceExt:%s", sourceObj.asComponent().getSlotPath()));
                sourcePoint = ((BAlarmSourceExt)sourceObj.as(BAlarmSourceExt.class)).getParentPoint();
            } else if (sourceObj instanceof BIAlarmSource) {
                log.finest(() -> String.format("Alarm source is BIAlarmSource:%s", sourceObj.asComponent().getSlotPath()));
                BComponent parent = sourceObj.asComplex().getParent().asComponent();
                if (parent instanceof BControlPoint) {
                    log.finest(() -> String.format("Found control point parent for alarm source:%s [%s]", parent.getSlotPath(), parent.getType()));
                    sourcePoint = (BControlPoint)parent.as(BControlPoint.class);
                } else {
                    log.finest(() -> String.format("BIAlarmSource parent is not a control point:%s [%s]", parent.getSlotPath(), parent.getType()));
                }
            }
            if (sourcePoint != null) {
                BCloudHistoryExport export;
                BCloudProxyExt proxyExt = this.cloudConnectorDevice.getPoints().getProxyExtBySource((BControlPoint)sourcePoint.as(BControlPoint.class));
                if (proxyExt != null) {
                    log.fine(() -> String.format("cloudProxyExt source pointId: %s", proxyExt.getPointId()));
                    targetIdList.append(proxyExt.getPointId()).append(';');
                    targetTypeList.append("Point").append(';');
                }
                if ((export = this.cloudConnectorDevice.getHistories().getHistoryExportBySource((BComponent)sourcePoint)) != null) {
                    log.fine(() -> String.format("cloudHistoryExport source historyId: %s", export.getHistoryId()));
                    targetIdList.append(export.getHistoryId().fromShorthand(Sys.getStation().getStationName())).append(';');
                    targetTypeList.append("History").append(';');
                }
                if (targetIdList.length() > 0) {
                    targetIdList.setLength(targetIdList.length() - 1);
                }
                if (targetTypeList.length() > 0) {
                    targetTypeList.setLength(targetTypeList.length() - 1);
                }
            } else {
                log.config(String.format("No associated cloud export component for source:%s -> %s [%s]", ord, sourceObj, sourceObj.getType()));
                targetIdList.append(alarm.getSource().encodeToString());
                targetTypeList.append("Device");
            }
        }
        catch (Exception e) {
            log.log(Level.CONFIG, "Cannot resolve alarm to cloud point:" + e, log.isLoggable(Level.FINER) ? e : null);
            targetIdList.append(alarm.getSource().encodeToString());
            targetTypeList.append("Device");
        }
        writer.key("TargetId").value((Object)targetIdList.toString());
        writer.key("TargetType").value((Object)targetTypeList.toString());
        writer.key("TargetContext").value((Object)"Alarm");
    }

    private void buildBodyProperties(JSONWriter writer, BAlarmRecord record) {
        writer.array();
        BICloudConnector connector = this.cloudConnectorDevice.resolveConnector();
        BConnectorImpl conImpl = connector.getConnectorImpl();
        if (conImpl instanceof BSentienceConnectorImpl) {
            SentienceAlarmMessage.addProperty(writer, "SystemType", ((BSentienceConnectorImpl)conImpl).getSystemType());
        }
        SentienceAlarmMessage.addProperty(writer, "SystemGuid", connector.getId());
        writer.endArray();
    }

    private static void buildBody(JSONObject bodyValue, BAlarmRecord record) {
        BFacets alarmData = record.getAlarmData();
        for (String key : alarmData.list()) {
            if (key.equalsIgnoreCase(MSG_TEXT)) {
                bodyValue.put(key, (Object)BFormat.make((String)alarmData.get(key).toString()).format((Object)record));
                continue;
            }
            bodyValue.put(key, (Object)alarmData.get(key));
        }
        bodyValue.put("AlarmClass", (Object)record.getAlarmClass());
        bodyValue.put("NormalTime", (Object)record.getNormalTime().encodeToString());
        bodyValue.put("LastUpdateTime", (Object)record.getLastUpdate().encodeToString());
        bodyValue.put("AckRequired", record.getAckRequired());
        bodyValue.put("Priority", record.getPriority());
        bodyValue.put("AlarmState", (Object)record.getSourceState().toString());
        bodyValue.put("AlarmTransition", (Object)record.getAlarmTransition().toString());
    }

    private static void buildTriggeringEvents(JSONWriter writer, BAlarmRecord record) {
        writer.array();
        writer.object();
        writer.key("EventType").value((Object)record.getAlarmTransition().toString());
        writer.key("EventId").value((long)record.getAlarmTransition().getOrdinal());
        writer.endObject();
        writer.endArray();
    }

    protected static AlarmStates getAlarmState(BAlarmRecord record) {
        switch (record.getSourceState().getOrdinal()) {
            case 0: {
                return AlarmStates.Normal;
            }
            case 1: {
                return AlarmStates.Offnormal;
            }
            case 2: {
                return AlarmStates.Fault;
            }
            case 3: {
                return AlarmStates.Alert;
            }
        }
        return AlarmStates.Undefined;
    }

    protected static AckStates getAlarmAckState(BAlarmRecord record) {
        switch (record.getAckState().getOrdinal()) {
            case 0: {
                return AckStates.Acked;
            }
            case 1: {
                return AckStates.Unacked;
            }
            case 2: {
                return AckStates.Pending;
            }
        }
        return AckStates.Undefined;
    }

    protected static Priorities getAlarmPriority(BAlarmRecord record) {
        int priority = record.getPriority();
        if (SentienceCloudUtilities.isBetween(priority, 0, 31)) {
            return Priorities.Emergency;
        }
        if (SentienceCloudUtilities.isBetween(priority, 32, 64)) {
            return Priorities.Alert;
        }
        if (SentienceCloudUtilities.isBetween(priority, 65, 97)) {
            return Priorities.Critical;
        }
        if (SentienceCloudUtilities.isBetween(priority, 98, 130)) {
            return Priorities.Error;
        }
        if (SentienceCloudUtilities.isBetween(priority, 131, 163)) {
            return Priorities.Warning;
        }
        if (SentienceCloudUtilities.isBetween(priority, 164, 196)) {
            return Priorities.Notice;
        }
        if (SentienceCloudUtilities.isBetween(priority, 197, 229)) {
            return Priorities.Information;
        }
        if (SentienceCloudUtilities.isBetween(priority, 230, 254)) {
            return Priorities.Diagnostic;
        }
        return Priorities.Undefined;
    }

    @Override
    public Map<String, String> getProperties(Map<String, Object> properties) {
        Map<String, String> props = SentienceCloudUtilities.buildProperties(this.getCommand(), this.getVersion(), this.cloudConnectorDevice.resolveConnector().getId());
        props.put("NiagaraMessageType", NiagaraMessageType.alarm.name());
        return props;
    }

    protected static <T> void addProperty(JSONWriter writer, String key, T value) {
        writer.object();
        writer.key("Key").value((Object)key);
        writer.key("Value").value(value);
        writer.endObject();
    }

    protected static enum AlarmStates {
        Undefined,
        Alert,
        Offnormal,
        Normal,
        Fault,
        Deferred,
        Reopen,
        Shelved;

    }

    protected static enum Priorities {
        Undefined,
        Emergency,
        Alert,
        Critical,
        Error,
        Warning,
        Notice,
        Information,
        Diagnostic;

    }

    protected static enum AckStates {
        Undefined,
        Acked,
        Unacked,
        Pending;

    }
}

