/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience;

import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudMessage;
import com.tridium.nc.devices.CloudProtocolFactory;
import com.tridium.nc.devices.CloudReadHandler;
import com.tridium.nc.devices.CloudWriteHandler;
import com.tridium.nc.devices.sentience.SentienceRegisterCmdRequestV1;
import com.tridium.nc.devices.sentience.SentienceSystemInfoMessageV1;
import com.tridium.nc.devices.sentience.alarms.SentienceAlarmAckRequestV2;
import com.tridium.nc.devices.sentience.alarms.SentienceAlarmAckResponseV2;
import com.tridium.nc.devices.sentience.alarms.SentienceAlarmChangedMessageV3;
import com.tridium.nc.devices.sentience.alarms.SentienceAlarmRecoveryAfterDisconnectMessageV3;
import com.tridium.nc.devices.sentience.alarms.SentienceNewAlarmMessageV3;
import com.tridium.nc.devices.sentience.cmds.SentienceSystemCommandRequestV1;
import com.tridium.nc.devices.sentience.cmds.SentienceSystemCommandResponseV1;
import com.tridium.nc.devices.sentience.events.NewEventMessageRequestV2;
import com.tridium.nc.devices.sentience.history.SentienceHistoryUpdateV1;
import com.tridium.nc.devices.sentience.history.SentienceLastHistoryRequestV1;
import com.tridium.nc.devices.sentience.history.SentienceLastHistoryResponseV1;
import com.tridium.nc.devices.sentience.points.SentienceMultiReadRequestV1;
import com.tridium.nc.devices.sentience.points.SentienceMultiReadResponseV1;
import com.tridium.nc.devices.sentience.points.SentienceMultiWriteRequestV1;
import com.tridium.nc.devices.sentience.points.SentienceMultiWriteResponseV1;
import com.tridium.nc.devices.sentience.points.SentienceReadHandler;
import com.tridium.nc.devices.sentience.points.SentienceReadRequestV1;
import com.tridium.nc.devices.sentience.points.SentienceReadResponseV1;
import com.tridium.nc.devices.sentience.points.SentienceWriteHandler;
import com.tridium.nc.devices.sentience.points.SentienceWriteRequestV1;
import com.tridium.nc.devices.sentience.points.SentienceWriteResponseV1;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SentienceCloudProtocolFactory
implements CloudProtocolFactory {
    private BCloudDevice cloudDevice;

    @Override
    public CloudEncodeMsg createNewAlarmMsg() {
        return new SentienceNewAlarmMessageV3(this.cloudDevice);
    }

    @Override
    public CloudEncodeMsg createAlarmChangedMsg() {
        return new SentienceAlarmChangedMessageV3(this.cloudDevice);
    }

    @Override
    public CloudEncodeMsg createBatchAlarmMsg() {
        return new SentienceAlarmRecoveryAfterDisconnectMessageV3(this.cloudDevice);
    }

    @Override
    public CloudEncodeMsg createRegisterCmdRequestMsg(List<SentienceRegisterCmdRequestV1.RegisterCommandTypes> cmds) {
        return new SentienceRegisterCmdRequestV1(cmds, this.cloudDevice);
    }

    @Override
    public CloudDecodeMsg createAlarmAckRequestMsg() {
        return new SentienceAlarmAckRequestV2(this.cloudDevice);
    }

    @Override
    public CloudEncodeMsg createAlarmAckResponseMsg() {
        return new SentienceAlarmAckResponseV2(this.cloudDevice);
    }

    @Override
    public CloudDecodeMsg createPointReadRequestMsg() {
        return new SentienceReadRequestV1();
    }

    @Override
    public CloudEncodeMsg createPointReadResponseMsg() {
        return new SentienceReadResponseV1(this.cloudDevice);
    }

    @Override
    public CloudDecodeMsg createMultiPointReadRequestMsg() {
        return new SentienceMultiReadRequestV1();
    }

    @Override
    public CloudEncodeMsg createMultiPointReadResponseMsg() {
        return new SentienceMultiReadResponseV1(this.cloudDevice);
    }

    @Override
    public CloudReadHandler createReadHandler() {
        return new SentienceReadHandler(this.cloudDevice);
    }

    @Override
    public CloudDecodeMsg createPointWriteRequestMsg() {
        return new SentienceWriteRequestV1();
    }

    @Override
    public CloudEncodeMsg createPointWriteResponseMsg() {
        return new SentienceWriteResponseV1(this.cloudDevice);
    }

    @Override
    public CloudDecodeMsg createMultiPointWriteRequestMsg() {
        return new SentienceMultiWriteRequestV1();
    }

    @Override
    public CloudEncodeMsg createMultiPointWriteResponseMsg() {
        return new SentienceMultiWriteResponseV1(this.cloudDevice);
    }

    @Override
    public CloudWriteHandler createWriteHandler() {
        return new SentienceWriteHandler(this.cloudDevice);
    }

    @Override
    public CloudEncodeMsg createLastHistoryRequestMsg() {
        return new SentienceLastHistoryRequestV1(this.cloudDevice);
    }

    @Override
    public CloudDecodeMsg createLastHistoryResponseMsg() {
        return new SentienceLastHistoryResponseV1();
    }

    @Override
    public CloudEncodeMsg createHistoryUpdateMsg(NiagaraMessageType messageType) {
        return new SentienceHistoryUpdateV1(this.cloudDevice, messageType);
    }

    @Override
    public CloudDecodeMsg createSystemCommandRequestMsg() {
        return new SentienceSystemCommandRequestV1();
    }

    @Override
    public CloudEncodeMsg createSystemCommandResponseMsg() {
        return new SentienceSystemCommandResponseV1(this.cloudDevice);
    }

    @Override
    public CloudEncodeMsg createNewEventRequestMsg() {
        return new NewEventMessageRequestV2(this.cloudDevice);
    }

    @Override
    public CloudEncodeMsg createSystemInfoMsg() {
        return new SentienceSystemInfoMessageV1(this.cloudDevice);
    }

    @Override
    public CloudMessage decodeMessage(String messageId, byte[] payload, Map<String, String> props) {
        CloudDecodeMsg request = null;
        if ("PointReadCommand".equals(props.get("objecttype")) && "1".equals(props.get("objectversion"))) {
            request = this.cloudDevice.getFactory().createPointReadRequestMsg();
        } else if ("MultiPointReadCommand".equals(props.get("objecttype")) && "1".equals(props.get("objectversion"))) {
            request = this.cloudDevice.getFactory().createMultiPointReadRequestMsg();
        } else if ("PointWriteCommand".equals(props.get("objecttype")) && "1".equals(props.get("objectversion"))) {
            request = this.cloudDevice.getFactory().createPointWriteRequestMsg();
        } else if ("MultiPointWriteCommand".equals(props.get("objecttype")) && "1".equals(props.get("objectversion"))) {
            request = this.cloudDevice.getFactory().createMultiPointWriteRequestMsg();
        } else if ("AlarmAckRequest".equals(props.get("objecttype")) && "2".equals(props.get("objectversion"))) {
            request = this.cloudDevice.getFactory().createAlarmAckRequestMsg();
        } else if ("GetLastHistoryTimestampResponse".equals(props.get("objecttype")) && "1".equals(props.get("objectversion"))) {
            request = this.cloudDevice.getFactory().createLastHistoryResponseMsg();
        } else if ("SystemCommand".equals(props.get("objecttype")) && "1".equals(props.get("objectversion"))) {
            request = this.cloudDevice.getFactory().createSystemCommandRequestMsg();
        }
        if (request != null) {
            request.decode(new String(payload));
        }
        return request;
    }

    @Override
    public Map<String, String> getCloudMessageMapping() {
        HashMap<String, String> classRegistrations = new HashMap<String, String>();
        classRegistrations.put("CloudPointReadRequest", "PointReadCommand");
        classRegistrations.put("CloudMultiPointReadRequest", "MultiPointReadCommand");
        classRegistrations.put("CloudPointWriteRequest", "PointWriteCommand");
        classRegistrations.put("CloudMultiPointWriteRequest", "MultiPointWriteCommand");
        classRegistrations.put("CloudAlarmAckRequest", "AlarmAckRequest");
        classRegistrations.put("CloudLastHistoryResponse", "GetLastHistoryTimestampResponse");
        classRegistrations.put("CloudCommandsResponse", "SystemCommand");
        return classRegistrations;
    }

    @Override
    public void setDevice(BCloudDevice cloudDevice) {
        this.cloudDevice = cloudDevice;
    }
}

