/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience;

import com.tridium.nc.BCloudDevice;
import com.tridium.nc.BCloudDeviceFolder;
import com.tridium.nc.BNiagaraCloudNetwork;
import com.tridium.nc.CloudConstantNames;
import com.tridium.nc.NumericConstant;
import com.tridium.nc.devices.CloudProtocolFactory;
import com.tridium.nc.devices.sentience.SentienceCloudConstants;
import com.tridium.nc.devices.sentience.SentienceCloudProtocolFactory;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCloudSentienceDevice
extends BCloudDevice {
    public static final Type TYPE = Sys.loadType(BCloudSentienceDevice.class);
    private CloudProtocolFactory factory = new SentienceCloudProtocolFactory();
    private static final Properties constantLookup = new Properties();
    private static final Map<String, Integer> numericConstantLookup = new HashMap<String, Integer>();

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraCloudNetwork || parent instanceof BCloudDeviceFolder;
    }

    @Override
    public void started() throws Exception {
        this.factory.setDevice(this);
        super.started();
        this.resetFactory();
    }

    @Override
    public CloudProtocolFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getConstant(String name) {
        return constantLookup.getProperty(name);
    }

    @Override
    public int getNumericConstant(String name) {
        return numericConstantLookup.get(name);
    }

    static {
        Field[] fields = CloudConstantNames.class.getFields();
        for (int lcv = 0; lcv < fields.length; ++lcv) {
            try {
                if (fields[lcv].getAnnotation(NumericConstant.class) == null) {
                    constantLookup.setProperty((String)fields[lcv].get(null), (String)SentienceCloudConstants.class.getField(fields[lcv].getName()).get(null));
                    continue;
                }
                numericConstantLookup.put((String)fields[lcv].get(null), (int)((Integer)SentienceCloudConstants.class.getField(fields[lcv].getName()).get(null)));
                continue;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, String.format("Unable to map CloudConstantNames.%s to SentienceCloudConstants", fields[lcv].getName()), e);
            }
        }
    }
}

