/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.BCloudWriteInfo;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.nc.point.BCloudProxyExt;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.control.BControlPoint;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;

public class CloudPointReadInputsCommand
implements ICloudSystemCommand {
    private String commandName;
    private final BCloudDevice device;
    private static final Pattern IN = Pattern.compile("in");
    private static final Logger log = Logger.getLogger("ncloud.command");

    public CloudPointReadInputsCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("CloudPointReadInputsCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        String pointId = JSONUtil.getString((JSONObject)payload, (String)this.device.getConstant("POINTID"));
        BControlPoint pxPoint = CloudUtilities.getPoint(pointId);
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
        if (pxPoint != null) {
            if (CloudUtilities.isPointReadAllowed(this.device.getNiagaraCloudNetwork(), pxPoint, cx)) {
                BCloudWriteInfo[] infos = (BCloudWriteInfo[])pxPoint.getChildren(BCloudWriteInfo.class);
                JSONArray inputs = new JSONArray();
                for (BCloudWriteInfo info : infos) {
                    JSONObject obj = new JSONObject();
                    obj.put(this.device.getConstant("SOURCE"), (Object)info.getSource());
                    obj.put(this.device.getConstant("PRIORITY"), CloudPointReadInputsCommand.getLevel(CloudUtilities.cloudProxy(pxPoint), info));
                    obj.put(this.device.getConstant("VALUE"), (Object)Objects.toString(info.getValue().valueToString(cx)));
                    obj.put(this.device.getConstant("EXPIRATION"), (Object)info.getExpiration().encodeToString());
                    inputs.put((Object)obj);
                }
                responseProperties.put(pointId, inputs);
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
            } else {
                log.warning(() -> String.format("Attempted to read inputs from Point: access not allowed %s", messageId));
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            }
        } else {
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
        }
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }

    public static int getLevel(BCloudProxyExt pxExt, BCloudWriteInfo info) {
        try {
            Knob[] knobs;
            for (Knob knob : knobs = info.getKnobs()) {
                if (knob.getTargetComponent() != pxExt.getOrdPath().get((BObject)pxExt)) continue;
                if ("fallback".equals(knob.getTargetSlotName())) {
                    return 17;
                }
                return Integer.parseInt(IN.matcher(knob.getTargetSlotName()).replaceFirst(""));
            }
        }
        catch (Exception e) {
            log.finest(() -> String.format("CloudPointReadInputsCommand.getLevel for info %s in %s: cannot determine level: %s", pxExt.getPointId(), info.getName(), e));
        }
        return 0;
    }
}

