/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.alarms;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.CloudEncodeMsg;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="device", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:Component\")")}), @NiagaraProperty(name="enableBatchAlarms", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(nCloudDriver:alarms.batch.enabled)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(nCloudDriver:alarms.batch.disabled)%\"")}), @NiagaraProperty(name="alarmBatchDelay", type="BRelTime", defaultValue="BRelTime.make(30000)"), @NiagaraProperty(name="alarmBatchSize", type="int", defaultValue="100", facets={@Facet(name="BFacets.MIN", value="2"), @Facet(name="BFacets.MAX", value="512")}), @NiagaraProperty(name="sendFailWarnInterval", type="BRelTime", defaultValue="BRelTime.makeHours(1)", flags=5), @NiagaraProperty(name="lastSentToCloud", type="BAbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}, flags=1)})
@NiagaraAction(name="sendBatchAlarms", flags=4)
public class BCloudAlarmRecipient
extends BAlarmRecipient {
    public static final Property device = BCloudAlarmRecipient.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:Component")));
    public static final Property enableBatchAlarms = BCloudAlarmRecipient.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(nCloudDriver:alarms.batch.enabled)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(nCloudDriver:alarms.batch.disabled)%")));
    public static final Property alarmBatchDelay = BCloudAlarmRecipient.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    public static final Property alarmBatchSize = BCloudAlarmRecipient.newProperty((int)0, (int)100, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)2), (BFacets)BFacets.make((String)"max", (int)512)));
    public static final Property sendFailWarnInterval = BCloudAlarmRecipient.newProperty((int)5, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property lastSentToCloud = BCloudAlarmRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    public static final Action sendBatchAlarms = BCloudAlarmRecipient.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BCloudAlarmRecipient.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"alarm.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final Logger log = Logger.getLogger("ncloud.alarm");
    private static final Lexicon lexicon = Lexicon.make((String)"nCloudDriver");
    private static final ReentrantLock alarmBatchLock = new ReentrantLock();
    private volatile BICloudConnector connector;
    private volatile BCloudDevice resolvedDevice;
    private Clock.Ticket alarmSendTicket = null;
    private int pendingAlarmCount = 0;
    private BAlarmRecord[] pendingAlarms = null;
    private BAbsTime lastSendFailTime = null;
    private boolean alarmSendFailLogFlag = false;

    public BOrd getDevice() {
        return (BOrd)this.get(device);
    }

    public void setDevice(BOrd v) {
        this.set(device, (BValue)v, null);
    }

    public boolean getEnableBatchAlarms() {
        return this.getBoolean(enableBatchAlarms);
    }

    public void setEnableBatchAlarms(boolean v) {
        this.setBoolean(enableBatchAlarms, v, null);
    }

    public BRelTime getAlarmBatchDelay() {
        return (BRelTime)this.get(alarmBatchDelay);
    }

    public void setAlarmBatchDelay(BRelTime v) {
        this.set(alarmBatchDelay, (BValue)v, null);
    }

    public int getAlarmBatchSize() {
        return this.getInt(alarmBatchSize);
    }

    public void setAlarmBatchSize(int v) {
        this.setInt(alarmBatchSize, v, null);
    }

    public BRelTime getSendFailWarnInterval() {
        return (BRelTime)this.get(sendFailWarnInterval);
    }

    public void setSendFailWarnInterval(BRelTime v) {
        this.set(sendFailWarnInterval, (BValue)v, null);
    }

    public BAbsTime getLastSentToCloud() {
        return (BAbsTime)this.get(lastSentToCloud);
    }

    public void setLastSentToCloud(BAbsTime v) {
        this.set(lastSentToCloud, (BValue)v, null);
    }

    public void sendBatchAlarms() {
        this.invoke(sendBatchAlarms, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.setupConnector();
        if (this.getLastSentToCloud() == BAbsTime.NULL) {
            this.setLastSentToCloud(BAbsTime.now());
        }
        if (this.getEnableBatchAlarms()) {
            this.pendingAlarms = new BAlarmRecord[this.getAlarmBatchSize()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(device)) {
            this.resolvedDevice = null;
            this.setupConnector();
        }
        if (enableBatchAlarms.equals(prop)) {
            if (this.getEnableBatchAlarms()) {
                this.pendingAlarms = new BAlarmRecord[this.getAlarmBatchSize()];
                this.pendingAlarmCount = 0;
            } else if (this.pendingAlarmCount > 0) {
                this.doSendBatchAlarms();
                this.pendingAlarms = null;
            }
        } else if (alarmBatchSize.equals(prop)) {
            if (this.pendingAlarmCount > this.getAlarmBatchSize()) {
                this.doSendBatchAlarms();
            }
            BAlarmRecord[] tmpAlarms = new BAlarmRecord[this.getAlarmBatchSize()];
            alarmBatchLock.lock();
            try {
                System.arraycopy(this.pendingAlarms, 0, tmpAlarms, 0, this.pendingAlarmCount);
                this.pendingAlarms = tmpAlarms;
            }
            finally {
                alarmBatchLock.unlock();
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAlarmService || parent instanceof BAlarmClassFolder;
    }

    private void setupConnector() {
        this.resolvedDevice = this.resolvedDevice == null ? this.getCloudConnectorDevice() : this.resolvedDevice;
        this.connector = this.resolvedDevice != null ? this.resolvedDevice.resolveConnector() : this.connector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAlarm(BAlarmRecord alarm) {
        if (this.resolvedDevice == null || this.connector == null) {
            this.setupConnector();
        }
        if (this.resolvedDevice == null) {
            log.warning(String.format(lexicon.getText("cloudAlarmRecipientNullDevice"), this.getDisplayName(null)));
            this.clearPendingAlarms();
            this.alarmSendFailLogFlag = true;
            return;
        }
        if (!this.resolvedDevice.getNiagaraCloudNetwork().isFatalFault()) {
            if (this.connector == null || !this.connector.isConnected()) {
                if (!this.alarmSendFailLogFlag) {
                    log.warning("Cannot send alarms while the Cloud Connector is disconnected.");
                }
                this.clearPendingAlarms();
                this.alarmSendFailLogFlag = true;
                return;
            }
            if (this.getEnableBatchAlarms()) {
                alarmBatchLock.lock();
                try {
                    if (this.alarmSendTicket == null) {
                        this.alarmSendTicket = Clock.schedule((BComponent)this, (BRelTime)this.getAlarmBatchDelay(), (Action)sendBatchAlarms, null);
                    }
                    this.pendingAlarms[this.pendingAlarmCount++] = alarm;
                    if (this.pendingAlarmCount < this.getAlarmBatchSize()) return;
                    this.doSendBatchAlarms();
                    return;
                }
                finally {
                    if (alarmBatchLock.isHeldByCurrentThread()) {
                        alarmBatchLock.unlock();
                    }
                }
            } else {
                this.sendAlarm(alarm);
            }
            return;
        } else {
            log.severe(lexicon.getText("alarms.noLicense"));
        }
    }

    private void clearPendingAlarms() {
        if (this.alarmSendTicket != null) {
            this.alarmSendTicket.cancel();
            this.alarmSendTicket = null;
        }
        for (int lcv = 0; lcv < this.pendingAlarmCount; ++lcv) {
            this.pendingAlarms[lcv] = null;
        }
        this.pendingAlarmCount = 0;
    }

    private void sendAlarm(BAlarmRecord alarmRecord) {
        if (this.connector == null) {
            this.setupConnector();
        }
        if (CloudUtilities.canSendMessage(this.getCloudConnectorDevice())) {
            CloudEncodeMsg alarmMsg = BCloudAlarmRecipient.isNewAlarm(alarmRecord) || this.getLastSentToCloud().isBefore(alarmRecord.getTimestamp()) ? this.resolvedDevice.getFactory().createNewAlarmMsg() : this.resolvedDevice.getFactory().createAlarmChangedMsg();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("Alarm", alarmRecord);
            properties.put("SystemGuid", this.connector.getId());
            BAbsTime lastUpdate = alarmRecord.getLastUpdate();
            CompletionStage future = this.connector.sendMessage(alarmMsg.encode(properties), alarmMsg.getProperties(null)).whenComplete((resp, err) -> {
                if (err != null) {
                    if (this.lastSendFailTime == null || BAbsTime.now().getMillis() - this.lastSendFailTime.getMillis() > this.getSendFailWarnInterval().getMillis()) {
                        this.lastSendFailTime = BAbsTime.now();
                        log.warning("Failed to send alarm message to cloud.");
                    } else {
                        log.config("Failed to send alarm message to cloud.");
                    }
                } else {
                    this.lastSendFailTime = null;
                    this.setLastSentToCloud(lastUpdate);
                    log.fine("Alarm message sent to cloud successfully.");
                    this.alarmSendFailLogFlag = false;
                }
            });
            if (((CompletableFuture)future).isCompletedExceptionally()) {
                try {
                    ((CompletableFuture)future).get();
                }
                catch (ExecutionException e) {
                    if ("Queue full, try again later.".equals(e.getCause().getMessage())) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static boolean isNewAlarm(BAlarmRecord rec) {
        return rec.getAckTime().isNull() && rec.getNormalTime().isNull();
    }

    public final BCloudDevice getCloudConnectorDevice() {
        try {
            if (!this.getDevice().isNull()) {
                return (BCloudDevice)this.getDevice().get();
            }
        }
        catch (ClassCastException | UnresolvedException cce) {
            log.warning(String.format(lexicon.getText("cloudAlarmRecipientInvalidDevice"), this.getDisplayName(null)));
        }
        return null;
    }

    public void doSendBatchAlarms() {
        BAlarmRecord[] alarms;
        if (this.resolvedDevice == null || this.connector == null) {
            this.setupConnector();
        }
        if (this.connector == null || !this.connector.isConnected()) {
            log.warning(lexicon.getText("alarms.noCCConnection"));
            this.clearPendingAlarms();
            return;
        }
        if (!alarmBatchLock.isHeldByCurrentThread()) {
            alarmBatchLock.lock();
        }
        try {
            alarms = new BAlarmRecord[this.pendingAlarmCount];
            System.arraycopy(this.pendingAlarms, 0, alarms, 0, this.pendingAlarmCount);
            this.clearPendingAlarms();
        }
        finally {
            alarmBatchLock.unlock();
        }
        CloudEncodeMsg alarmMsg = this.resolvedDevice.getFactory().createBatchAlarmMsg();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(this.resolvedDevice.getConstant("ALARMS"), alarms);
        properties.put(this.resolvedDevice.getConstant("SYSTEMGUID"), this.connector.getId());
        BAbsTime lat = alarms[alarms.length - 1].getLastUpdate();
        for (int lcv = alarms.length - 2; lcv >= 0; --lcv) {
            if (alarms[lcv].getLastUpdate().getMillis() <= lat.getMillis()) continue;
            lat = alarms[lcv].getLastUpdate();
        }
        BAbsTime lastAlarmTime = lat;
        int alarmsLength = alarms.length;
        this.connector.sendMessage(alarmMsg.encode(properties), alarmMsg.getProperties(null)).whenComplete((resp, err) -> {
            if (err != null) {
                if (this.lastSendFailTime == null || BAbsTime.now().getMillis() - this.lastSendFailTime.getMillis() > this.getSendFailWarnInterval().getMillis()) {
                    this.lastSendFailTime = BAbsTime.now();
                    log.warning("Failed to send alarms message to cloud.");
                } else {
                    log.config("Failed to send alarms message to cloud.");
                }
            } else {
                this.lastSendFailTime = null;
                if (lastAlarmTime.isAfter(this.getLastSentToCloud())) {
                    this.setLastSentToCloud(lastAlarmTime);
                }
                log.fine(() -> String.format("%d Alarm messages sent to cloud successfully.", alarmsLength));
                this.alarmSendFailLogFlag = false;
            }
        });
    }

    public BIcon getIcon() {
        return icon;
    }
}

