/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.alarms;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.driver.util.DrUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudMessageCallback;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.alarms.BCloudAlarmAcknowledger;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudMessage;
import com.tridium.nc.devices.sentience.SentienceRegisterCmdRequestV1;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

@NiagaraType
public final class BCloudAlarmExt
extends BAlarmDeviceExt
implements CloudMessageCallback {
    public static final Type TYPE = Sys.loadType(BCloudAlarmExt.class);
    private static final Logger log = Logger.getLogger("ncloud.alarm");
    private static final String ackAppId = "CloudAcknowledgerAppID";
    private static final String ackAppName = "CloudAcknowledgerName";

    public Type getType() {
        return TYPE;
    }

    public void registerForCommands() {
        try {
            CloudEncodeMsg registerCmdReq = this.getCloudConnectorDevice().getFactory().createRegisterCmdRequestMsg(Collections.singletonList(SentienceRegisterCmdRequestV1.RegisterCommandTypes.ALARM_ACK));
            this.getCloudConnectorDevice().resolveConnector().sendMessage(registerCmdReq.encode(null), registerCmdReq.getProperties(null)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning("Failed to register alarm ack command");
                } else {
                    log.fine("Alarm ack command registered successfully");
                }
            });
        }
        catch (Exception err2) {
            log.log(Level.WARNING, "Error attempting to register CloudAlarmExt for commands.", err2);
        }
    }

    @Override
    public void onMessage(String messageId, CloudMessage decodedMessage, Context cx) {
        BCloudDevice device = this.getCloudConnectorDevice();
        CloudDecodeMsg ackRequest = (CloudDecodeMsg)decodedMessage;
        String alarmId = (String)ackRequest.getData(device.getConstant("ALARMID"));
        BString appId = BString.make((String)((String)ackRequest.getData(device.getConstant("CALLINGID"))));
        BString appName = BString.make((String)((String)ackRequest.getData(device.getConstant("ALARMACKNAME"))));
        AckHelper result = this.acknowledgeAlarm(alarmId, appId, appName, messageId, cx);
        this.sendResult(messageId, alarmId, result.getStatus(), result.getMessage());
        log.info(() -> String.format("Sentience alarm ack request %s with message %s %s", result.getStatus() != false ? "Successful" : "failed", result.getMessage(), messageId));
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public CloudEncodeMsg getResponse() {
        BCloudDevice device = (BCloudDevice)this.getDevice();
        return device.getFactory().createAlarmAckResponseMsg();
    }

    @Override
    public Map<String, Object> getResponseParams(String messageId, CloudDecodeMsg decodedMessage, int code, String message) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("IsSuccessful", false);
        properties.put("Message", message);
        return properties;
    }

    public void doRouteAlarm(BAlarmRecord record) throws Exception {
    }

    public BBoolean doAckAlarm(BAlarmRecord record) throws Exception {
        return null;
    }

    public BCloudDevice getCloudConnectorDevice() {
        return (BCloudDevice)DrUtil.getParent((BComplex)this, (Type)BCloudDevice.TYPE);
    }

    public boolean isParentLegal(BComponent p) {
        return p instanceof BCloudDevice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AckHelper acknowledgeAlarm(String alarmId, BString appId, BString appName, String messageId, Context cx) {
        String string;
        BCloudAlarmAcknowledger acknowledger = new BCloudAlarmAcknowledger();
        acknowledger.setAckAlarmsFromSameSource(false);
        BUuid uuid = null;
        try {
            uuid = BUuid.make((String)alarmId);
        }
        catch (Exception e) {
            log.warning(() -> String.format("Unable to ack alarm, invalid alarm id format %s %s", alarmId, messageId));
            return new AckHelper(false, "The alarm with id " + alarmId + " has invalid format");
        }
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BUser user = cx.getUser();
        try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
            BAlarmRecord rec = conn.getRecord(uuid);
            if (rec == null) {
                log.info(() -> String.format("Unable to ack alarm, Could not find alarm with id %s, message id %s", alarmId, messageId));
                AckHelper ackHelper = new AckHelper(false, "Could not find alarm with id " + alarmId);
                return ackHelper;
            }
            if (!this.hasAlarmAckPermissions(alarmService, rec, user)) {
                log.warning(() -> String.format("Failure to acknowledge alarm with ID %s due to insufficient permission for user %s, message id %s", alarmId, user.getUsername(), messageId));
                AckHelper ackHelper = new AckHelper(false, String.format("Insufficient permission to acknowledge alarm with ID %s", alarmId));
                return ackHelper;
            }
            if (!rec.isAcknowledged()) {
                rec = (BAlarmRecord)rec.newCopy(true);
                BFacets ackFacets = BFacets.make((String)ackAppId, (BIDataValue)appId, (String)ackAppName, (BIDataValue)appName);
                rec.setAlarmData(BFacets.make((BFacets)rec.getAlarmData(), (BFacets)ackFacets));
                conn.update(rec);
                acknowledger.handleAlarm(uuid, user.getName());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.format("Failure to acknowledge alarm (%s) %s %s", alarmId, e, messageId));
            return new AckHelper(false, String.format("Unable to ack alarm with ID %s, %s", alarmId, e.getMessage()));
        }
        Boolean success = acknowledger.getTotalAlarmAckedFailures() == 0;
        StringBuilder stringBuilder = new StringBuilder();
        if (success.booleanValue()) {
            string = "Acknowledged";
            return new AckHelper(success, stringBuilder.append(string).append(" alarm with id ").append(alarmId).toString());
        }
        string = "Unable to acknowledge";
        return new AckHelper(success, stringBuilder.append(string).append(" alarm with id ").append(alarmId).toString());
    }

    private void sendResult(String messageId, String alarmId, boolean success, String message) {
        BCloudDevice cloudConnectorDevice = this.getCloudConnectorDevice();
        BICloudConnector connector = cloudConnectorDevice.resolveConnector();
        if (CloudUtilities.canSendMessage(cloudConnectorDevice)) {
            CloudEncodeMsg ackResponse = cloudConnectorDevice.getFactory().createAlarmAckResponseMsg();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("IsSuccessful", success);
            properties.put("Message", message);
            HashMap<String, Object> ackProperties = new HashMap<String, Object>();
            ackProperties.put("AlarmId", alarmId);
            ackProperties.put("CorrelationId", messageId);
            CompletionStage future = connector.sendMessage(ackResponse.encode(properties), ackResponse.getProperties(ackProperties)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning(() -> String.format("failed to respond for acknowledged alarm %s, %s", err.getMessage(), messageId));
                } else {
                    log.fine(() -> "Response sent for Acknowledged alarm " + messageId);
                }
            });
            if (((CompletableFuture)future).isCompletedExceptionally()) {
                try {
                    ((CompletableFuture)future).get();
                }
                catch (ExecutionException e) {
                    if ("Queue full, try again later.".equals(e.getCause().getMessage())) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public boolean hasAlarmAckPermissions(BAlarmService alarmService, BAlarmRecord alarmRec, BUser user) {
        BAlarmClass alarmClass = alarmService.lookupAlarmClass(alarmRec.getAlarmClass());
        BPermissions permissions = user.getPermissionsFor((BIProtected)alarmClass);
        return permissions.hasOperatorWrite() || permissions.hasAdminWrite();
    }

    public class AckHelper {
        private Boolean status;
        private String message;

        AckHelper(Boolean status, String message) {
            this.status = status;
            this.message = message;
        }

        public Boolean getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

