/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc;

import com.tridium.cloud.client.BCloudConnector;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.BCloudDeviceFolder;
import com.tridium.nc.devices.sentience.BCloudSentienceDevice;
import com.tridium.nc.point.BCloudTuningPolicy;
import com.tridium.nc.point.BCloudTuningPolicyMap;
import com.tridium.ndriver.BNNetwork;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="tuningPolicies", type="BTuningPolicyMap", defaultValue="new BCloudTuningPolicyMap()", override=true), @NiagaraProperty(name="useDriverIdForPointId", type="boolean", defaultValue="false", flags=4, facets={@Facet(name="BFacets.FALSE_TEXT", value="BString.make(Lexicon.make(\"nCloudDriver\").getText(\"useDriverIdForPointId.nchsdComputed\"))"), @Facet(name="BFacets.TRUE_TEXT", value="BString.make(Lexicon.make(\"nCloudDriver\").getText(\"useDriverIdForPointId.driverComputed\"))")})})
@NiagaraActions(value={@NiagaraAction(name="getConnectors", returnType="BString", flags=5), @NiagaraAction(name="ping", flags=4, override=true)})
public class BNiagaraCloudNetwork
extends BNNetwork {
    public static final Property tuningPolicies = BNiagaraCloudNetwork.newProperty((int)0, (BValue)new BCloudTuningPolicyMap(), null);
    public static final Property useDriverIdForPointId = BNiagaraCloudNetwork.newProperty((int)4, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)Lexicon.make((String)"nCloudDriver").getText("useDriverIdForPointId.nchsdComputed"))), (BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)Lexicon.make((String)"nCloudDriver").getText("useDriverIdForPointId.driverComputed")))));
    public static final Action getConnectors = BNiagaraCloudNetwork.newAction((int)5, null);
    public static final Action ping = BNiagaraCloudNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNiagaraCloudNetwork.class);
    public static final Lexicon LEX = Lexicon.make(BNiagaraCloudNetwork.class);
    public static final String POINT_READ_ALLOWED = SlotPath.escape((String)LEX.getText("pointReadAllowed"));
    public static final String POINT_WRITE_ALLOWED = SlotPath.escape((String)LEX.getText("pointWriteAllowed"));
    private static final Logger log = Logger.getLogger("ncloud");

    public boolean getUseDriverIdForPointId() {
        return this.getBoolean(useDriverIdForPointId);
    }

    public void setUseDriverIdForPointId(boolean v) {
        this.setBoolean(useDriverIdForPointId, v, null);
    }

    public BString getConnectors() {
        return (BString)this.invoke(getConnectors, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getProperty(POINT_READ_ALLOWED) == null) {
            this.add(POINT_READ_ALLOWED, (BValue)BBoolean.FALSE);
        }
        if (this.getProperty(POINT_WRITE_ALLOWED) == null) {
            this.add(POINT_WRITE_ALLOWED, (BValue)BBoolean.FALSE);
        }
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(enabled) && this.getEnabled()) {
            BCloudDevice[] devices;
            for (BCloudDevice device : devices = (BCloudDevice[])this.getChildren(BCloudDevice.class)) {
                if (!device.getEnabled()) continue;
                device.getHistories().setBackfillStartTime();
            }
        }
    }

    public String getNetworkName() {
        return BNiagaraCloudNetwork.getStaticNetworkName();
    }

    public Type getDeviceFolderType() {
        return BCloudDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BCloudSentienceDevice.TYPE;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("ndriver:NDeviceManager");
        return agents;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value != null && value.getType().is(BCloudDevice.TYPE) && !value.getType().is(BCloudSentienceDevice.TYPE)) {
            throw new LocalizableRuntimeException("nCloudDriver", "cannotAddCloudDevice");
        }
    }

    public static BNiagaraCloudNetwork getNiagaraCloudNetwork() {
        return (BNiagaraCloudNetwork)Sys.getService((Type)TYPE);
    }

    public static String getStaticNetworkName() {
        return "NiagaraCloudNetwork";
    }

    public BString doGetConnectors() {
        int count = 0;
        String firstConnectorPath = null;
        BOrd ord = BOrd.make((String)"station:|slot:/Services|bql:select * from cloudConnector:CloudConnector");
        BITable result = (BITable)ord.resolve((BObject)this).get();
        TableCursor c = result.cursor();
        while (c.next()) {
            BCloudConnector connector = (BCloudConnector)c.get();
            if (firstConnectorPath == null) {
                firstConnectorPath = "station:|" + connector.getSlotPath().toString();
            }
            ++count;
        }
        if (count == 1) {
            return BString.make(firstConnectorPath);
        }
        return null;
    }

    public BCloudTuningPolicyMap tuningPolicies() {
        return (BCloudTuningPolicyMap)this.getTuningPolicies();
    }

    public void tuningChanged(BCloudTuningPolicy policy, Context cx) {
        BCloudDevice[] devices;
        for (BCloudDevice device : devices = (BCloudDevice[])this.getChildren(BCloudDevice.class)) {
            device.tuningChanged(policy, cx);
        }
    }

    public boolean getPointReadAllowed() {
        return this.isAllowed(POINT_READ_ALLOWED);
    }

    public boolean getPointWriteAllowed() {
        return this.isAllowed(POINT_WRITE_ALLOWED);
    }

    private boolean isAllowed(String propertyName) {
        try {
            Property pAllowed = this.getProperty(propertyName);
            if (pAllowed != null && pAllowed.getType().is(BBoolean.TYPE)) {
                return this.getBoolean(pAllowed);
            }
        }
        catch (Exception e) {
            log.fine(String.format("Exception getting %s:%s", propertyName, e));
        }
        return false;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "nCloudDriver");
    }
}

