/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc;

import com.tridium.authn.BAuthenticationService;
import com.tridium.bql.projection.BProjectionTable;
import com.tridium.cloud.client.BICloudConnector;
import com.tridium.cloud.client.ConnectCallback;
import com.tridium.cloud.client.MessageCallback;
import com.tridium.json.JSONObject;
import com.tridium.nc.BNiagaraCloudNetwork;
import com.tridium.nc.CloudMessageCallback;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.alarms.BCloudAlarmExt;
import com.tridium.nc.alarms.BCloudAlarmRecipient;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.MessageCallbackHandler;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudMessage;
import com.tridium.nc.devices.CloudProtocolFactory;
import com.tridium.nc.devices.sentience.events.config.DeviceConfig;
import com.tridium.nc.history.BCloudHistoryDeviceExt;
import com.tridium.nc.point.BCloudPointDeviceExt;
import com.tridium.nc.point.BCloudProxyExt;
import com.tridium.nc.point.BCloudTuningPolicy;
import com.tridium.nc.security.BCloudAuthenticationScheme;
import com.tridium.nc.security.BCloudCallbackHandler;
import com.tridium.nc.security.CloudSession;
import com.tridium.ndriver.BNDevice;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.security.auth.callback.CallbackHandler;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connector", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:Component\")")}), @NiagaraProperty(name="points", type="BCloudPointDeviceExt", defaultValue="new BCloudPointDeviceExt()"), @NiagaraProperty(name="alarms", type="BCloudAlarmExt", defaultValue="new BCloudAlarmExt()"), @NiagaraProperty(name="histories", type="BCloudHistoryDeviceExt", defaultValue="new BCloudHistoryDeviceExt()"), @NiagaraProperty(name="commands", type="BCloudCommandsDeviceExt", defaultValue="new BCloudCommandsDeviceExt()")})
@NiagaraAction(name="ping", flags=20, override=true)
public class BCloudDevice
extends BNDevice
implements ConnectCallback,
MessageCallback {
    public static final Property connector = BCloudDevice.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:Component")));
    public static final Property points = BCloudDevice.newProperty((int)0, (BValue)new BCloudPointDeviceExt(), null);
    public static final Property alarms = BCloudDevice.newProperty((int)0, (BValue)new BCloudAlarmExt(), null);
    public static final Property histories = BCloudDevice.newProperty((int)0, (BValue)new BCloudHistoryDeviceExt(), null);
    public static final Property commands = BCloudDevice.newProperty((int)0, (BValue)new BCloudCommandsDeviceExt(), null);
    public static final Action ping = BCloudDevice.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BCloudDevice.class);
    private static final Properties defaultConstLookup = new Properties();
    private static final Map<String, Integer> defaultNumConstLookup = Collections.emptyMap();
    protected static final Map<String, CloudMessageCallback> cloudMsgCallbackMapping = new HashMap<String, CloudMessageCallback>();
    protected static final Map<String, CloudMessageCallback> cloudMsgCallbacks = new HashMap<String, CloudMessageCallback>();
    protected BICloudConnector cloudConnector;
    protected static final Logger log = Logger.getLogger("ncloud");
    protected static final Logger almLog = Logger.getLogger("ncloud.alarm");
    protected static final Logger cmdLog = Logger.getLogger("ncloud.command");
    protected Lexicon lexicon = Lexicon.make((String)"nCloudDriver");
    private final Clock.Ticket alarmSendTicket = null;
    private boolean commandRegistrationMessagesSent;
    private boolean iothubCallbackFlag;
    private boolean callbacksRegisteredFlag;
    private static final ReentrantLock iothubCallbackFlagLock = new ReentrantLock();

    public BOrd getConnector() {
        return (BOrd)this.get(connector);
    }

    public void setConnector(BOrd v) {
        this.set(connector, (BValue)v, null);
    }

    public BCloudPointDeviceExt getPoints() {
        return (BCloudPointDeviceExt)this.get(points);
    }

    public void setPoints(BCloudPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public BCloudAlarmExt getAlarms() {
        return (BCloudAlarmExt)this.get(alarms);
    }

    public void setAlarms(BCloudAlarmExt v) {
        this.set(alarms, (BValue)v, null);
    }

    public BCloudHistoryDeviceExt getHistories() {
        return (BCloudHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BCloudHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    public BCloudCommandsDeviceExt getCommands() {
        return (BCloudCommandsDeviceExt)this.get(commands);
    }

    public void setCommands(BCloudCommandsDeviceExt v) {
        this.set(commands, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        cloudMsgCallbackMapping.put("CloudAlarmAckRequest", this.getAlarms());
        cloudMsgCallbackMapping.put("CloudPointReadRequest", this.getPoints().getReadCallback());
        cloudMsgCallbackMapping.put("CloudMultiPointReadRequest", this.getPoints().getMultiReadCallback());
        cloudMsgCallbackMapping.put("CloudPointWriteRequest", this.getPoints().getWriteCallback());
        cloudMsgCallbackMapping.put("CloudMultiPointWriteRequest", this.getPoints().getMultiWriteCallback());
        cloudMsgCallbackMapping.put("CloudLastHistoryResponse", this.getHistories().getLastHistoryCallback());
        cloudMsgCallbackMapping.put("CloudCommandsResponse", this.getCommands().getCommandCallback());
        this.resolveConnector();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        if (Sys.atSteadyState()) {
            this.registerCommands();
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.registerCommands();
    }

    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(connector)) {
            this.removeCallbacks();
            this.cloudConnector = null;
            this.commandRegistrationMessagesSent = false;
            if (!CloudUtilities.canSendMessage(this)) {
                this.configFail(this.lexicon.getText("niagaraCloudService.configFail"));
            }
        } else if (prop.equals(enabled) && this.getEnabled()) {
            this.getHistories().setBackfillStartTime();
        }
    }

    public void stopped() throws Exception {
        this.removeCallbacks();
        super.stopped();
    }

    public boolean isParentLegal(BComponent parent) {
        return false;
    }

    public Type getNetworkType() {
        return BNiagaraCloudNetwork.TYPE;
    }

    public void doPing() throws Exception {
        BNiagaraCloudNetwork net = this.getNiagaraCloudNetwork();
        this.resolveConnector();
        log.fine(() -> {
            Object[] objectArray = new Object[3];
            objectArray[0] = net != null ? (net.isDisabled() ? "disabled" : "enabled") : "null";
            objectArray[1] = this.isDisabled() ? "disabled" : "enabled";
            objectArray[2] = connector;
            return String.format("BCloudDevice.doPing(): net:%s, dev:%s, conn:%s", objectArray);
        });
        if (!this.isDisabled() && this.getNiagaraCloudNetwork() != null && !this.getNiagaraCloudNetwork().isDisabled()) {
            if (this.cloudConnector != null) {
                this.cloudConnector.ping();
            } else {
                log.severe(this.lexicon.getText("connector.notConnectedOrNull"));
                this.pingFail(this.lexicon.getText("connector.notConnectedOrNull"));
            }
        } else {
            log.severe(this.lexicon.getText("connector.notConnectedOrNull"));
            this.configFail(this.lexicon.getText("connector.notConnectedOrNull"));
        }
    }

    public void pingOk() {
        if (this.getStatus().isDown()) {
            super.pingOk();
        }
    }

    public void onConnect() {
        if (this.cloudConnector != null && this.cloudConnector.isConnected()) {
            this.configOk();
            this.ping();
            if (!this.commandRegistrationMessagesSent) {
                this.registerCommands();
            }
            this.sendSystemInfo();
            iothubCallbackFlagLock.lock();
            if (!this.iothubCallbackFlag) {
                this.iothubCallbackFlag = true;
                iothubCallbackFlagLock.unlock();
                this.handleAlarms();
            } else {
                iothubCallbackFlagLock.unlock();
            }
        } else {
            log.warning("Entered onConnect but connector is not connected or null");
            this.iothubCallbackFlag = false;
        }
        this.getHistories().setBackfillStartTime();
    }

    private void handleAlarms() {
        almLog.fine("Handling pending alarms....");
        BAbsTime currentTime = BAbsTime.now();
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        try {
            BCloudAlarmRecipient[] cloudAlarmRecipients = (BCloudAlarmRecipient[])alarmService.getChildren(BCloudAlarmRecipient.class);
            HashMap alarmClassMap = new HashMap();
            almLog.finest("Building alarm class list from cloud alarm recipients");
            for (BCloudAlarmRecipient cloudAlarmRecipient : cloudAlarmRecipients) {
                almLog.finest(() -> String.format("recipient:%s", cloudAlarmRecipient.getName()));
                ArrayList<String> alarmClassList = new ArrayList<String>();
                for (BLink link : cloudAlarmRecipient.getLinks()) {
                    if (!(link.getSourceComponent() instanceof BAlarmClass)) continue;
                    almLog.finest(() -> String.format("Adding alarm class '%s' to the list", link.getSourceComponent().getName()));
                    alarmClassList.add(link.getSourceComponent().getName());
                }
                alarmClassMap.put(cloudAlarmRecipient, alarmClassList);
            }
            for (Map.Entry entry : alarmClassMap.entrySet()) {
                almLog.finest(() -> String.format("Checking recipient %s", bCloudAlarmRecipientListEntry.getKey()));
                BAbsTime lastSent = ((BCloudAlarmRecipient)((Object)entry.getKey())).getLastSentToCloud();
                for (String alarmClassName : (List)entry.getValue()) {
                    almLog.finest(() -> String.format("Check alarm class %s", alarmClassName));
                    BqlQuery bqlQuery = BCloudDevice.buildQuery(alarmClassName, ((BCloudAlarmRecipient)((Object)entry.getKey())).getLastSentToCloud());
                    BOrd bqlOrd = BOrd.make((String)("alarm:|" + bqlQuery));
                    almLog.fine(() -> String.format("Checking for unsent alarm records for alarm class '%s' through recipient '%s', using bql ord %s", alarmClassName, bCloudAlarmRecipientListEntry.getKey(), bqlOrd));
                    BProjectionTable table = (BProjectionTable)bqlOrd.get();
                    int unsentCount = 0;
                    int sentCount = 0;
                    try (TableCursor unsents = table.cursor();){
                        while (unsents.next()) {
                            ++unsentCount;
                            BAlarmRecord record = (BAlarmRecord)((BAlarmRecord)unsents.get()).newCopy();
                            if (!((List)entry.getValue()).contains(record.getAlarmClass())) continue;
                            ++sentCount;
                            ((BCloudAlarmRecipient)((Object)entry.getKey())).handleAlarm(record);
                            almLog.finest(() -> String.format("Alarm %s (ts %s) sent to cloud alarm recipient for delivery", record.getUuid(), record.getTimestamp().encodeToString()));
                        }
                    }
                    if (!almLog.isLoggable(Level.FINE)) continue;
                    almLog.fine(String.format("Alarms with unsent updates found:%s; Alarms sent to cloud: %s", unsentCount, sentCount));
                }
                almLog.finest(() -> String.format("Finished checking alarm classes for %s", bCloudAlarmRecipientListEntry.getKey()));
            }
            almLog.finest("Finished checking for unsent alarms");
        }
        catch (Exception e) {
            almLog.log(Level.SEVERE, "Not able to send alarms on connect", e);
            this.iothubCallbackFlag = false;
        }
    }

    private static BqlQuery buildQuery(String alarmClassName, BAbsTime lastSentToCloud) {
        return BqlQuery.make((String)("select * where alarmClass.name = \"'" + alarmClassName + "'\" and lastUpdate > AbsTime '" + lastSentToCloud.encodeToString() + '\''));
    }

    public void onDisconnect() {
        this.iothubCallbackFlag = false;
    }

    public void onStopped() {
        this.removeCallbacks();
        this.commandRegistrationMessagesSent = false;
        this.cloudConnector = null;
    }

    private void sendSystemInfo() {
        CloudEncodeMsg systemInfoMsg = this.getFactory().createSystemInfoMsg();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        CompletionStage future = this.cloudConnector.sendMessage(systemInfoMsg.encode(properties), systemInfoMsg.getProperties(null)).whenComplete((resp, err) -> {
            if (err != null) {
                log.info("Failed to send System Info Message to cloud.");
            } else {
                log.fine("Sent System Info to cloud.");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String messageId, byte[] payload, Map<String, String> props) {
        CloudMessage msg = this.getFactory().decodeMessage(messageId, payload, props);
        if (msg != null) {
            cmdLog.finer(() -> String.format("CloudDevice onMessage at %d received message id %s", BAbsTime.now().getMillis(), messageId));
            CloudMessageCallback callback = cloudMsgCallbacks.get(msg.getCommand());
            if (callback != null) {
                CloudSession session = new CloudSession();
                try {
                    BAuthenticationScheme scheme;
                    BAuthenticationService service = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
                    BAuthenticationScheme[] schemes = (BAuthenticationScheme[])service.getAuthenticationSchemes().getChildren(BCloudAuthenticationScheme.class);
                    BAuthenticationScheme bAuthenticationScheme = scheme = schemes.length > 0 ? schemes[0] : null;
                    if (scheme == null) {
                        throw new AuthenticationException("Missing cloud authentication scheme");
                    }
                    BCloudCallbackHandler callbackHandler = (BCloudCallbackHandler)scheme.getAgentOn(BCloudCallbackHandler.class);
                    if (callbackHandler == null) {
                        throw new AuthenticationException("Missing authentication handler");
                    }
                    callbackHandler.init((CloudDecodeMsg)msg, this.resolveConnector().getId(), messageId);
                    SessionManager.addSession((NiagaraSession)session);
                    BUser user = service.authenticate((NiagaraSession)session, null, (CallbackHandler)((Object)callbackHandler), scheme);
                    if (this.getNiagaraCloudNetwork().isDisabled()) {
                        throw new PermissionException("Niagara Cloud Network is disabled.");
                    }
                    if (this.isDisabled()) {
                        throw new PermissionException("Cloud Device is disabled.");
                    }
                    MessageCallbackHandler handler = new MessageCallbackHandler(messageId, msg, callback, user);
                    this.getCommands().getCommandExecutor().enqueue(handler);
                }
                catch (PermissionException e) {
                    this.sendError(callback, msg, messageId, this.getNumericConstant("CMD_ERR_CODE_UNAVAILABLE"), this.getConstant("ERR_UNAVAILABLE"));
                    cmdLog.warning(() -> String.format("Error executing command: %s %s", new Object[]{e, messageId}));
                }
                catch (AuthenticationException e) {
                    this.sendError(callback, msg, messageId, this.getNumericConstant("CMD_ERR_CODE_UNAUTHORIZED"), this.getConstant("ERR_UNAUTHORIZED"));
                    cmdLog.warning(() -> String.format("Error authenticating cloud user: %s %s", e, messageId));
                }
                finally {
                    session.invalidate();
                }
            }
            cmdLog.finer("CloudDevice onMessage exiting, message id " + messageId);
        }
    }

    private void sendError(CloudMessageCallback callback, CloudMessage msg, String messageId, int errCode, String errMsg) {
        Map<String, Object> response = callback.getResponseParams(messageId, (CloudDecodeMsg)msg, errCode, errMsg);
        HashMap<String, Object> responseProps = new HashMap<String, Object>();
        responseProps.put(this.getConstant("CORRELATIONID"), messageId);
        CloudEncodeMsg errResponse = callback.getResponse();
        this.cloudConnector.sendMessage(errResponse.encode(response), errResponse.getProperties(responseProps)).whenComplete((resp, err) -> {
            if (err != null) {
                cmdLog.warning("failed to send cloud command error message with message ID " + messageId);
            } else {
                cmdLog.fine("Cloud command error message sent successfully, message ID " + messageId);
            }
        });
    }

    public void tuningChanged(BCloudTuningPolicy policy, Context cx) {
        BControlPoint[] points;
        for (BControlPoint point : points = this.getPoints().getPoints()) {
            ((BCloudProxyExt)point.getProxyExt()).tuningChanged(policy, cx);
        }
    }

    private void registerCommands() {
        if (CloudUtilities.canSendMessage(this)) {
            this.getAlarms().registerForCommands();
            this.getPoints().registerForCommands();
            this.getCommands().registerForCommands();
            this.commandRegistrationMessagesSent = true;
        }
    }

    private void addCallbacks() {
        if (this.cloudConnector != null && this.isRunning()) {
            if (!this.callbacksRegisteredFlag) {
                this.callbacksRegisteredFlag = true;
                this.cloudConnector.addConnectCallback((ConnectCallback)this);
                this.cloudConnector.addMessageCallback((MessageCallback)this);
            } else {
                log.config("addCallbacks called when callback added flag is already set.");
            }
        } else {
            log.warning("Not able to add connectCallback and messageCallback because connector was null or isRunning was false");
        }
    }

    private void removeCallbacks() {
        BICloudConnector connector = this.resolveConnector();
        this.callbacksRegisteredFlag = false;
        if (connector != null) {
            connector.removeConnectCallback((ConnectCallback)this);
            connector.removeMessageCallback((MessageCallback)this);
        } else {
            log.warning("Not able to remove connectCallback and messageCallback because connector was null");
        }
    }

    protected void resetFactory() {
        Map<String, String> msgMapping = this.getFactory().getCloudMessageMapping();
        for (Map.Entry<String, String> entry : msgMapping.entrySet()) {
            CloudMessageCallback callback = cloudMsgCallbackMapping.get(entry.getKey());
            cloudMsgCallbacks.put(entry.getValue(), callback);
        }
    }

    public CloudProtocolFactory getFactory() {
        return null;
    }

    public BICloudConnector resolveConnector() {
        try {
            if (this.cloudConnector == null) {
                BOrd ord = this.getConnector();
                if (this.isRunning() && !ord.isNull()) {
                    this.cloudConnector = (BICloudConnector)ord.get((BObject)this);
                    if (!this.callbacksRegisteredFlag) {
                        this.addCallbacks();
                    }
                    if (CloudUtilities.canSendMessage(this)) {
                        if (!this.commandRegistrationMessagesSent) {
                            this.registerCommands();
                        }
                        this.sendSystemInfo();
                        this.configOk();
                        this.ping();
                    }
                }
            }
        }
        catch (UnresolvedException e) {
            log.severe(String.format(this.lexicon.getText("cloudDevice.cannotResolve"), this.getName()));
            this.configFail(String.format(this.lexicon.getText("cloudDevice.cannotResolve"), this.getName()));
        }
        catch (ClassCastException cce) {
            log.severe(String.format(this.lexicon.getText("cloudDevice.invalidComponent"), this.getName()));
            this.configFail(String.format(this.lexicon.getText("cloudDevice.invalidComponent"), this.getName()));
        }
        return this.cloudConnector;
    }

    private static JSONObject buildBodyData(String id) {
        DeviceConfig deviceConfig = new DeviceConfig(id, Sys.getHostName(), Sys.getBajaModule().getModuleName(), Sys.getBajaVersion().toString(), Sys.getStation().getStationName());
        return deviceConfig.toJSONObject();
    }

    public final BNiagaraCloudNetwork getNiagaraCloudNetwork() {
        return (BNiagaraCloudNetwork)this.getNetwork();
    }

    public String getConstant(String name) {
        return defaultConstLookup.getProperty(name);
    }

    public int getNumericConstant(String name) {
        return defaultNumConstLookup.get(name);
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Cloud Device");
        out.prop((Object)"callbacksRegistered", this.callbacksRegisteredFlag);
        out.prop((Object)"commandsRegistered", this.commandRegistrationMessagesSent);
        out.endProps();
        super.spy(out);
    }
}

