/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.chart.ChartUtil;
import java.util.ArrayList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.TrendFlags;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.BPolygonGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAreaChart
extends BChart {
    @Generated
    public static final Type TYPE = Sys.loadType(BAreaChart.class);
    static BPen defaultPen = BPen.make((double)1.0);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAreaChart() {
    }

    public BAreaChart(ChartModel model) {
        super(model);
    }

    @Override
    public void doPaint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        int xcol = 0;
        int ycol = 1;
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        for (int i = 0; i < specCount; ++i) {
            ChartSpec spec = model.getSpec(i);
            BAxis xaxis = spec.getXAxis();
            BAxis yaxis = spec.getYAxis();
            Series series = spec.getSeries();
            int rowCount = series.getRowCount();
            ArrayList<Double> x = new ArrayList<Double>();
            ArrayList<Double> y = new ArrayList<Double>();
            double lastX = 0.0;
            double lastY = 0.0;
            boolean lastHidden = false;
            double firstX = xaxis.toDisplaySpace(series.getValue(0, xcol));
            x.add(firstX);
            y.add(h);
            for (int row = 0; row < rowCount; ++row) {
                int trendFlags = series.getTrendFlags(row);
                if (TrendFlags.isHidden((int)trendFlags)) {
                    lastHidden = true;
                    continue;
                }
                if (lastHidden || TrendFlags.isStart((int)trendFlags)) {
                    x.add(lastX);
                    y.add(h);
                }
                lastX = xaxis.toDisplaySpace(series.getValue(row, xcol));
                lastY = yaxis.toDisplaySpace(series.getValue(row, ycol));
                if (lastHidden || TrendFlags.isStart((int)trendFlags)) {
                    x.add(lastX);
                    y.add(h);
                }
                x.add(lastX);
                y.add(lastY);
                lastHidden = false;
            }
            double finalX = xaxis.toDisplaySpace(series.getValue(series.getRowCount() - 1, xcol));
            x.add(finalX);
            y.add(h);
            double[] px = new double[x.size()];
            double[] py = new double[y.size()];
            for (int j = 0; j < px.length; ++j) {
                px[j] = (Double)x.get(j);
                py[j] = (Double)y.get(j);
            }
            BPolygonGeom poly = BPolygonGeom.make((double[])px, (double[])py);
            g.setBrush(ChartUtil.makeGradient(series.getBrush()));
            g.fill((IGeom)poly);
            BPen pen = series.getPen();
            if (pen == null) {
                pen = defaultPen;
            }
            g.setPen(pen);
            g.setBrush(BColor.black.toBrush());
            g.stroke((IGeom)poly);
        }
    }
}

