/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import com.tridium.chart.BAbstractPanControl;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChartPane;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BFrame;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;

@NiagaraType
public class BPanControl
extends BAbstractPanControl {
    @Generated
    public static final Type TYPE = Sys.loadType(BPanControl.class);
    private BButton upButton;
    private BButton downButton;
    private BButton leftButton;
    private BButton rightButton;
    private BButton zoomOutButton;
    private BButton noZoomButton;
    static BBrush bg = BBrush.make((String)"#bfffffff");
    static BBrush fg = BBrush.make((String)"#666");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPanControl() {
    }

    public BPanControl(BChartPane chart) {
        this.chart = chart;
        this.upButton = new BButton(BImage.make((BOrd)BOrd.make((String)"module://icons/x16/arrowUp.png")));
        this.add("upButton", (BValue)this.upButton);
        this.add("upLink", (BValue)new BLink((BComponent)this.upButton, (Slot)BButton.actionPerformed, (Slot)panUp));
        this.downButton = new BButton(BImage.make((BOrd)BOrd.make((String)"module://icons/x16/arrowDown.png")));
        this.add("downButton", (BValue)this.downButton);
        this.linkTo((BComponent)this.downButton, (Slot)BButton.actionPerformed, (Slot)panDown);
        this.leftButton = new BButton(BImage.make((BOrd)BOrd.make((String)"module://icons/x16/arrowLeft.png")));
        this.add("leftButton", (BValue)this.leftButton);
        this.linkTo((BComponent)this.leftButton, (Slot)BButton.actionPerformed, (Slot)panLeft);
        this.rightButton = new BButton(BImage.make((BOrd)BOrd.make((String)"module://icons/x16/arrowRight.png")));
        this.add("rightButton", (BValue)this.rightButton);
        this.linkTo((BComponent)this.rightButton, (Slot)BButton.actionPerformed, (Slot)panRight);
        this.zoomOutButton = new BButton(BImage.make((BOrd)BOrd.make((String)"module://icons/x16/zoomOut.png")));
        this.add("zoomOutButton", (BValue)this.zoomOutButton);
        this.linkTo((BComponent)this.zoomOutButton, (Slot)BButton.actionPerformed, (Slot)zoomOut);
        this.noZoomButton = new BButton(BImage.make((BOrd)BOrd.make((String)"module://icons/x16/noZoom.png")));
        this.add("noZoomButton", (BValue)this.noZoomButton);
        this.linkTo((BComponent)this.noZoomButton, (Slot)BButton.actionPerformed, (Slot)noZoom);
        this.updateActionStates();
    }

    public void updateActionStates() {
        if (this.chart == null) {
            return;
        }
        this.zoomOutButton.setEnabled(this.chart.isZoomed(BAxisDimension.x) || this.chart.isZoomed(BAxisDimension.y));
        this.noZoomButton.setEnabled(this.zoomOutButton.getEnabled());
        this.upButton.setEnabled(this.chart.isZoomed(BAxisDimension.y));
        this.downButton.setEnabled(this.chart.isZoomed(BAxisDimension.y));
        this.leftButton.setEnabled(this.chart.isZoomed(BAxisDimension.x));
        this.rightButton.setEnabled(this.chart.isZoomed(BAxisDimension.x));
    }

    public void computePreferredSize() {
        this.setPreferredSize(100.0, 70.0);
    }

    public void doLayout(BWidget[] kids) {
        if (this.chart == null) {
            return;
        }
        double bx = 5.0;
        double by = 5.0;
        double bw = 20.0;
        double bh = 20.0;
        this.zoomOutButton.setBounds(bx, by, bw, bh);
        this.noZoomButton.setBounds(bx, by + 40.0, bw, bh);
        this.upButton.setBounds(bx + 50.0, by, bw, bh);
        this.downButton.setBounds(bx + 50.0, by + 40.0, bw, bh);
        this.leftButton.setBounds(bx + 30.0, by + 20.0, bw, bh);
        this.rightButton.setBounds(bx + 70.0, by + 20.0, bw, bh);
    }

    public void paint(Graphics g) {
        if (this.chart == null) {
            return;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(bg);
        g.fillRect(0.0, 0.0, w, h);
        g.setBrush(fg);
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        this.paintChildren(g);
    }

    public static void main(String[] args) {
        BPanControl pan = new BPanControl(null);
        BFrame f = new BFrame();
        BGridPane grid = new BGridPane();
        grid.add(null, (BValue)pan);
        f.setContent((BWidget)grid);
        f.setScreenBounds(200.0, 10.0, 200.0, 200.0);
        f.open();
    }
}

