/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.messages;

import com.tridium.andoverAC256.messages.AndoverReceivedMessage;

public class AndoverGetSystemTablePointsResponse
extends AndoverReceivedMessage {
    public int numberPointsReturned;
    public PointList[] pointList;

    public AndoverGetSystemTablePointsResponse(String message) {
        super(message);
        this.decodeMessage();
    }

    public int getNumberPointsReturned() {
        return this.numberPointsReturned;
    }

    public void decodeMessage() {
        this.numberPointsReturned = 0;
        int equalsPosition = this.message.indexOf("=");
        while (equalsPosition != -1) {
            ++this.numberPointsReturned;
            equalsPosition = this.message.indexOf("=", equalsPosition + 1);
        }
        if (this.numberPointsReturned == 0) {
            return;
        }
        this.pointList = new PointList[this.numberPointsReturned];
        equalsPosition = this.message.indexOf("=");
        for (int i = 0; i < this.numberPointsReturned; ++i) {
            int startofPoint = equalsPosition - 9;
            int endofPoint = equalsPosition + 8;
            String pointString = this.message.substring(startofPoint, endofPoint);
            String readValue = pointString.substring(10, 17).trim();
            this.pointList[i] = new PointList(pointString.substring(0, 9).trim(), readValue);
            equalsPosition = this.message.indexOf("=", endofPoint);
        }
    }

    public String toString() {
        return "AndoverGetSystemTablePointsResponse: " + this.message;
    }

    public String getName(int index) {
        if (this.pointList == null || index >= this.pointList.length) {
            return "";
        }
        return this.pointList[index].getName();
    }

    public String getValue(int index) {
        if (this.pointList == null || index >= this.pointList.length) {
            return "";
        }
        return this.pointList[index].getValue();
    }

    public class PointList {
        String name;
        String value;

        PointList(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }
    }
}

