/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverNetwork;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="setCommand", parameterType="BString", defaultValue="BString.make(\"\")")
@NiagaraTopic(name="responseFragment")
public class BAndoverConsoleJob
extends BJob
implements AndoverMessageConst,
Runnable {
    @Generated
    public static final Action setCommand = BAndoverConsoleJob.newAction((int)0, (BValue)BString.make((String)""), null);
    @Generated
    public static final Topic responseFragment = BAndoverConsoleJob.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAndoverConsoleJob.class);
    boolean canceled = false;
    private BAndoverNetwork network;
    private String commandLine = "";
    private Thread thread;
    private boolean portException = false;

    @Generated
    public void setCommand(BString parameter) {
        this.invoke(setCommand, (BValue)parameter, null);
    }

    @Generated
    public void fireResponseFragment(BValue event) {
        this.fire(responseFragment, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAndoverConsoleJob() {
    }

    public BAndoverConsoleJob(BAndoverNetwork net) {
        this.network = net;
    }

    public void doRun(Context cx) {
        this.network.dispatch(this);
    }

    public void doCancel(Context cx) {
        this.canceled = true;
        this.thread.interrupt();
    }

    @Override
    public void run() {
        this.network.getUnsolicitedReceiveHandler().setJob(this);
        this.network.setDriverState(7);
        try {
            this.thread = Thread.currentThread();
            if (this.network == null) {
                throw new IllegalStateException("Must submit thru AndoverNetwork.submitConsoleJob()");
            }
            this.log().message("Starting cosole");
            while (this.getJobState() == BJobState.running) {
                try {
                    Thread.sleep(1000L);
                    if (this.canceled) break;
                    this.heartbeat();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            this.cleanup();
        }
        catch (Exception e) {
            this.log().message(e.toString());
            this.failed(e);
        }
    }

    private void cleanup() {
        if (this.portException) {
            this.failed(new Throwable("failure writing to com port"));
        } else {
            this.success();
        }
        this.network.setDriverState(1);
        this.network.getUnsolicitedReceiveHandler().setJob(null);
    }

    public void doSetCommand(BString cmd) {
        try {
            this.network.getComm().getCommTransmitter().writeBytes(cmd.getString().getBytes());
        }
        catch (Exception e) {
            this.thread.interrupt();
            this.canceled = true;
            this.portException = true;
        }
        if (cmd.getString().endsWith("\n")) {
            this.log().message("command sent::" + this.commandLine);
            this.commandLine = "";
        } else {
            this.commandLine = this.commandLine + cmd.getString();
        }
    }
}

