/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.util;

import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.util.UndoableRecord;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.util.BWsAnnotation;

public class PasteRecord
extends UndoableRecord {
    private TransferResult[] results;
    private Set<String> affectedSpaceOrds;
    private static final String INSERT_NAMES_PROP = "insertNames";

    private PasteRecord(BoxOp op) {
        super(op);
    }

    public static PasteRecord copy(Mark mark, BObject targetObject, BComponent params, int numCopies, BoxWriter out, BoxOp op) throws Exception {
        PasteRecord record = new PasteRecord(op);
        record.doTransfer(PasteType.COPY, mark, targetObject, params, numCopies, out, op);
        return record;
    }

    public static PasteRecord move(Mark mark, BObject targetObject, BComponent params, BoxWriter out, BoxOp op) throws Exception {
        PasteRecord record = new PasteRecord(op);
        record.doTransfer(PasteType.MOVE, mark, targetObject, params, 1, out, op);
        return record;
    }

    @Override
    public void undoTransfer(BoxWriter out) throws Exception {
        if (this.results == null) {
            throw new IllegalStateException("Nothing to undo");
        }
        for (TransferResult result : this.results) {
            result.undo();
        }
    }

    @Override
    public Set<String> getAffectedSpaceOrds() {
        return Collections.unmodifiableSet(this.affectedSpaceOrds);
    }

    private void doTransfer(PasteType pasteType, Mark mark, BObject targetObject, BComponent params, int numCopies, BoxWriter out, BoxOp op) throws Exception {
        if (this.results != null) {
            throw new IllegalStateException("Already transferred");
        }
        this.results = new TransferResult[numCopies];
        this.affectedSpaceOrds = PasteRecord.getComponentSpaceOrds(pasteType, mark, targetObject);
        Context cx = PasteRecord.getTransferContext(op);
        out.key(INSERT_NAMES_PROP).array();
        for (int i = 0; i < numCopies; ++i) {
            TransferResult result;
            switch (pasteType) {
                case MOVE: {
                    result = TransferStrategy.make((int)32, (Mark)mark, (BObject)targetObject, (BComponent)params, (Context)cx).transfer();
                    break;
                }
                case COPY: {
                    result = mark.copyTo(targetObject, params, cx);
                    break;
                }
                default: {
                    throw new Exception("Unknown paste type");
                }
            }
            this.results[i] = result;
            PasteRecord.staggerOrigin(params);
            for (String insertName : result.getInsertNames()) {
                out.value(insertName);
            }
        }
        out.endArray();
    }

    private static Set<String> getComponentSpaceOrds(PasteType pasteType, Mark mark, BObject target) {
        HashSet<String> spaceOrds = new HashSet<String>();
        if (pasteType == PasteType.MOVE) {
            spaceOrds.addAll(PasteRecord.getComponentSpaceOrds(mark));
        }
        if (target instanceof BComponent) {
            spaceOrds.add(((BComponent)target).getComponentSpace().getAbsoluteOrd().toString());
        }
        return spaceOrds;
    }

    private static void staggerOrigin(BComponent params) {
        BWsAnnotation origin = (BWsAnnotation)params.get("origin");
        if (origin != null) {
            origin = origin.translate(1, 1);
            params.set("origin", (BValue)origin);
        }
    }

    private static enum PasteType {
        COPY,
        MOVE;

    }
}

