/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.typenode;

import com.tridium.box.BoxTypeExtAgentFilter;
import com.tridium.box.typenode.TypeNodeVisitor;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.box.BBoxClientEnv;
import javax.baja.box.BIBoxTypeExt;
import javax.baja.box.BIInternalBoxTypeExt;
import javax.baja.naming.BOrdScheme;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BIOffline;
import javax.baja.web.js.BIJavaScript;

public final class TypeNode {
    private int hashCode = -1;
    private TypeInfo typeInfo;
    private Optional<?> cache = Optional.empty();
    private String cacheKey = "";
    private Set<TypeNode> dependencies;
    private TypeInfo[] interfaces;
    private BBoxClientEnv clientEnv;
    private Optional<BIBoxTypeExt> typeExt = Optional.empty();
    private BIcon icon;
    private int set = -1;
    private static final int IS_COMPLEX = 1;
    private static final int IS_FROZEN_ENUM = 2;
    private static final int IS_VALUE = 4;
    private static final int IS_SIMPLE = 8;
    private static final int IS_SINGLETON = 16;
    private static final int IS_NUMBER = 32;
    private static final int IS_COMPONENT = 64;
    private static final int IS_LINK = 128;
    private static final int IS_ACTION = 256;
    private static final int IS_TOPIC = 512;
    private static final int IS_JAVASCRIPT = 1024;
    private static final int IS_INTERNAL_BOX_TYPE_EXT = 2048;
    private static final int IS_ORD_SCHEME = 4096;
    private static final int SUPER_TYPE_VALID_NOT_EQUAL_TO_OBJ = 8192;
    private static final AgentFilter notInternalFilter = AgentFilter.not((AgentFilter)AgentFilter.is((Type)BIInternalBoxTypeExt.TYPE));

    TypeNode(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public void visit(TypeNodeVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            this.visitDependencies(visitor);
        }
    }

    public void visitDependencies(TypeNodeVisitor visitor) throws Exception {
        if (this.dependencies != null) {
            for (TypeNode node : this.dependencies) {
                node.visit(visitor);
            }
        }
    }

    void addDependency(TypeNode node) {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<TypeNode>();
        }
        if (!this.dependencies.contains(node)) {
            this.dependencies.add(node);
        }
    }

    public String toString() {
        return this.typeInfo.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeNode)) {
            return false;
        }
        TypeNode node = (TypeNode)obj;
        return node.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.typeInfo.toString().hashCode();
        }
        return this.hashCode;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public Optional<?> getCache() {
        return this.cache;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    void setCache(String cacheKey, Object cache) {
        this.cacheKey = cacheKey;
        this.cache = Optional.of(cache);
    }

    private boolean isSet(int flag) {
        if (this.set == -1) {
            this.set = 0;
            if (this.addBit(this.typeInfo.is(BValue.TYPE), 4)) {
                if (this.addBit(this.typeInfo.is(BComplex.TYPE), 1)) {
                    if (!this.addBit(this.typeInfo.is(BComponent.TYPE), 64)) {
                        this.addBit(this.typeInfo.is(BLink.TYPE), 128);
                        this.addBit(this.typeInfo.is(BAction.TYPE), 256);
                        this.addBit(this.typeInfo.is(BTopic.TYPE), 512);
                    }
                } else if (this.addBit(this.typeInfo.is(BSimple.TYPE), 8) && !this.addBit(this.typeInfo.is(BFrozenEnum.TYPE), 2)) {
                    this.addBit(this.typeInfo.is(BNumber.TYPE), 32);
                }
            } else if (this.addBit(this.typeInfo.is(BSingleton.TYPE), 16)) {
                this.addBit(this.typeInfo.is(BOrdScheme.TYPE), 4096);
            }
            this.addBit(this.typeInfo.is(BIJavaScript.TYPE), 1024);
            this.addBit(this.typeInfo.is(BIInternalBoxTypeExt.TYPE), 2048);
            TypeInfo superType = this.typeInfo.getSuperType();
            this.addBit(superType != null && !superType.equals(BObject.TYPE), 8192);
        }
        return (this.set & flag) != 0;
    }

    private boolean addBit(boolean state, int mask) {
        if (state) {
            this.set = mask | this.set;
        }
        return state;
    }

    public boolean isComplex() {
        return this.isSet(1);
    }

    public boolean isFrozenEnum() {
        return this.isSet(2);
    }

    public boolean isValue() {
        return this.isSet(4);
    }

    public boolean isSimple() {
        return this.isSet(8);
    }

    public boolean isSingleton() {
        return this.isSet(16);
    }

    public boolean isNumber() {
        return this.isSet(32);
    }

    public boolean isComponent() {
        return this.isSet(64);
    }

    public boolean isLink() {
        return this.isSet(128);
    }

    public boolean isAction() {
        return this.isSet(256);
    }

    public boolean isTopic() {
        return this.isSet(512);
    }

    public boolean isJavaScript() {
        return this.isSet(1024);
    }

    public boolean isInternalBoxTypeExt() {
        return this.isSet(2048);
    }

    public boolean isOrdScheme() {
        return this.isSet(4096);
    }

    public boolean superTypeValidAndNotEqualToObject() {
        return this.isSet(8192);
    }

    public boolean isInterface() {
        return this.typeInfo.isInterface();
    }

    public boolean isAbstract() {
        return this.typeInfo.isAbstract();
    }

    public boolean isTransient() {
        return this.typeInfo.isTransient();
    }

    public AgentInfo getAgentInfo() {
        return this.typeInfo.getAgentInfo();
    }

    public Type getResolvedType() {
        return this.typeInfo.getTypeSpec().getResolvedType();
    }

    public TypeInfo getSuperType() {
        return this.typeInfo.getSuperType();
    }

    public <R extends BObject> R getInstance() {
        return (R)this.typeInfo.getInstance();
    }

    public TypeInfo[] getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.typeInfo.getInterfaces();
        }
        return this.interfaces;
    }

    public Optional<BIBoxTypeExt> getBoxTypeExt(BBoxClientEnv clientEnv) {
        if (clientEnv != this.clientEnv) {
            this.clientEnv = clientEnv;
            BIBoxTypeExt instance = null;
            if (this.isInternalBoxTypeExt()) {
                if (!this.isAbstract() && !this.isInterface() && BoxTypeExtAgentFilter.make(clientEnv).include(this.getAgentInfo())) {
                    instance = (BIBoxTypeExt)this.typeInfo.getInstance();
                }
            } else {
                BoxTypeExtAgentFilter filter = BoxTypeExtAgentFilter.make(clientEnv);
                AgentList list = Sys.getRegistry().getSpecificAgents(this.typeInfo).filter(AgentFilter.and((AgentFilter)filter, (AgentFilter)notInternalFilter));
                if (list.size() > 0) {
                    instance = (BIBoxTypeExt)list.getDefault().getInstance();
                }
            }
            if (TypeNode.isOffline(clientEnv) && !(instance instanceof BIOffline)) {
                instance = null;
            }
            this.typeExt = Optional.ofNullable(instance);
        }
        return this.typeExt;
    }

    public BIcon getIcon() {
        if (this.icon == null) {
            if (!this.isInterface() && !this.isAbstract()) {
                try {
                    this.icon = this.typeInfo.getInstance().getIcon();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.icon == null) {
                this.icon = this.typeInfo.getIcon(null);
            }
        }
        return this.icon;
    }

    private static boolean isOffline(BBoxClientEnv clientEnv) {
        return clientEnv.getEnvironmentType() == BBoxClientEnv.EnvironmentType.WORKBENCH;
    }
}

