/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxService;
import java.util.HashSet;
import java.util.logging.Level;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public final class BoxWsHttpSessionListener
implements HttpSessionListener {
    private static final IHttpSessionDestroyListener[] EMPTY_LISTENER_ARRAY = new IHttpSessionDestroyListener[0];
    private static final HashSet<IHttpSessionDestroyListener> listeners = new HashSet();

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        for (IHttpSessionDestroyListener l : BoxWsHttpSessionListener.getListeners()) {
            try {
                l.onHttpSessionDestroyed(httpSession);
            }
            catch (Exception e) {
                BBoxService.log.log(Level.SEVERE, "Problem with onHttpSessionDestroyed", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addDestroyListener(IHttpSessionDestroyListener l) {
        HashSet<IHttpSessionDestroyListener> hashSet = listeners;
        synchronized (hashSet) {
            listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDestroyListener(IHttpSessionDestroyListener l) {
        HashSet<IHttpSessionDestroyListener> hashSet = listeners;
        synchronized (hashSet) {
            listeners.remove(l);
        }
    }

    static void boxSessionExpired(HttpSession httpSession) {
        for (IHttpSessionDestroyListener l : BoxWsHttpSessionListener.getListeners()) {
            try {
                l.onBoxSessionExpired(httpSession);
            }
            catch (Exception e) {
                BBoxService.log.log(Level.SEVERE, "Problem with onBoxSessionExpired", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IHttpSessionDestroyListener[] getListeners() {
        HashSet<IHttpSessionDestroyListener> hashSet = listeners;
        synchronized (hashSet) {
            return listeners.toArray(EMPTY_LISTENER_ARRAY);
        }
    }

    static interface IHttpSessionDestroyListener {
        public void onHttpSessionDestroyed(HttpSession var1);

        default public void onBoxSessionExpired(HttpSession httpSession) {
        }
    }
}

