/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.BoxOp;
import com.tridium.box.BoxWebSocketServlet;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.box.mux.BoxEnvelope;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.json.JSONWriter;
import com.tridium.nav.BINavSupport;
import com.tridium.util.NiagaraRpcUtil;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.nav.NavFileDecoder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.web.WebDev;

@NiagaraType
public final class BSysChannel
extends BBoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BSysChannel.class);
    private static final Logger log = Logger.getLogger("box.sys");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getChannelName() {
        return "sys";
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        boolean handled = true;
        switch (key) {
            case "props": {
                this.props(out, op);
                break;
            }
            case "lex": {
                this.lex(body.toString(), out, op);
                break;
            }
            case "navFile": {
                this.generateJsonNavFile(out, op);
                break;
            }
            case "error": {
                this.clientError(body.toString(), (Context)op);
                out.value(null);
                break;
            }
            case "rpc": {
                this.rpc((JSONObject)body, out, op);
                break;
            }
            case "hello": {
                out.value("world");
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    private void props(BoxWriter out, BoxOp op) {
        out.object();
        boolean requireHttps = true;
        Object requireHttpsValue = op.get("requireHttps");
        if (requireHttpsValue != null) {
            requireHttps = (Boolean)requireHttpsValue;
        } else {
            try {
                requireHttps = op.getWebService().getRequireHttpsForPasswords();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not find WebService associated with BOX request", e);
            }
        }
        out.key("userName").value((Object)op.getUsername());
        out.key("lang").value((Object)Context.getLanguageTag((Context)op));
        out.key("regLastBuildTime").value((Object)Sys.getRegistry().getLastBuildTime().encodeToString());
        out.key("enableWebStorage").value(this.getBoxService().getEnableWebStorage());
        out.key("userHome").value((Object)op.getHomePage());
        out.key("timeFormat").value((Object)BSysChannel.getTimeFormat((Context)op));
        out.key("unitConversion").value((long)BSysChannel.getUnitConversion((Context)op));
        out.key("logClientErrors").value(this.getBoxService().getLogClientErrors());
        out.key("wdLastModified").value((Object)WebDev.getLastModified().encodeToString());
        out.key("webdev").value(WebDev.get((String)"bajaScript").isEnabled());
        out.key("requireHttps").value(requireHttps);
        out.key("mux").object().key("enabled").value(BoxEnvelope.MUX_ENABLED && !BoxOp.isWorkbench(op)).key("minDelay").value((long)BoxEnvelope.MIN_DELAY).key("maxDelay").value((long)BoxEnvelope.MAX_DELAY).key("maxMessageSize").value((long)BoxWebSocketServlet.MAX_BINARY_MESSAGE_SIZE).key("maxEnvelopeSize").value((long)BoxEnvelope.MAX_ENVELOPE_SIZE).endObject();
        out.key("profile").value((Object)op.getProfileTypeSpec());
        out.endObject();
    }

    @Deprecated
    private void lex(String moduleName, BoxWriter out, BoxOp op) throws Exception {
        Lexicon lex = Lexicon.make((String)moduleName, (Context)op);
        Properties moduleProps = lex.getModuleProperties();
        Properties langProps = lex.getLanguageProperties();
        if ((moduleProps == null || moduleProps.isEmpty()) && (langProps == null || langProps.isEmpty())) {
            throw new Exception("No Lexicon entries detected for module: " + moduleName);
        }
        Properties allProps = new Properties();
        if (moduleProps != null) {
            allProps.putAll((Map<?, ?>)moduleProps);
        }
        if (langProps != null) {
            allProps.putAll((Map<?, ?>)langProps);
        }
        out.object();
        for (Map.Entry<Object, Object> entry : allProps.entrySet()) {
            out.key((String)entry.getKey()).value(entry.getValue());
        }
        out.endObject();
    }

    private void clientError(String err, Context cx) {
        BBoxService service = this.getBoxService();
        if (service.getLogClientErrors()) {
            BBoxService.log.log(Level.SEVERE, BBoxService.makeLogMsg("Client", cx), new BoxClientException(err));
            if (service.hasListeners()) {
                service.notifyListeners(cx, BBoxRecordType.error, err);
            }
        }
    }

    private void generateJsonNavFile(BoxWriter out, BoxOp op) throws Exception {
        BOrd navFileOrd;
        BUser user = op.getUser();
        BOrd bOrd = navFileOrd = user != null ? user.getNavFile() : BOrd.NULL;
        if (navFileOrd.isNull()) {
            out.value(null);
            return;
        }
        BIFile file = (BIFile)navFileOrd.get((BObject)this);
        BNavFileSpace space = new NavFileDecoder(file).decodeDocument();
        BNavFileNode root = space.getRootNode();
        BINavSupport.encodeToJson((BINavNode)root, (JSONWriter)out, (BiFunction)BINavSupport.ENCODE_ALL_NAV_CHILDREN, (Context)op);
    }

    private static String getTimeFormat(Context cx) {
        String pattern = null;
        BObject timeFormat = cx.getFacet("timeFormat");
        if (timeFormat != null) {
            pattern = timeFormat.toString();
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = Lexicon.make((BModule)Sys.getBajaModule(), (Context)cx).get("timeFormat");
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "DD-MMM-YY h:mm:ss a z";
        }
        return pattern;
    }

    private static int getUnitConversion(Context cx) {
        return cx.getFacets().geti("unitConversion", 0);
    }

    private void rpc(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        Optional retVal;
        String result;
        BOrd ord = BOrd.make((String)JSONUtil.getString((JSONObject)body, (String)"o"));
        String methodName = JSONUtil.getString((JSONObject)body, (String)"m");
        JSONArray arguments = body.getJSONArray("a");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Invoking RPC: " + ord + " - " + methodName);
        }
        if ((result = (retVal = NiagaraRpcUtil.rpc((TransportType)TransportType.box, (boolean)op.isSecure(), (String)op.getRemoteAddr(), (BOrd)ord, (String)methodName, (JSONArray)arguments, (Context)new BasicContext(op.getUser(), op.getLanguage()))).orElse(null)) instanceof BComplex) {
            result = BsonEncoderPlugin.marshal((BValue)((BComplex)result));
        }
        out.value(result);
    }

    private static final class BoxClientException
    extends Exception {
        private final String err;

        private BoxClientException(String err) {
            this.err = err;
        }

        @Override
        public void printStackTrace(PrintWriter writer) {
            writer.print(this.err);
        }
    }
}

