/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.timeshift;

import com.tridium.seriestransform.IntervalSeriesCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Row;
import javax.baja.seriestransform.SeriesTransformRow;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;

public class TimeShiftCursor
extends IntervalSeriesCursor<BComplex> {
    private BComplex current;
    private final Cursor<BComplex> inner;
    private final BRelTime shift;
    private final String keyField;

    public TimeShiftCursor(BSeriesSchema schema, BRelTime shift, BITable<BComplex> table) {
        super(table);
        this.keyField = schema.getKeyField();
        this.shift = shift;
        this.inner = table.cursor();
    }

    public Row<BComplex> row() {
        return new SeriesTransformRow<BComplex>(this.getTable(), this.current);
    }

    public boolean advanceCursor() {
        if (this.inner.next()) {
            this.current = (BComplex)this.inner.get();
            BValue value = this.current.get(this.keyField);
            if (value instanceof BAbsTime) {
                BAbsTime shiftedTime = ((BAbsTime)value).add(this.shift);
                this.current.set(this.keyField, (BValue)shiftedTime);
            }
            return true;
        }
        return false;
    }

    protected void closeCursor() {
        this.inner.close();
    }
}

