/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.composite;

import com.tridium.seriestransform.composite.BCompositeMap;
import com.tridium.seriestransform.composite.BCompositeMapping;
import com.tridium.seriestransform.composite.BCompositeTable;
import com.tridium.seriestransform.composite.CompositeMapping;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.baja.agent.BIAgent;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BStatusSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="transformInputs", type="BStatusSchema", defaultValue="new BStatusSchema()", flags=1034, override=true), @NiagaraProperty(name="mappings", type="BCompositeMap", defaultValue="new BCompositeMap()")})
public class BCompositeNode
extends BGraphNode
implements BIAgent {
    @Generated
    public static final Property transformInputs = BCompositeNode.newProperty((int)1034, (BValue)new BStatusSchema(), null);
    @Generated
    public static final Property mappings = BCompositeNode.newProperty((int)0, (BValue)new BCompositeMap(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCompositeNode.class);
    private static final String SCHEMA_FAULT_DUPLICATE_KEYS = "fault.msg.schema.invalidkeys";

    @Generated
    public BCompositeMap getMappings() {
        return (BCompositeMap)this.get(mappings);
    }

    @Generated
    public void setMappings(BCompositeMap v) {
        this.set(mappings, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputs, GraphNodeParams params, BOrd base) throws TransformException {
        Map<String, CompositeMapping> compMaps = Arrays.stream(inputs).filter(Objects::nonNull).collect(Collectors.toMap(BSeriesTransformTable::getSeriesName, CompositeMapping::new));
        BCompositeMap mappings = this.getMappings();
        LinkedList<CompositeMapping> list = new LinkedList<CompositeMapping>();
        for (BCompositeMapping mapping : (BCompositeMapping[])mappings.getChildren(BCompositeMapping.class)) {
            String targetField = mapping.getOutputField();
            String srcField = mapping.getInputField();
            String srcSeriesName = mapping.getSrcSeries();
            CompositeMapping map = compMaps.get(srcSeriesName);
            if (null == map) {
                throw new LocalizableRuntimeException("seriesTransform", "resolve.err.sourceseries.invalid", (Object[])new String[]{srcSeriesName, this.getDisplayName(null)});
            }
            map.addPropertyMapping(srcField, targetField);
            if (list.contains(map)) continue;
            list.add(map);
        }
        CompositeMapping[] cmaps = list.toArray(new CompositeMapping[0]);
        BCompositeTable table = new BCompositeTable(this.getName(), this.getSchema(), cmaps);
        return new BSeriesTransformTable[]{table};
    }

    public BIcon getIcon() {
        String iconsrc = lex.getText("composite.icon");
        return BIcon.make((BOrd)BOrd.make((String)iconsrc));
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BSeriesSchema schema = new BSeriesSchema();
        this.addSchemaKey(schema);
        Map<String, BGraphNode> srcMap = Arrays.stream(this.getSources()).collect(Collectors.toMap(BComplex::getName, src -> src));
        BCompositeMap mappings = this.getMappings();
        for (BCompositeMapping mapping : (BCompositeMapping[])mappings.getChildren(BCompositeMapping.class)) {
            String outField = mapping.getOutputField();
            String srcField = mapping.getInputField();
            String srcSeriesName = mapping.getSrcSeries();
            BFacets fieldFacets = mapping.getFieldFacets();
            BGraphNode src2 = srcMap.get(srcSeriesName);
            if (null == src2) continue;
            BSeriesSchema srcSchema = src2.getSchema();
            BTypeSpec srcType = srcSchema.getFieldType(srcField);
            if (null != schema.get(outField)) {
                BTypeSpec outType = schema.getFieldType(outField);
                BFacets outFacets = schema.getFieldFacets(outField);
                if (outType.equals((Object)srcType) && fieldFacets.equals((Object)outFacets)) continue;
                schema.removeField(outField);
            }
            schema.addField(outField, srcType, fieldFacets);
        }
        return schema;
    }

    private void addSchemaKey(BSeriesSchema schema) {
        BGraphNode[] sources = this.getSources();
        BFacets commonKeyFacets = BFacets.make((String)"primaryKeyField", (boolean)true);
        String commonKeyField = null;
        BTypeSpec commonKeyType = null;
        for (BGraphNode source : sources) {
            BSeriesSchema srcSchema = source.getSchema();
            if (srcSchema.getFieldNames().length == 0) continue;
            String keyField = srcSchema.getKeyField();
            if (null == commonKeyField) {
                commonKeyField = keyField;
            } else if (!commonKeyField.equals(keyField)) {
                throw new BajaRuntimeException(lex.getText(SCHEMA_FAULT_DUPLICATE_KEYS));
            }
            BTypeSpec fieldType = srcSchema.getFieldType(keyField);
            if (null == commonKeyType) {
                commonKeyType = fieldType;
            }
            if (null == fieldType || !commonKeyType.equals((Object)fieldType)) {
                throw new BajaRuntimeException(lex.getText(SCHEMA_FAULT_DUPLICATE_KEYS));
            }
            BFacets fieldFacets = srcSchema.getFieldFacets(keyField);
            if (fieldFacets.equals((Object)BFacets.NULL)) continue;
            commonKeyFacets = BFacets.make((BFacets)commonKeyFacets, (BFacets)fieldFacets);
        }
        if (null != commonKeyField && null != commonKeyType) {
            schema.addField(commonKeyField, commonKeyType, commonKeyFacets);
        }
    }

    @Override
    public void doCheckSchema() throws ConfigException {
        String keyField = this.getPrimaryKeyField();
        Set<String> fields = this.getAllInputFields(keyField);
        BCompositeMap compositeMap = this.getMappings();
        for (BCompositeMapping mapping : (BCompositeMapping[])compositeMap.getChildren(BCompositeMapping.class)) {
            String field = String.join((CharSequence)".", mapping.getSrcSeries(), mapping.getInputField());
            if (fields.contains(field)) continue;
            String msg = lex.getText("fault.msg.schema.invalidField", new Object[]{field});
            throw new ConfigException(msg);
        }
    }

    private String getPrimaryKeyField() {
        BGraphNode[] sources = this.getSources();
        String keyField = null;
        if (sources.length > 0) {
            BGraphNode src = sources[0];
            BSeriesSchema schema = src.getSchema();
            keyField = schema.getKeyField();
        }
        return keyField;
    }

    private Set<String> getAllInputFields(String keyField) {
        return Arrays.stream(this.getSrcFieldNames()).filter(s -> {
            String[] split = TextUtil.split((String)s, (char)'.');
            String fieldName = split[1];
            return !fieldName.equals(keyField);
        }).collect(Collectors.toSet());
    }

    public void changed(Property property, Context context) {
        if (context != Context.decoding && property == mappings) {
            this.fireSchemaModified(this.getSchema());
            this.schemaCheck();
        }
        super.changed(property, context);
    }
}

