/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.cleanser;

import com.tridium.seriestransform.cleanser.BCleanserTable;
import com.tridium.seriestransform.cleanser.detectors.BNanDetector;
import com.tridium.seriestransform.cleanser.interfaces.BIDetector;
import com.tridium.seriestransform.cleanser.interfaces.BIReplacer;
import com.tridium.seriestransform.cleanser.replacers.BReplaceWithZero;
import java.util.LinkedList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="detectorType", type="BTypeSpec", defaultValue="BTypeSpec.make(\"seriesTransform\", \"NanDetector\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"seriesTransform:IDetector\")")}), @NiagaraProperty(name="replacerType", type="BTypeSpec", defaultValue="BTypeSpec.make(\"seriesTransform\", \"ReplaceWithZero\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"seriesTransform:IReplacer\")")})})
public class BCleanserNode
extends BGraphNode {
    @Generated
    public static final Property detectorType = BCleanserNode.newProperty((int)0, (BValue)BTypeSpec.make((String)"seriesTransform", (String)"NanDetector"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"seriesTransform:IDetector")));
    @Generated
    public static final Property replacerType = BCleanserNode.newProperty((int)0, (BValue)BTypeSpec.make((String)"seriesTransform", (String)"ReplaceWithZero"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"seriesTransform:IReplacer")));
    @Generated
    public static final Type TYPE = Sys.loadType(BCleanserNode.class);

    @Generated
    public BTypeSpec getDetectorType() {
        return (BTypeSpec)this.get(detectorType);
    }

    @Generated
    public void setDetectorType(BTypeSpec v) {
        this.set(detectorType, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getReplacerType() {
        return (BTypeSpec)this.get(replacerType);
    }

    @Generated
    public void setReplacerType(BTypeSpec v) {
        this.set(replacerType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCleanserNode() {
        this.setDetectorType(BTypeSpec.make((Type)BNanDetector.TYPE));
        this.setReplacerType(BTypeSpec.make((Type)BReplaceWithZero.TYPE));
    }

    @Override
    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] inputTables, GraphNodeParams args, BOrd base) throws TransformException {
        BIReplacer chosenReplacer = (BIReplacer)this.getReplacerType().getInstance();
        BIDetector chosenDetector = (BIDetector)this.getDetectorType().getInstance();
        LinkedList<BCleanserTable> results = new LinkedList<BCleanserTable>();
        for (BSeriesTransformTable table : inputTables) {
            BCleanserTable cleansedTable = new BCleanserTable(this.getName(), this.getSchema(), table, chosenDetector, chosenReplacer);
            results.add(cleansedTable);
        }
        return results.toArray(new BSeriesTransformTable[0]);
    }

    @Override
    public BSeriesSchema doGetSchema() {
        BGraphNode[] inputSources = this.getSources();
        if (inputSources.length > 0) {
            BGraphNode src = inputSources[0];
            return src.getSchema();
        }
        BSeriesSchema schema = new BSeriesSchema();
        return schema;
    }

    @Override
    public void doCheckSchema() throws ConfigException {
        BTypeSpec valueType = this.getSchema().getFieldType("value");
        if (valueType == null) {
            String msg = lex.getText("cleanser.fault.badValue");
            throw new ConfigException(msg);
        }
        if (!valueType.getResolvedType().is(BINumeric.TYPE)) {
            String msg = lex.getText("cleanser.fault.badValue");
            throw new ConfigException(msg);
        }
        this.getTransformInputs().setStatus(BStatus.ok);
        this.getTransformInputs().setValue("schema");
    }

    public BIcon getIcon() {
        String iconsrc = "module://seriesTransform/icons/nodes/cleanser.png";
        return BIcon.make((String)iconsrc);
    }
}

