/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform;

import com.tridium.seriestransform.SeriesColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.sys.BFacets;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.CursorException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

public final class SeriesTransformColumns
implements ColumnList {
    private final Map<String, Column> table = new HashMap<String, Column>();
    private final List<Column> list = new ArrayList<Column>();

    public SeriesTransformColumns(SeriesColumn[] columns) {
        for (SeriesColumn column : columns) {
            this.addColumn(column);
        }
    }

    private void initColumns(SlotCursor<Property> slots) {
        while (slots.next()) {
            try {
                Property p = slots.property();
                String displayName = p.getDefaultDisplayName(null);
                Type type = p.getType();
                int flags = p.getDefaultFlags();
                BFacets facets = p.getFacets();
                SeriesColumn c = new SeriesColumn(p.getName(), displayName, type, flags, facets);
                this.addColumn(c);
            }
            catch (CursorException ce) {}
        }
    }

    private void addColumn(Column column) {
        this.list.add(column);
        this.table.put(column.getName(), column);
        if (this.list.size() != this.table.size()) {
            throw new BajaRuntimeException("Duplicate column: " + column.getName());
        }
    }

    public int size() {
        return this.list.size();
    }

    public Column get(int index) {
        return this.list.get(index);
    }

    public Column get(String name) {
        return this.table.get(name);
    }

    public int indexOf(String name) {
        int count = this.list.size();
        for (int i = 0; i < count; ++i) {
            if (!this.list.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Column[] list() {
        return this.list.toArray(new Column[0]);
    }
}

