/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class ValueReference
extends MibValue {
    private FileLocation location;
    private MibContext context;
    private String name;

    public ValueReference(FileLocation location, MibContext context, String name) {
        super("ReferenceToValue(" + name + ")");
        this.location = location;
        this.context = context;
        this.name = name;
    }

    @Override
    public MibValue initialize(MibLoaderLog log, MibType type) throws MibException {
        MibSymbol sym = this.getSymbol(log);
        if (sym instanceof MibValueSymbol) {
            MibValue value = ((MibValueSymbol)sym).getValue();
            if (value != null) {
                value = value.initialize(log, type);
            }
            if (value == null) {
                return null;
            }
            try {
                value = value.createReference();
            }
            catch (UnsupportedOperationException e) {
                throw new MibException(this.location, e.getMessage());
            }
            if (!(value instanceof ObjectIdentifierValue)) {
                value.setReferenceSymbol((MibValueSymbol)sym);
            }
            return value;
        }
        if (sym == null) {
            String message = "undefined symbol '" + this.name + "'";
            throw new MibException(this.location, message);
        }
        String message = "referenced symbol '" + this.name + "' is not a value";
        throw new MibException(this.location, message);
    }

    public FileLocation getLocation() {
        return this.location;
    }

    public MibSymbol getSymbol() {
        return this.getSymbol(null);
    }

    private MibSymbol getSymbol(MibLoaderLog log) {
        MibSymbol sym = this.context.findSymbol(this.name, false);
        if (sym == null && (sym = this.context.findSymbol(this.name, true)) != null && log != null) {
            String message = "missing import for '" + this.name + "', using definition from " + sym.getMib().getName();
            log.addWarning(this.location, message);
        }
        return sym;
    }

    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Object toObject() {
        return null;
    }

    public String toString() {
        return "ReferenceToValue(" + this.name + ")";
    }
}

