/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.value.StringValue;

public class StringType
extends MibType {
    private Constraint constraint = null;

    public StringType() {
        this(true, null);
    }

    public StringType(Constraint constraint) {
        this(true, constraint);
    }

    private StringType(boolean primitive, Constraint constraint) {
        super("OCTET STRING", primitive);
        this.constraint = constraint;
        this.setTag(true, MibTypeTag.OCTET_STRING);
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (this.constraint != null) {
            this.constraint.initialize(this, log);
        }
        return this;
    }

    @Override
    public MibType createReference() {
        StringType type = new StringType(false, this.constraint);
        type.setTag(true, this.getTag());
        return type;
    }

    @Override
    public MibType createReference(Constraint constraint) {
        StringType type = new StringType(false, constraint);
        type.setTag(true, this.getTag());
        return type;
    }

    public boolean hasConstraint() {
        return this.constraint != null;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return this.isCompatibleType(value) && (this.constraint == null || this.constraint.isCompatible(value));
    }

    private boolean isCompatibleType(MibValue value) {
        return value instanceof StringValue;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        if (this.constraint != null) {
            buffer.append(" (");
            buffer.append(this.constraint.toString());
            buffer.append(")");
        }
        return buffer.toString();
    }
}

