/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;

public class MibbleValidator {
    private static final String COMMAND_HELP = "Validates a set of SNMP MIB files. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibbleValidator <file(s) or URL(s)>";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";

    public static void main(String[] args) {
        File file;
        int i;
        MibLoader loader = new MibLoader();
        ArrayList<Serializable> queue = new ArrayList<Serializable>();
        int errors = 0;
        int warnings = 0;
        if (args.length < 1) {
            MibbleValidator.printHelp("No file(s) specified");
            System.exit(1);
        }
        for (i = 0; i < args.length; ++i) {
            try {
                if (args[0].contains(":")) {
                    queue.add(new URL(args[0]));
                    continue;
                }
                file = new File(args[i]);
                if (!file.exists()) {
                    System.out.println("Warning: Skipping " + args[i] + ": file not found");
                    continue;
                }
                if (file.isDirectory()) {
                    MibbleValidator.addMibs(file, queue);
                    continue;
                }
                queue.add(file);
                continue;
            }
            catch (MalformedURLException e) {
                System.out.println("Warning: Skipping " + args[i] + ": " + e.getMessage());
            }
        }
        for (i = 0; i < queue.size(); ++i) {
            Object src = queue.get(i);
            System.out.print(i);
            System.out.print("/");
            System.out.print(queue.size());
            System.out.print(": Reading " + src + "... ");
            System.out.flush();
            try {
                Mib mib;
                loader.unloadAll();
                if (src instanceof URL) {
                    loader.removeAllDirs();
                    mib = loader.load((URL)src);
                } else {
                    file = (File)src;
                    if (!loader.hasDir(file.getParentFile())) {
                        loader.removeAllDirs();
                        loader.addDir(file.getParentFile());
                    }
                    mib = loader.load(file);
                }
                System.out.println("[OK]");
                if (mib.getLog().warningCount() <= 0) continue;
                mib.getLog().printTo(System.out);
                ++warnings;
                continue;
            }
            catch (FileNotFoundException e) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(src.toString(), e);
                ++errors;
                continue;
            }
            catch (IOException e) {
                System.out.println("[FAILED]");
                MibbleValidator.printError(src.toString(), e);
                ++errors;
                continue;
            }
            catch (MibLoaderException e) {
                System.out.println("[FAILED]");
                e.getLog().printTo(System.out);
                ++errors;
                continue;
            }
            catch (RuntimeException e) {
                System.out.println();
                MibbleValidator.printInternalError(e);
                System.exit(1);
            }
        }
        System.out.println();
        System.out.println("Files processed:  " + queue.size());
        System.out.println("  with errors:    " + errors);
        System.out.println("  with warnings:  " + warnings);
        if (errors > 0) {
            System.err.println("Error: validation errors were encountered");
        }
        System.exit(errors);
    }

    private static void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            System.err.print("Error: ");
            System.err.println(error);
            System.err.println();
        }
    }

    private static void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private static void printError(String file, FileNotFoundException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open file:");
        buffer.append("\n    ");
        buffer.append(file);
        System.out.println(buffer.toString());
    }

    private static void printError(String url, IOException e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Error: couldn't open URL:");
        buffer.append("\n    ");
        buffer.append(url);
        System.out.println(buffer.toString());
    }

    private static void addMibs(File dir, ArrayList queue) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isHidden()) continue;
            if (files[i].isDirectory()) {
                MibbleValidator.addMibs(files[i], queue);
                continue;
            }
            if (!MibbleValidator.isMib(files[i])) continue;
            queue.add(files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMib(File file) {
        BufferedReader in = null;
        StringBuffer buffer = new StringBuffer();
        int line = 0;
        if (!file.canRead() || !file.isFile()) {
            return false;
        }
        try {
            String str;
            in = new BufferedReader(new FileReader(file));
            while (line++ < 100 && (str = in.readLine()) != null) {
                buffer.append(str);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.indexOf("DEFINITIONS") > 0 && buffer.indexOf("::=") > 0 && buffer.indexOf("BEGIN") > 0;
    }
}

