/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;

public class VisualBasicComment
extends CodeElement {
    public static final int DOCUMENTATION = 0;
    public static final int SINGLELINE = 1;
    private int type;
    private String comment;

    public VisualBasicComment(String comment) {
        this(0, comment);
    }

    public VisualBasicComment(int type, String comment) {
        this.type = 0 <= type && type <= 1 ? type : 0;
        this.comment = comment;
    }

    @Override
    public int category() {
        return 0;
    }

    @Override
    public void print(PrintWriter out, CodeStyle style, int indent) {
        int pos;
        String indentStr = style.getIndent(indent);
        String restLines = this.comment;
        while ((pos = restLines.indexOf(10)) >= 0) {
            String firstLine = restLines.substring(0, pos);
            restLines = restLines.substring(pos + 1);
            this.printLine(out, indentStr, firstLine);
        }
        this.printLine(out, indentStr, restLines);
    }

    private void printLine(PrintWriter out, String indent, String line) {
        if (this.type == 0) {
            out.println(indent + "'''" + line);
        } else if (line.equals("")) {
            out.println(indent + "'");
        } else {
            out.println(indent + "' " + line);
        }
    }
}

