/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.csharp;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpType;

public class CSharpEnumeration
extends CSharpType {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_INTERNAL = 2;
    public static final int PROTECTED = 3;
    public static final int INTERNAL = 4;
    public static final int PRIVATE = 5;
    public static final int NEW = 16;
    Constant last = null;

    public CSharpEnumeration(String name) {
        this(1, name);
    }

    public CSharpEnumeration(int modifiers, String name) {
        super(modifiers, name, "");
    }

    @Override
    public int category() {
        return 3;
    }

    public void addConstant(String name) {
        this.addConstant(name, null);
    }

    public void addConstant(String name, String value) {
        this.addConstant(name, value, null);
    }

    public void addConstant(String name, String value, CSharpComment comment) {
        Constant c = new Constant(name, value);
        if (comment != null) {
            c.setComment(comment);
        }
        this.addElement(c);
        this.last = c;
    }

    @Override
    public void print(PrintWriter out, CodeStyle style, int indent) {
        this.print(out, style, indent, "enum");
    }

    @Override
    protected void printSeparator(PrintWriter out, CodeStyle style, CodeElement prev, CodeElement next) {
    }

    private class Constant
    extends CodeElement {
        private String name;
        private String value;
        private CSharpComment comment;

        public Constant(String name, String value) {
            this.name = name;
            this.value = value;
            this.comment = null;
        }

        @Override
        public int category() {
            return 0;
        }

        public void setComment(CSharpComment comment) {
            this.comment = comment;
        }

        @Override
        public void print(PrintWriter out, CodeStyle style, int indent) {
            if (this.comment != null) {
                out.println();
                this.comment.print(out, style, indent);
            }
            out.print(style.getIndent(indent));
            out.print(this.name);
            if (this.value != null) {
                out.print(" = ");
                out.print(this.value);
            }
            if (this != CSharpEnumeration.this.last) {
                out.print(",");
            }
            out.println();
        }
    }
}

