/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.util;

import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecurityInitializer;
import com.tridiumx.nacDriver.util.Utils;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class NACOSDPKeyRingUtils {
    private static final String KEY_RING_ENTRY_TYPE = "nacDriver";
    private static final String KEY_ENTRY_TYPE = "KeyStorePassword";
    public static final Logger LOG = Logger.getLogger("nacDriverKeyStore");

    public static KeyRing loadKeyRing() {
        try {
            return SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
        }
        catch (Exception e) {
            Utils.logException(LOG, e, Level.SEVERE, "Failed to load keyRing Instance");
            return null;
        }
    }

    public static void saveKeyToKeyRing(KeyRing keyRing) {
        try {
            keyRing.setKey(NACOSDPKeyRingUtils.getKeyRingAlias(), Objects.requireNonNull(NACOSDPKeyRingUtils.generateKeyRingPassword()).getEncoded(), true);
        }
        catch (Exception e) {
            Utils.logException(LOG, e, Level.SEVERE, "Failed to store Key " + NACOSDPKeyRingUtils.getKeyRingAlias() + " to KeyRing");
        }
    }

    public static SecretBytes getKeyFromKeyRing(KeyRing keyRing) {
        try {
            byte[] value = keyRing.getKey(NACOSDPKeyRingUtils.getKeyRingAlias());
            if (value != null) {
                return new SecretBytes(value, true);
            }
        }
        catch (Exception e) {
            Utils.logException(LOG, e, Level.SEVERE, "Failed to load Key " + NACOSDPKeyRingUtils.getKeyRingAlias() + " to KeyRing");
        }
        return null;
    }

    private static SecretKey generateKeyRingPassword() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("HmacSHA256");
            keyGen.init(256);
            SecretKey key = keyGen.generateKey();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            Utils.logException(LOG, e, Level.SEVERE, "Failed to generate new KeyRing password");
            return null;
        }
    }

    public static String getKeyRingAlias() {
        return "nacDriver.KeyStorePassword";
    }
}

