/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.ui;

import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.enums.BNACReaderTypeEnum;
import com.tridiumx.nacDriver.point.BNACPointFolder;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;

@NiagaraType(agent={@AgentOn(types={"nacDriver:NACPointDeviceExt", "nacDriver:NACPointFolder"}, requiredPermissions="r")})
public class BNACReaderManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BNACReaderManager.class);
    MgrColumn[] cols = new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BNACReader.enabled, 3), new MgrColumn.Prop(BNACReader.status), new MgrColumn.Prop(BNACReader.readerType, 1), new MgrColumn.Prop(BNACReader.address, 1), new OsdpAddressColumn(), new MgrColumn.Prop(BNACReader.assignment)};

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    static class OsdpAddressColumn
    extends MgrColumn.Prop {
        public OsdpAddressColumn() {
            super(BNACReader.OSDPAddress, 1);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BNACReader reader = (BNACReader)row;
            if (reader.getReaderType().equals((Object)BNACReaderTypeEnum.wiegand)) {
                return "";
            }
            return super.toDisplayString(row, value, cx);
        }
    }

    static class Controller
    extends FolderController {
        Controller(BFolderManager mgr) {
            super(mgr);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            this.allDescendants.setSelected(true);
            this.newCommand.setFlags(0);
            this.newFolder.setFlags(0);
            return super.makeCommands();
        }
    }

    class Model
    extends FolderModel {
        Model(BFolderManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BNACReaderManager.this.cols;
        }

        public Type getFolderType() {
            return BNACPointFolder.TYPE;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BNACReader.TYPE};
        }
    }
}

