/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.ui;

import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.doors.BNACAccessDoor;
import com.tridiumx.nacDriver.doors.BNACExitDoor;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.point.BNACIOPoint;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType(agent={@AgentOn(types={"nacDriver:NACPointDeviceExt", "nacDriver:NACPointFolder"}, requiredPermissions="r")})
public class BNACPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BNACPointManager.class);
    static Lexicon lex = Lexicon.make(BNACPointManager.class);
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colToString = new MgrColumn.ToString("Out", 0);
    MgrColumn colManager = new ManagedByColumn();
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BNACIOPoint.enabled}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colWriteValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colToString, this.colManager, this.colEnabled, this.colFacets, this.colTuning, this.colDeviceFacets, this.colConversion, this.colFaultCause, this.colReadValue, this.colWriteValue};

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    private static class ManagedByColumn
    extends MgrColumn {
        public ManagedByColumn() {
            super(lex.getText("managedByCol.displayName"), 4);
        }

        public Object get(Object row) {
            String result = null;
            for (BComplex parent = ((BComponent)row).getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof BNACExitDoor || parent instanceof BNACReader) {
                    result = result == null ? parent.getDisplayName(null) : parent.getDisplayName(null) + "." + result;
                    continue;
                }
                if (!(parent instanceof BNACAccessDoor) && !(parent instanceof BNACDevice)) continue;
                result = result == null ? parent.getDisplayName(null) : parent.getDisplayName(null) + "." + result;
                return result;
            }
            return "";
        }
    }

    class Controller
    extends PointController {
        Controller(BPointManager mgr) {
            super(mgr);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            this.allDescendants.setSelected(true);
            return super.makeCommands();
        }
    }

    class Model
    extends PointModel {
        Model(BPointManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BNACPointManager.this.cols;
        }

        public boolean accept(BComponent c) {
            return !Flags.isHidden((BComplex)c.getParent(), (Slot)c.getPropertyInParent());
        }
    }
}

