/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.point;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.point.BINACIOControlPoint;
import com.tridiumx.nacDriver.point.BNACProxyExt;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;

public class NACIORequestHandler {
    protected BINACIOControlPoint point;

    public NACIORequestHandler(BINACIOControlPoint point) {
        this.point = point;
    }

    public void storeMapping(int unid) {
        this.point.setUnid(unid);
        this.getNACNetwork().storeMapping(unid, this.point.getHandle());
    }

    public void addToServer(boolean partOfSync) {
        Utils.checkNACPermission();
        this.getNACNetwork().postAsync(() -> {
            if (!partOfSync && this.getNACNetwork().getSyncingToServer()) {
                this.getNACNetwork().getLogger().log(Level.WARNING, "Cannot add to server when syncing is in progress");
                return;
            }
            if (this.point.getUnid() == 0) {
                AccessController.doPrivileged(() -> {
                    NACRequestUtils.addNewIOPoint(this.getNACNetwork(), this.point);
                    this.syncToServer();
                    return null;
                });
            }
        });
    }

    public void syncToServer() {
        Runnable r = () -> {
            this.syncParameters();
            this.updateValue();
        };
        Utils.runSyncToServer(this.getNACNetwork(), this.point.isTaskInQueue(), r, 1000L);
    }

    protected void syncParameters() {
        this.getNACNetwork().postAsync(() -> {
            if (this.point.getUnid() == 0) {
                return;
            }
            String uri = "/dev/update/" + this.point.getUnid();
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken()));
            String body = this.getSyncParametersBody();
            if (body == null || body.isEmpty()) {
                return;
            }
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            request.setData(body);
            try {
                this.getNACNetwork().sendHttpRequest(request);
            }
            catch (Exception e) {
                Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
            }
        });
    }

    protected String getSyncParametersBody() {
        return "enabled=" + this.point.getEnabled();
    }

    public void updateValue() {
        this.getNACNetwork().postAsync(() -> {
            try {
                if (!this.point.getEnabled()) {
                    ((BNACProxyExt)this.point.getProxyExt()).setStale(true, null);
                    return;
                }
                JSONObject response = AccessController.doPrivileged(() -> {
                    try {
                        return NACRequestUtils.showResource(this.getNACNetwork(), "devStateRecord", String.valueOf(this.point.getUnid()), 1);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                JSONObject instance = response.getJSONObject("instance");
                JSONObject devState = instance.getJSONObject("devState");
                this.updateState(devState);
            }
            catch (Exception e) {
                Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
                ((BNACProxyExt)this.point.getProxyExt()).setStale(true, null);
            }
        });
    }

    public void updateState(JSONObject devState) {
        JSONArray array = devState.getJSONArray("devAspectStates");
        for (Object elem : array) {
            JSONObject elemJson = (JSONObject)elem;
            if (elemJson.getInt("key") != 0 || elemJson.getJSONObject("value").optBoolean("doorModeStale") || elemJson.getJSONObject("value").getBoolean("activityStateStale")) continue;
            BEnumRange range = (BEnumRange)this.point.getFacets().get("range");
            BStatusEnum statusEnum = new BStatusEnum((BEnum)BDynamicEnum.make((int)elemJson.getJSONObject("value").getInt("activityState"), (BEnumRange)range));
            ((BNACProxyExt)this.point.getProxyExt()).readOk((BStatusValue)statusEnum);
            return;
        }
        ((BNACProxyExt)this.point.getProxyExt()).setStale(true, null);
    }

    public String getAddToServerBody() {
        return null;
    }

    public BNACNetwork getNACNetwork() {
        return Utils.getNACNetwork((BComponent)this.point);
    }
}

