/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.point;

import com.tridiumx.nacDriver.BINACMappable;
import com.tridiumx.nacDriver.doors.BNACAccessDoor;
import com.tridiumx.nacDriver.doors.BNACSecAlarmSourceExt;
import com.tridiumx.nacDriver.point.BNACIOPoint;
import com.tridiumx.nacDriver.point.BNACPointDeviceExt;
import com.tridiumx.nacDriver.point.BNACPointFolder;
import com.tridiumx.nacDriver.point.BNACProxyExt;
import com.tridiumx.nacDriver.point.NACIORequestHandler;
import javax.baja.control.BPointExtension;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="normallyOpen", type="boolean", defaultValue="false")
public class BNACSensorPoint
extends BNACIOPoint
implements BINACMappable {
    public static final Property normallyOpen = BNACSensorPoint.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BNACSensorPoint.class);

    public boolean getNormallyOpen() {
        return this.getBoolean(normallyOpen);
    }

    public void setNormallyOpen(boolean v) {
        this.setBoolean(normallyOpen, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNACSensorPoint(boolean normallyOpen) {
        this.setNormallyOpen(normallyOpen);
    }

    public BNACSensorPoint() {
    }

    public void started() throws Exception {
        super.started();
        this.initAlarmExt();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNACAccessDoor || parent instanceof BNACPointDeviceExt || parent instanceof BNACPointFolder;
    }

    private void initAlarmExt() {
        if (this.isValidAlarmPoint()) {
            BNACSecAlarmSourceExt alarmExt = new BNACSecAlarmSourceExt(this.getName());
            if (!this.hasNACDoorAlarmExt()) {
                this.add(SlotPath.escape((String)this.getLexicon().getText("accessDoor.alarmExt", new Object[]{this.getDisplayName(null)})), (BValue)alarmExt);
            }
        }
    }

    public boolean hasNACDoorAlarmExt() {
        BPointExtension[] ext;
        for (BPointExtension bPointExtension : ext = this.getExtensions()) {
            if (!bPointExtension.getType().equals(BNACSecAlarmSourceExt.TYPE)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidAlarmPoint() {
        return this.getName().equals(BNACPointDeviceExt.tamper.getName()) || this.getName().equals(BNACPointDeviceExt.batteryFail.getName()) || this.getName().equals(BNACPointDeviceExt.acFail.getName());
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning() || context != null && context.equals(Context.decoding)) {
            return;
        }
        super.changed(property, context);
        if (property.equals(enabled) || property.equals(normallyOpen)) {
            ((BNACProxyExt)this.getProxyExt()).setStale(true, null);
            this.syncToServer();
        }
    }

    @Override
    protected NACSensorRequestHandler getRequestHandler() {
        if (this.handler == null) {
            this.handler = new NACSensorRequestHandler(this);
        }
        return (NACSensorRequestHandler)this.handler;
    }

    @Override
    public boolean isInputPoint() {
        return true;
    }

    static class NACSensorRequestHandler
    extends NACIORequestHandler {
        public NACSensorRequestHandler(BNACSensorPoint point) {
            super(point);
        }

        @Override
        protected String getSyncParametersBody() {
            BNACSensorPoint sensor = (BNACSensorPoint)this.point;
            StringBuilder body = new StringBuilder();
            body.append("sensorConfig.invert=").append(sensor.getNormallyOpen());
            if (super.getSyncParametersBody() != null) {
                body.append("&").append(super.getSyncParametersBody());
            }
            return body.toString();
        }
    }
}

