/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.point;

import com.tridiumx.nacDriver.enums.BNACActivityStateEnum;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.point.BNACIOPoint;
import com.tridiumx.nacDriver.point.NACIORequestHandler;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="serverValue", type="BNACActivityStateEnum", defaultValue="BNACActivityStateEnum.DEFAULT")
public class BNACActuatorPoint
extends BNACIOPoint {
    public static final Property serverValue = BNACActuatorPoint.newProperty((int)0, (BValue)BNACActivityStateEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BNACActuatorPoint.class);

    public BNACActivityStateEnum getServerValue() {
        return (BNACActivityStateEnum)this.get(serverValue);
    }

    public void setServerValue(BNACActivityStateEnum v) {
        this.set(serverValue, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.updateFlags();
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning() || context != null && context.equals(Context.decoding)) {
            return;
        }
        super.changed(property, context);
        if (property.equals(serverValue)) {
            this.syncToServer();
        }
    }

    private void updateFlags() {
        if (this.canSendValueToServer()) {
            this.setFlags((Slot)serverValue, this.getFlags((Slot)serverValue) & 0xFFFFFFFB & 0xFFFFFFFE);
        } else {
            this.setFlags((Slot)serverValue, this.getFlags((Slot)serverValue) | 4 | 1);
        }
    }

    @Override
    protected NACIORequestHandler getRequestHandler() {
        if (this.handler == null) {
            this.handler = new NACActuatorRequestHandler(this);
        }
        return this.handler;
    }

    public boolean canSendValueToServer() {
        return false;
    }

    public boolean getBooleanServerValue() {
        return !this.getServerValue().equals((Object)BNACActivityStateEnum.inactive);
    }

    @Override
    public boolean isOutputPoint() {
        return true;
    }

    static class NACActuatorRequestHandler
    extends NACIORequestHandler {
        public NACActuatorRequestHandler(BNACActuatorPoint point) {
            super(point);
        }

        @Override
        public void syncToServer() {
            Runnable r = () -> {
                this.syncParameters();
                this.sendValueToServer();
                this.updateValue();
            };
            Utils.runSyncToServer(this.getNACNetwork(), this.point.isTaskInQueue(), r, 1000L);
        }

        private void sendValueToServer() {
            BNACActuatorPoint actuator = (BNACActuatorPoint)this.point;
            if (!actuator.canSendValueToServer()) {
                return;
            }
            this.getNACNetwork().postAsync(() -> {
                if (actuator.getUnid() == 0) {
                    return;
                }
                String uri = "/json/actuatorControl?unid=" + actuator.getUnid() + "&value=" + actuator.getBooleanServerValue();
                NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken()));
                try {
                    this.getNACNetwork().sendHttpRequest(request);
                }
                catch (Exception e) {
                    Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
                }
            });
        }
    }
}

