/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.message;

import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.nre.security.SecretChars;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;

public class NACServerAuthenticateRequest
extends NHttpRequest {
    public NACServerAuthenticateRequest(BIpAddress address, BUsernameAndPassword usernameAndPassword) {
        super(address, "GET", NACServerAuthenticateRequest.setUri(usernameAndPassword).asString(true));
    }

    private static SecretChars setUri(BUsernameAndPassword usernameAndPassword) {
        Utils.checkNACPermission();
        String username = usernameAndPassword.getUsername();
        try (SecretChars password = AccessController.doPrivileged(() -> ((BPassword)usernameAndPassword.getPassword()).getSecretChars());){
            SecretChars secretChars = new SecretChars(String.format("/authenticate?username=%s&password=%s", username, password.asString(true)).toCharArray(), true);
            return secretChars;
        }
    }
}

