/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.learn;

import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.enums.BDevModEnum;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceName", type="String", defaultValue=""), @NiagaraProperty(name="address", type="String", defaultValue=""), @NiagaraProperty(name="port", type="int", defaultValue="443"), @NiagaraProperty(name="numberOfDoors", type="int", defaultValue="0"), @NiagaraProperty(name="devMod", type="BDevModEnum", defaultValue="BDevModEnum.DEFAULT")})
public class BNACAccessLearnDeviceEntry
extends BComponent {
    public static final Property deviceName = BNACAccessLearnDeviceEntry.newProperty((int)0, (String)"", null);
    public static final Property address = BNACAccessLearnDeviceEntry.newProperty((int)0, (String)"", null);
    public static final Property port = BNACAccessLearnDeviceEntry.newProperty((int)0, (int)443, null);
    public static final Property numberOfDoors = BNACAccessLearnDeviceEntry.newProperty((int)0, (int)0, null);
    public static final Property devMod = BNACAccessLearnDeviceEntry.newProperty((int)0, (BValue)BDevModEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BNACAccessLearnDeviceEntry.class);

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String v) {
        this.setString(address, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public int getNumberOfDoors() {
        return this.getInt(numberOfDoors);
    }

    public void setNumberOfDoors(int v) {
        this.setInt(numberOfDoors, v, null);
    }

    public BDevModEnum getDevMod() {
        return (BDevModEnum)this.get(devMod);
    }

    public void setDevMod(BDevModEnum v) {
        this.set(devMod, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNACAccessLearnDeviceEntry() {
    }

    public BNACAccessLearnDeviceEntry(JSONObject object, String address) throws Exception {
        this.setDeviceName(object.getString("name"));
        this.setAddress(address);
        try {
            BDevModEnum devMod = BDevModEnum.make(object.getInt("devMod"));
            this.setDevMod(devMod);
            this.setNumberOfDoors(Integer.parseInt(devMod.getTag().split("Series")[1].split("Door")[0]));
        }
        catch (Exception e) {
            throw new Exception(this.getLexicon().get("unsupportedDeviceType"));
        }
    }
}

