/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.job;

import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BUpgradeNACFirmwareJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BUpgradeNACFirmwareJob.class);
    private BNACDevice[] nacDeviceList;
    private int firmwareUnid;
    private String firmwareName;

    public Type getType() {
        return TYPE;
    }

    public BUpgradeNACFirmwareJob() {
    }

    public BUpgradeNACFirmwareJob(BNACDevice[] bnacDevices, int firmwareUnid, String firmwareName) {
        this.nacDeviceList = bnacDevices;
        this.firmwareUnid = firmwareUnid;
        this.firmwareName = firmwareName;
    }

    public void run(Context context) throws Exception {
        this.progress(0);
        AtomicBoolean isSuccess = new AtomicBoolean(true);
        int upgradeFirmwareProgress = 80 / this.nacDeviceList.length;
        for (BNACDevice nacDevice : this.nacDeviceList) {
            if (nacDevice != null) {
                NACRequestUtils.subscribeComponent((BComponent)nacDevice);
                if (nacDevice.getStatus().isValid()) {
                    if (nacDevice.getUnid() != 0) {
                        try {
                            JSONObject rebootControllerResponse;
                            JSONObject softwareFirmwareUpdateResponse = NACRequestUtils.updateControllerFirmware(nacDevice, this.firmwareUnid);
                            if (softwareFirmwareUpdateResponse.isEmpty() && (rebootControllerResponse = NACRequestUtils.rebootController(nacDevice)).isEmpty()) {
                                nacDevice.setFirmwareVersion(this.firmwareName);
                                this.log().message("Firmware update initiated for " + nacDevice.getDisplayName(null));
                            }
                        }
                        catch (Exception e) {
                            isSuccess.set(false);
                            if (e.getMessage().contains("503")) {
                                this.log().failed("Firmware update not initiated for " + nacDevice.getDisplayName(null) + " as controller is offline");
                            }
                            this.log().failed("Firmware update not initiated for " + nacDevice.getDisplayName(null) + ". Server error: " + e.getMessage());
                            nacDevice.getLogger().log(Level.SEVERE, "Firmware update not initiated for " + nacDevice.getDisplayName(null) + ". Server error: " + e.getMessage());
                        }
                    } else {
                        this.log().failed("Firmware update not initiated for " + nacDevice.getDisplayName(null) + ". Unid is empty");
                        nacDevice.getLogger().log(Level.SEVERE, "Firmware update not initiated for " + nacDevice.getDisplayName(null) + ". Unid is empty");
                        isSuccess.set(false);
                    }
                } else {
                    this.log().failed("Firmware update not initiated for " + nacDevice.getDisplayName(null) + ". Status is " + nacDevice.getStatus());
                    nacDevice.getLogger().log(Level.SEVERE, "Firmware update not initiated for " + nacDevice.getDisplayName(null) + ". Status is " + nacDevice.getStatus());
                    isSuccess.set(false);
                }
            }
            this.progress(upgradeFirmwareProgress);
            upgradeFirmwareProgress += upgradeFirmwareProgress;
        }
        this.progress(100);
        if (!isSuccess.get()) {
            this.failed(new Exception("Firmware update process failed"));
            throw new Exception("Firmware update process failed");
        }
        this.log().success("Firmware update process successfully completed");
    }
}

