/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.job;

import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.firmware.BNACFirmwareInstance;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.file.BIFile;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BStoreNACFirmwareFileJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BStoreNACFirmwareFileJob.class);
    private BNACFirmwareInstance firmwareInstance;
    private BOrd fileOrd;

    public Type getType() {
        return TYPE;
    }

    public BStoreNACFirmwareFileJob() {
    }

    public BStoreNACFirmwareFileJob(BNACFirmwareInstance firmwareInstance, BOrd fileOrd) {
        this.firmwareInstance = firmwareInstance;
        this.fileOrd = fileOrd;
    }

    public void run(Context context) throws Exception {
        this.storeFileOnNACServer(context);
    }

    public void storeFileOnNACServer(Context cx) throws Exception {
        boolean isSuccess = true;
        try {
            this.progress(10);
            BNACNetwork nacNetwork = this.firmwareInstance.getNACNetwork();
            if (nacNetwork != null && nacNetwork.getStatus().isValid()) {
                BIFile file = (BIFile)this.fileOrd.resolve(null, cx).get();
                if (file != null) {
                    String fileExtension = FileUtil.getExtension((String)file.getFileName());
                    if (fileExtension.equals("upgrade")) {
                        String baseFileName = FileUtil.getBase((String)file.getFileName());
                        String body = NACRequestUtils.getFirmwareUpdateInstanceCreationBody(baseFileName, file.getFileName());
                        JSONObject firmwareInstanceResponse = NACRequestUtils.getFirmwareUpdateInstanceUnid(nacNetwork, body);
                        if (!firmwareInstanceResponse.isEmpty()) {
                            this.progress(30);
                            JSONObject instanceObject = firmwareInstanceResponse.getJSONObject("instance");
                            int firmwareInstanceUnid = instanceObject.getInt("unid");
                            JSONObject storeFileResponse = NACRequestUtils.storeFirmwareFileOnServer(nacNetwork, firmwareInstanceUnid, file.getFileName(), file);
                            if (!storeFileResponse.isEmpty()) {
                                this.progress(80);
                                this.updateFirmwareInstanceProps(storeFileResponse);
                            } else {
                                isSuccess = false;
                                this.log().failed("The NAC server failed to store the file.");
                                nacNetwork.getLogger().log(Level.SEVERE, "The NAC server failed to store the file.");
                            }
                        } else {
                            isSuccess = false;
                            this.log().failed("Create firmware instance on NAC server API request failed");
                            nacNetwork.getLogger().log(Level.SEVERE, "Create firmware instance on NAC server API request failed");
                        }
                    } else {
                        isSuccess = false;
                        this.log().failed("Please choose a firmware file with a \".upgrade\" extension.");
                        nacNetwork.getLogger().log(Level.SEVERE, "Please choose a firmware file with a \".upgrade\" extension.");
                    }
                } else {
                    this.log().failed("Please select firmware file");
                    nacNetwork.getLogger().log(Level.SEVERE, "Please select firmware file");
                    isSuccess = false;
                }
            } else {
                isSuccess = false;
                this.log().failed("Store firmware file process not initiated for " + nacNetwork.getDisplayName(null) + ". Status is " + nacNetwork.getStatus());
            }
        }
        catch (Exception ex) {
            isSuccess = false;
            this.failed(ex);
        }
        this.progress(100);
        if (!isSuccess) {
            this.failed(new Exception("The firmware image could not be uploaded to the server."));
            throw new Exception("The firmware image could not be uploaded to the server.");
        }
        this.log().success("Firmware image has been successfully uploaded to the server.");
    }

    public final void updateFirmwareInstanceProps(JSONObject storeFileResponse) throws IOException {
        int unid = storeFileResponse.getInt("unid");
        String versionName = storeFileResponse.optString("name");
        this.firmwareInstance.setSoftwareUpdateUnid(unid);
        this.firmwareInstance.setVersionName(versionName + "-" + unid);
        this.firmwareInstance.setVersionNumber(storeFileResponse.optString("versionNumber"));
        this.firmwareInstance.setFileName(storeFileResponse.optString("filename"));
        this.firmwareInstance.setFileSize(storeFileResponse.optLong("fileSize"));
        this.firmwareInstance.setLastModified(BAbsTime.make((String)storeFileResponse.optString("lastModified")));
    }
}

