/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.firmware;

import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.firmware.BNACFirmwareInstance;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
public class BNACFirmwareInstanceContainer
extends BFolder {
    public static final Type TYPE = Sys.loadType(BNACFirmwareInstanceContainer.class);

    public Type getType() {
        return TYPE;
    }

    public boolean isChildLegal(BComponent child) {
        return child.getType().is(BNACFirmwareInstance.TYPE);
    }

    public void checkRemove(Property property, Context context) {
        if (!this.isRunning() || !property.getType().is(BNACFirmwareInstance.TYPE)) {
            return;
        }
        try {
            this.deleteFirmwareInstanceFromServerPrivate(property, context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.checkRemove(property, context);
    }

    private void deleteFirmwareInstanceFromServerPrivate(Property property, Context context) throws Exception {
        try {
            AccessController.doPrivileged(() -> {
                this.deleteFirmwareInstanceFromServer(property, context);
                return null;
            });
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteFirmwareInstanceFromServer(Property property, Context context) {
        BNACFirmwareInstance firmwareInstance = (BNACFirmwareInstance)this.get(property);
        if (!firmwareInstance.getPermissions(context).hasAdminWrite()) {
            throw new RuntimeException("This action requires admin write permissions on the firmware instance");
        }
        if (firmwareInstance.getSoftwareUpdateUnid() != 0) {
            if (this.getNACNetwork().getSessionToken() == null) {
                this.getNACNetwork().log().log(Level.SEVERE, "Network session is expired");
                throw new RuntimeException("Network session is expired");
            }
            try {
                NACRequestUtils.deleteFirmwareInstanceFromServer(firmwareInstance.getSoftwareUpdateUnid(), this.getNACNetwork());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.getNACNetwork().log().log(Level.INFO, "The firmware instance deletion process is not finished because the necessary data is not available.");
        }
        this.getNACNetwork().log().log(Level.INFO, "The firmware instance [ " + firmwareInstance.getVersionName() + " ] successfully deleted from the server");
    }

    public final BNACNetwork getNACNetwork() {
        return (BNACNetwork)this.getParent();
    }
}

